/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class FlowAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="catchment area")
    public Attribute.Double cArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="direct runoff")
    public Attribute.Double dirQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="interflow")
    public Attribute.Double interflow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="base flow in mm")
    public Attribute.Double basQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="direct runoff cbm")
    public Attribute.Double dirQcbm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="interflow runoff cbm")
    public Attribute.Double infQcbm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="baseflow cbm")
    public Attribute.Double basQcbm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total outflow cbm")
    public Attribute.Double totQcbm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total outflow mm")
    public Attribute.Double totQmm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the actual time step")
    public Attribute.Calendar timeStep;

    public void init() {
    }

    public void run() {
        long days = 1L;
        if (this.timeStep != null) {
            days = this.timeStep.getActualMaximum(5);
        }
        double totOut = 0.0;
        totOut = this.interflow != null ? this.dirQ.getValue() + this.interflow.getValue() + this.basQ.getValue() : this.dirQ.getValue() + this.basQ.getValue();
        this.totQmm.setValue(totOut);
        totOut = totOut * this.cArea.getValue() / (double)(86400000L * days);
        this.totQcbm.setValue(totOut);
        this.dirQcbm.setValue(this.dirQ.getValue() * this.cArea.getValue() / (double)(86400000L * days));
        if (this.interflow != null) {
            this.infQcbm.setValue(this.interflow.getValue() * this.cArea.getValue() / (double)(86400000L * days));
        }
        this.basQcbm.setValue(this.basQ.getValue() * this.cArea.getValue() / (double)(86400000L * days));
    }

    public void cleanup() {
    }
}

