/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public abstract class NavigatedCoordinateSystem
extends CoordinateSystem {
    private final int latIndex;
    private final int lonIndex;

    public NavigatedCoordinateSystem(RealTupleType reference, Unit[] units) throws VisADException {
        super(reference, units);
        this.latIndex = reference.getIndex(RealType.Latitude);
        if (this.latIndex == -1) {
            throw new CoordinateSystemException("NavigatedCoordinateSystem: Reference must contain RealType.Latitude");
        }
        this.lonIndex = reference.getIndex(RealType.Longitude);
        if (this.lonIndex == -1) {
            throw new CoordinateSystemException("NavigatedCoordinateSystem: Reference must contain RealType.Longitude");
        }
    }

    public int getLatitudeIndex() {
        return this.latIndex;
    }

    public int getLongitudeIndex() {
        return this.lonIndex;
    }
}

