/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import nom.tam.util.PrimitiveInfo;

public class ArrayFuncs
implements PrimitiveInfo {
    public static int computeSize(Object object) {
        if (object == null) {
            return 0;
        }
        int n = 0;
        String string = object.getClass().getName();
        if (string.substring(0, 2).equals("[[") || string.equals("[Ljava.lang.String;") || string.equals("[Ljava.lang.Object;")) {
            int n2 = 0;
            while (n2 < ((Object[])object).length) {
                n += ArrayFuncs.computeSize(((Object[])object)[n2]);
                ++n2;
            }
            return n;
        }
        if (string.charAt(0) == '[' && string.charAt(1) != 'L') {
            char c = string.charAt(1);
            int n3 = 0;
            while (n3 < PrimitiveInfo.suffixes.length) {
                if (c == PrimitiveInfo.suffixes[n3]) {
                    return Array.getLength(object) * PrimitiveInfo.sizes[n3];
                }
                ++n3;
            }
            return 0;
        }
        if (string.substring(0, 10).equals("java.lang.")) {
            if ((string = string.substring(10, string.length() - 1)).equals("Int") || string.equals("Float")) {
                return 4;
            }
            if (string.equals("Double") || string.equals("Long")) {
                return 8;
            }
            if (string.equals("Short") || string.equals("Char")) {
                return 2;
            }
            if (string.equals("Byte") || string.equals("Boolean")) {
                return 1;
            }
            if (string.equals("String")) {
                return ((String)object).length();
            }
            return 0;
        }
        return 0;
    }

    public static int nElements(Object object) {
        String string = object.getClass().getName();
        if (string.charAt(1) == '[') {
            int n = 0;
            int n2 = 0;
            while (n2 < ((Object[])object).length) {
                n += ArrayFuncs.nElements(((Object[])object)[n2]);
                ++n2;
            }
            return n;
        }
        if (string.charAt(0) == '[') {
            return Array.getLength(object);
        }
        return 1;
    }

    public static Object deepClone(Object object) {
        Class<?> clazz;
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            return ArrayFuncs.genericClone(object);
        }
        if (string.charAt(1) != '[' && string.charAt(1) != 'L') {
            try {
                switch (string.charAt(1)) {
                    case 'B': {
                        return ((byte[])object).clone();
                    }
                    case 'Z': {
                        return ((boolean[])object).clone();
                    }
                    case 'C': {
                        return ((char[])object).clone();
                    }
                    case 'S': {
                        return ((short[])object).clone();
                    }
                    case 'I': {
                        return ((int[])object).clone();
                    }
                    case 'J': {
                        return ((long[])object).clone();
                    }
                    case 'F': {
                        return ((float[])object).clone();
                    }
                    case 'D': {
                        return ((double[])object).clone();
                    }
                }
                System.err.println("Unknown primtive array class:" + string);
                return null;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        int n = 1;
        while (string.charAt(n) == '[') {
            ++n;
        }
        if (string.charAt(n) != 'L') {
            clazz = ArrayFuncs.getBaseClass(object);
        } else {
            try {
                clazz = Class.forName(string.substring(n + 1, string.length() - 1));
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Internal error: class definition inconsistency: " + string);
                return null;
            }
        }
        int[] nArray = new int[n];
        nArray[0] = Array.getLength(object);
        int n2 = 1;
        while (n2 < n) {
            nArray[n2] = 0;
            ++n2;
        }
        Object object2 = ArrayFuncs.newInstance(clazz, nArray);
        int n3 = 0;
        while (n3 < nArray[0]) {
            Array.set(object2, n3, ArrayFuncs.deepClone(Array.get(object, n3)));
            ++n3;
        }
        return object2;
    }

    public static Object genericClone(Object object) {
        if (!(object instanceof Cloneable)) {
            return null;
        }
        Class[] classArray = new Class[]{};
        Object[] objectArray = new Object[]{};
        try {
            return object.getClass().getMethod("clone", classArray).invoke(object, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void copyArray(Object object, Object object2) {
        String string;
        String string2 = object.getClass().getName();
        if (!string2.equals(string = object2.getClass().getName())) {
            return;
        }
        if (string2.charAt(0) != '[') {
            return;
        }
        if (string2.charAt(1) == '[') {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray.length != objectArray2.length) {
                return;
            }
            int n = 0;
            while (n < objectArray.length) {
                ArrayFuncs.copyArray(objectArray, objectArray2);
                ++n;
            }
        }
        int n = Array.getLength(object);
        System.arraycopy(object, 0, object2, 0, n);
    }

    public static int[] getDimensions(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = -1;
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = Array.getLength(object);
            if (nArray[n3] == 0) {
                return nArray;
            }
            if (n3 != n - 1 && (object = ((Object[])object)[0]) == null) {
                return nArray;
            }
            ++n3;
        }
        return nArray;
    }

    public static Object getBaseArray(Object object) {
        String string = object.getClass().getName();
        if (string.charAt(1) == '[') {
            return ArrayFuncs.getBaseArray(((Object[])object)[0]);
        }
        return object;
    }

    public static Class getBaseClass(Object object) {
        if (object == null) {
            return Void.TYPE;
        }
        String string = object.getClass().getName();
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        if (n == 0) {
            return object.getClass();
        }
        char c = string.charAt(n);
        int n2 = 0;
        while (n2 < PrimitiveInfo.suffixes.length) {
            if (c == PrimitiveInfo.suffixes[n2]) {
                return PrimitiveInfo.classes[n2];
            }
            ++n2;
        }
        if (c == 'L') {
            try {
                return Class.forName(string.substring(n + 1, string.length() - 1));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return null;
    }

    public static int getBaseLength(Object object) {
        if (object == null) {
            return 0;
        }
        String string = object.getClass().getName();
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        if (n == 0) {
            return -1;
        }
        char c = string.charAt(n);
        int n2 = 0;
        while (n2 < PrimitiveInfo.suffixes.length) {
            if (c == PrimitiveInfo.suffixes[n2]) {
                return PrimitiveInfo.sizes[n2];
            }
            ++n2;
        }
        return -1;
    }

    public static Object generateArray(Class clazz, int[] nArray) {
        Object object = ArrayFuncs.newInstance(clazz, nArray);
        ArrayFuncs.testPattern(object, (byte)0);
        return object;
    }

    public static byte testPattern(Object object, byte by) {
        block3: {
            int[] nArray;
            block2: {
                nArray = ArrayFuncs.getDimensions(object);
                if (nArray.length <= 1) break block2;
                int n = 0;
                while (n < ((Object[])object).length) {
                    by = ArrayFuncs.testPattern(((Object[])object)[n], by);
                    ++n;
                }
                break block3;
            }
            if (nArray.length != 1) break block3;
            int n = 0;
            while (n < nArray[0]) {
                Array.setByte(object, n, by);
                by = (byte)(by + 1);
                ++n;
            }
        }
        return by;
    }

    public static String arrayDescription(Object object) {
        Class clazz = ArrayFuncs.getBaseClass(object);
        if (clazz == Void.TYPE) {
            return "NULL";
        }
        int[] nArray = ArrayFuncs.getDimensions(object);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < PrimitiveInfo.classes.length) {
            if (clazz == PrimitiveInfo.classes[n]) {
                bl = true;
                stringBuffer.append(PrimitiveInfo.types[n]);
                break;
            }
            ++n;
        }
        if (!bl) {
            stringBuffer.append(clazz.getName());
        }
        if (nArray != null) {
            stringBuffer.append("[");
            int n2 = 0;
            while (n2 < nArray.length) {
                stringBuffer.append("" + nArray[n2]);
                if (n2 < nArray.length - 1) {
                    stringBuffer.append("][");
                }
                ++n2;
            }
            stringBuffer.append("]");
        }
        return new String(stringBuffer);
    }

    public static void examinePrimitiveArray(Object object) {
        String string = object.getClass().getName();
        if (string.substring(0, 2).equals("[[") || string.equals("[Ljava.lang.Object;")) {
            System.out.println("[");
            int n = 0;
            while (n < ((Object[])object).length) {
                ArrayFuncs.examinePrimitiveArray(((Object[])object)[n]);
                ++n;
            }
            System.out.print("]");
        } else if (string.charAt(0) != '[') {
            System.out.println(string);
        } else {
            System.out.println("[" + Array.getLength(object) + "]" + string.substring(1));
        }
    }

    public static Object flatten(Object object) {
        int[] nArray = ArrayFuncs.getDimensions(object);
        if (nArray.length <= 1) {
            return object;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < nArray.length) {
            n *= nArray[n2];
            ++n2;
        }
        Object object2 = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(object), n);
        if (n == 0) {
            return object2;
        }
        int n3 = 0;
        ArrayFuncs.doFlatten(object, object2, n3);
        return object2;
    }

    protected static int doFlatten(Object object, Object object2, int n) {
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            throw new RuntimeException("Attempt to flatten non-array");
        }
        int n2 = Array.getLength(object);
        if (string.charAt(1) != '[') {
            System.arraycopy(object, 0, object2, n, n2);
            return n2;
        }
        int n3 = 0;
        Object[] objectArray = (Object[])object;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = ArrayFuncs.doFlatten(objectArray[n4], object2, n + n3);
            n3 += n5;
            ++n4;
        }
        return n3;
    }

    public static Object curl(Object object, int[] nArray) {
        String string = object.getClass().getName();
        if (string.charAt(0) != '[' || string.charAt(1) == '[') {
            throw new RuntimeException("Attempt to curl non-1D array");
        }
        int n = Array.getLength(object);
        int n2 = 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            n2 *= nArray[n3];
            ++n3;
        }
        if (n2 != n) {
            throw new RuntimeException("Curled array does not fit desired dimensions");
        }
        Class clazz = ArrayFuncs.getBaseClass(object);
        Object object2 = ArrayFuncs.newInstance(clazz, nArray);
        int n4 = 0;
        ArrayFuncs.doCurl(object, object2, nArray, n4);
        return object2;
    }

    protected static int doCurl(Object object, Object object2, int[] nArray, int n) {
        if (nArray.length == 1) {
            System.arraycopy(object, n, object2, 0, nArray[0]);
            return nArray[0];
        }
        int n2 = 0;
        int[] nArray2 = new int[nArray.length - 1];
        int n3 = 1;
        while (n3 < nArray.length) {
            nArray2[n3 - 1] = nArray[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < nArray[0]) {
            n2 += ArrayFuncs.doCurl(object, ((Object[])object2)[n4], nArray2, n + n2);
            ++n4;
        }
        return n2;
    }

    public static Object mimicArray(Object object, Class clazz) {
        Object object2;
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            return null;
        }
        int n = 1;
        while (string.charAt(n) == '[') {
            ++n;
        }
        if (n > 1) {
            Object[] objectArray = (Object[])object;
            int[] nArray = new int[n];
            nArray[0] = objectArray.length;
            object2 = ArrayFuncs.newInstance(clazz, nArray);
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object object3;
                ((Object[])object2)[n2] = object3 = ArrayFuncs.mimicArray(objectArray[n2], clazz);
                ++n2;
            }
        } else {
            object2 = ArrayFuncs.newInstance(clazz, Array.getLength(object));
        }
        return object2;
    }

    public static Object convertArray(Object object, Class clazz) {
        Object object2 = ArrayFuncs.mimicArray(object, clazz);
        if (object2 == null) {
            return object2;
        }
        ArrayFuncs.copyInto(object, object2);
        return object2;
    }

    public static void copyInto(Object object, Object object2) {
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            return;
        }
        if (string.charAt(1) == '[') {
            int n = 0;
            while (n < ((Object[])object).length) {
                ArrayFuncs.copyInto(((Object[])object)[n], ((Object[])object2)[n]);
                ++n;
            }
        } else {
            Class clazz = ArrayFuncs.getBaseClass(object);
            Class clazz2 = ArrayFuncs.getBaseClass(object2);
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                if (clazz2 == Byte.TYPE) {
                    System.arraycopy(object, 0, object2, 0, byArray.length);
                } else if (clazz2 == Short.TYPE) {
                    short[] sArray = (short[])object2;
                    int n = 0;
                    while (n < byArray.length) {
                        sArray[n] = byArray[n];
                        ++n;
                    }
                } else if (clazz2 == Character.TYPE) {
                    char[] cArray = (char[])object2;
                    int n = 0;
                    while (n < byArray.length) {
                        cArray[n] = (char)byArray[n];
                        ++n;
                    }
                } else if (clazz2 == Integer.TYPE) {
                    int[] nArray = (int[])object2;
                    int n = 0;
                    while (n < byArray.length) {
                        nArray[n] = byArray[n];
                        ++n;
                    }
                } else if (clazz2 == Long.TYPE) {
                    long[] lArray = (long[])object2;
                    int n = 0;
                    while (n < byArray.length) {
                        lArray[n] = byArray[n];
                        ++n;
                    }
                } else if (clazz2 == Float.TYPE) {
                    float[] fArray = (float[])object2;
                    int n = 0;
                    while (n < byArray.length) {
                        fArray[n] = byArray[n];
                        ++n;
                    }
                } else if (clazz2 == Double.TYPE) {
                    double[] dArray = (double[])object2;
                    int n = 0;
                    while (n < byArray.length) {
                        dArray[n] = byArray[n];
                        ++n;
                    }
                }
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object2;
                    int n = 0;
                    while (n < sArray.length) {
                        byArray[n] = (byte)sArray[n];
                        ++n;
                    }
                } else if (clazz2 == Short.TYPE) {
                    System.arraycopy(object, 0, object2, 0, sArray.length);
                } else if (clazz2 == Character.TYPE) {
                    char[] cArray = (char[])object2;
                    int n = 0;
                    while (n < sArray.length) {
                        cArray[n] = (char)sArray[n];
                        ++n;
                    }
                } else if (clazz2 == Integer.TYPE) {
                    int[] nArray = (int[])object2;
                    int n = 0;
                    while (n < sArray.length) {
                        nArray[n] = sArray[n];
                        ++n;
                    }
                } else if (clazz2 == Long.TYPE) {
                    long[] lArray = (long[])object2;
                    int n = 0;
                    while (n < sArray.length) {
                        lArray[n] = sArray[n];
                        ++n;
                    }
                } else if (clazz2 == Float.TYPE) {
                    float[] fArray = (float[])object2;
                    int n = 0;
                    while (n < sArray.length) {
                        fArray[n] = sArray[n];
                        ++n;
                    }
                } else if (clazz2 == Double.TYPE) {
                    double[] dArray = (double[])object2;
                    int n = 0;
                    while (n < sArray.length) {
                        dArray[n] = sArray[n];
                        ++n;
                    }
                }
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object2;
                    int n = 0;
                    while (n < cArray.length) {
                        byArray[n] = (byte)cArray[n];
                        ++n;
                    }
                } else if (clazz2 == Short.TYPE) {
                    short[] sArray = (short[])object2;
                    int n = 0;
                    while (n < cArray.length) {
                        sArray[n] = (short)cArray[n];
                        ++n;
                    }
                } else if (clazz2 == Character.TYPE) {
                    System.arraycopy(object, 0, object2, 0, cArray.length);
                } else if (clazz2 == Integer.TYPE) {
                    int[] nArray = (int[])object2;
                    int n = 0;
                    while (n < cArray.length) {
                        nArray[n] = cArray[n];
                        ++n;
                    }
                } else if (clazz2 == Long.TYPE) {
                    long[] lArray = (long[])object2;
                    int n = 0;
                    while (n < cArray.length) {
                        lArray[n] = cArray[n];
                        ++n;
                    }
                } else if (clazz2 == Float.TYPE) {
                    float[] fArray = (float[])object2;
                    int n = 0;
                    while (n < cArray.length) {
                        fArray[n] = cArray[n];
                        ++n;
                    }
                } else if (clazz2 == Double.TYPE) {
                    double[] dArray = (double[])object2;
                    int n = 0;
                    while (n < cArray.length) {
                        dArray[n] = cArray[n];
                        ++n;
                    }
                }
            } else if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object2;
                    int n = 0;
                    while (n < nArray.length) {
                        byArray[n] = (byte)nArray[n];
                        ++n;
                    }
                } else if (clazz2 == Short.TYPE) {
                    short[] sArray = (short[])object2;
                    int n = 0;
                    while (n < nArray.length) {
                        sArray[n] = (short)nArray[n];
                        ++n;
                    }
                } else if (clazz2 == Character.TYPE) {
                    char[] cArray = (char[])object2;
                    int n = 0;
                    while (n < nArray.length) {
                        cArray[n] = (char)nArray[n];
                        ++n;
                    }
                } else if (clazz2 == Integer.TYPE) {
                    System.arraycopy(object, 0, object2, 0, nArray.length);
                } else if (clazz2 == Long.TYPE) {
                    long[] lArray = (long[])object2;
                    int n = 0;
                    while (n < nArray.length) {
                        lArray[n] = nArray[n];
                        ++n;
                    }
                } else if (clazz2 == Float.TYPE) {
                    float[] fArray = (float[])object2;
                    int n = 0;
                    while (n < nArray.length) {
                        fArray[n] = nArray[n];
                        ++n;
                    }
                } else if (clazz2 == Double.TYPE) {
                    double[] dArray = (double[])object2;
                    int n = 0;
                    while (n < nArray.length) {
                        dArray[n] = nArray[n];
                        ++n;
                    }
                }
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object2;
                    int n = 0;
                    while (n < lArray.length) {
                        byArray[n] = (byte)lArray[n];
                        ++n;
                    }
                } else if (clazz2 == Short.TYPE) {
                    short[] sArray = (short[])object2;
                    int n = 0;
                    while (n < lArray.length) {
                        sArray[n] = (short)lArray[n];
                        ++n;
                    }
                } else if (clazz2 == Character.TYPE) {
                    char[] cArray = (char[])object2;
                    int n = 0;
                    while (n < lArray.length) {
                        cArray[n] = (char)lArray[n];
                        ++n;
                    }
                } else if (clazz2 == Integer.TYPE) {
                    int[] nArray = (int[])object2;
                    int n = 0;
                    while (n < lArray.length) {
                        nArray[n] = (int)lArray[n];
                        ++n;
                    }
                } else if (clazz2 == Long.TYPE) {
                    System.arraycopy(object, 0, object2, 0, lArray.length);
                } else if (clazz2 == Float.TYPE) {
                    float[] fArray = (float[])object2;
                    int n = 0;
                    while (n < lArray.length) {
                        fArray[n] = lArray[n];
                        ++n;
                    }
                } else if (clazz2 == Double.TYPE) {
                    double[] dArray = (double[])object2;
                    int n = 0;
                    while (n < lArray.length) {
                        dArray[n] = lArray[n];
                        ++n;
                    }
                }
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object2;
                    int n = 0;
                    while (n < fArray.length) {
                        byArray[n] = (byte)fArray[n];
                        ++n;
                    }
                } else if (clazz2 == Short.TYPE) {
                    short[] sArray = (short[])object2;
                    int n = 0;
                    while (n < fArray.length) {
                        sArray[n] = (short)fArray[n];
                        ++n;
                    }
                } else if (clazz2 == Character.TYPE) {
                    char[] cArray = (char[])object2;
                    int n = 0;
                    while (n < fArray.length) {
                        cArray[n] = (char)fArray[n];
                        ++n;
                    }
                } else if (clazz2 == Integer.TYPE) {
                    int[] nArray = (int[])object2;
                    int n = 0;
                    while (n < fArray.length) {
                        nArray[n] = (int)fArray[n];
                        ++n;
                    }
                } else if (clazz2 == Long.TYPE) {
                    long[] lArray = (long[])object2;
                    int n = 0;
                    while (n < fArray.length) {
                        lArray[n] = (long)fArray[n];
                        ++n;
                    }
                } else if (clazz2 == Float.TYPE) {
                    System.arraycopy(object, 0, object2, 0, fArray.length);
                } else if (clazz2 == Double.TYPE) {
                    double[] dArray = (double[])object2;
                    int n = 0;
                    while (n < fArray.length) {
                        dArray[n] = fArray[n];
                        ++n;
                    }
                }
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object2;
                    int n = 0;
                    while (n < dArray.length) {
                        byArray[n] = (byte)dArray[n];
                        ++n;
                    }
                } else if (clazz2 == Short.TYPE) {
                    short[] sArray = (short[])object2;
                    int n = 0;
                    while (n < dArray.length) {
                        sArray[n] = (short)dArray[n];
                        ++n;
                    }
                } else if (clazz2 == Character.TYPE) {
                    char[] cArray = (char[])object2;
                    int n = 0;
                    while (n < dArray.length) {
                        cArray[n] = (char)dArray[n];
                        ++n;
                    }
                } else if (clazz2 == Integer.TYPE) {
                    int[] nArray = (int[])object2;
                    int n = 0;
                    while (n < dArray.length) {
                        nArray[n] = (int)dArray[n];
                        ++n;
                    }
                } else if (clazz2 == Long.TYPE) {
                    long[] lArray = (long[])object2;
                    int n = 0;
                    while (n < dArray.length) {
                        lArray[n] = (long)dArray[n];
                        ++n;
                    }
                } else if (clazz2 == Float.TYPE) {
                    float[] fArray = (float[])object2;
                    int n = 0;
                    while (n < dArray.length) {
                        fArray[n] = (float)dArray[n];
                        ++n;
                    }
                } else if (clazz2 == Double.TYPE) {
                    System.arraycopy(object, 0, object2, 0, dArray.length);
                }
            }
        }
    }

    public static Object newInstance(Class clazz, int n) {
        Object object = Array.newInstance(clazz, n);
        if (object == null) {
            String string = clazz + "[" + n + "]";
            throw new OutOfMemoryError("Unable to allocate array: " + string);
        }
        return object;
    }

    public static Object newInstance(Class clazz, int[] nArray) {
        Object object = Array.newInstance(clazz, nArray);
        if (object == null) {
            String string = clazz + "[";
            String string2 = "";
            int n = 0;
            while (n < nArray.length) {
                string = string + string2 + nArray[n];
                string2 = ",";
                ++n;
            }
            string = string + "]";
            throw new OutOfMemoryError("Unable to allocate array: " + string);
        }
        return object;
    }
}

