/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.AsciiTable;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.RandomGroupsData;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.UndefinedData;
import nom.tam.fits.UndefinedHDU;

public class FitsFactory {
    private static boolean useAsciiTables = true;
    private static boolean useHierarch = false;

    public static void setUseAsciiTables(boolean bl) {
        useAsciiTables = bl;
    }

    static boolean getUseAsciiTables() {
        return useAsciiTables;
    }

    public static void setUseHierarch(boolean bl) {
        useHierarch = bl;
    }

    public static boolean getUseHierarch() {
        return useHierarch;
    }

    static Data dataFactory(Header header) throws FitsException {
        if (ImageHDU.isHeader(header)) {
            return ImageHDU.manufactureData(header);
        }
        if (RandomGroupsHDU.isHeader(header)) {
            return RandomGroupsHDU.manufactureData(header);
        }
        if (useAsciiTables && AsciiTableHDU.isHeader(header)) {
            return AsciiTableHDU.manufactureData(header);
        }
        if (BinaryTableHDU.isHeader(header)) {
            return BinaryTableHDU.manufactureData(header);
        }
        if (UndefinedHDU.isHeader(header)) {
            return UndefinedHDU.manufactureData(header);
        }
        throw new FitsException("Unrecognizable header in dataFactory");
    }

    static BasicHDU HDUFactory(Object object) throws FitsException {
        Header header;
        Data data;
        if (ImageHDU.isData(object)) {
            data = ImageHDU.encapsulate(object);
            header = ImageHDU.manufactureHeader(data);
        } else if (RandomGroupsHDU.isData(object)) {
            data = RandomGroupsHDU.encapsulate(object);
            header = RandomGroupsHDU.manufactureHeader(data);
        } else if (useAsciiTables && AsciiTableHDU.isData(object)) {
            data = AsciiTableHDU.encapsulate(object);
            header = AsciiTableHDU.manufactureHeader(data);
        } else if (BinaryTableHDU.isData(object)) {
            data = BinaryTableHDU.encapsulate(object);
            header = BinaryTableHDU.manufactureHeader(data);
        } else if (UndefinedHDU.isData(object)) {
            data = UndefinedHDU.encapsulate(object);
            header = UndefinedHDU.manufactureHeader(data);
        } else {
            throw new FitsException("Invalid data presented to HDUFactory");
        }
        return FitsFactory.HDUFactory(header, data);
    }

    static BasicHDU HDUFactory(Header header, Data data) throws FitsException {
        if (data instanceof ImageData) {
            return new ImageHDU(header, data);
        }
        if (data instanceof RandomGroupsData) {
            return new RandomGroupsHDU(header, data);
        }
        if (data instanceof AsciiTable) {
            return new AsciiTableHDU(header, data);
        }
        if (data instanceof BinaryTable) {
            return new BinaryTableHDU(header, data);
        }
        if (data instanceof UndefinedData) {
            return new UndefinedHDU(header, data);
        }
        return null;
    }
}

