/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.unidata.geoloc.vertical.VerticalTransform;

public class TestVertical
extends TestCase {
    public TestVertical(String name) {
        super(name);
    }

    public void testOceanS() throws IOException, InvalidRangeException {
        GridDataset gds = GridDataset.open((String)(TestAll.testdataDir + "grid/netcdf/cf/roms_ocean_s_coordinate.nc"));
        GridDatatype grid = gds.findGridDatatype("temp");
        assert (grid != null);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (gcs != null);
        VerticalCT vct = gcs.getVerticalCT();
        assert (vct != null);
        assert (vct.getVerticalTransformType() == VerticalCT.Type.OceanS);
        VerticalTransform vt = gcs.getVerticalTransform();
        assert (vt != null);
        ArrayDouble.D3 ca = vt.getCoordinateArray(0);
        assert (ca != null);
        assert (ca.getRank() == 3) : ca.getRank();
        int[] shape = ca.getShape();
        for (int i = 0; i < 3; ++i) {
            System.out.println(" shape " + i + " = " + shape[i]);
        }
        gds.close();
    }

    public void testOceanSigma() throws IOException, InvalidRangeException {
        GridDataset gds = GridDataset.open((String)(TestAll.testdataDir + "grid/netcdf/cf/gomoos_cf.nc"));
        GridDatatype grid = gds.findGridDatatype("temp");
        assert (grid != null);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (gcs != null);
        VerticalCT vct = gcs.getVerticalCT();
        assert (vct != null);
        assert (vct.getVerticalTransformType() == VerticalCT.Type.OceanSigma);
        VerticalTransform vt = gcs.getVerticalTransform();
        assert (vt != null);
        ArrayDouble.D3 ca = vt.getCoordinateArray(0);
        assert (ca != null);
        assert (ca.getRank() == 3) : ca.getRank();
        int[] shape = ca.getShape();
        for (int i = 0; i < 3; ++i) {
            System.out.println(" shape " + i + " = " + shape[i]);
        }
        gds.close();
    }

    public void testAtmSigma() throws IOException, InvalidRangeException {
        GridDataset gds = GridDataset.open((String)(TestAll.testdataDir + "grid/netcdf/cf/temperature.nc"));
        GridDatatype grid = gds.findGridDatatype("Temperature");
        assert (grid != null);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (gcs != null);
        VerticalCT vct = gcs.getVerticalCT();
        assert (vct != null);
        assert (vct.getVerticalTransformType() == VerticalCT.Type.Sigma);
        VerticalTransform vt = gcs.getVerticalTransform();
        assert (vt != null);
        ArrayDouble.D3 ca = vt.getCoordinateArray(0);
        assert (ca != null);
        assert (ca.getRank() == 3) : ca.getRank();
        int[] shape = ca.getShape();
        for (int i = 0; i < 3; ++i) {
            System.out.println(" shape " + i + " = " + shape[i]);
        }
        gds.close();
    }

    public void testAtmHybrid() throws IOException, InvalidRangeException {
        GridDataset gds = GridDataset.open((String)(TestAll.testdataDir + "grid/netcdf/cf/ccsm2.nc"));
        GridDatatype grid = gds.findGridDatatype("T");
        assert (grid != null);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (gcs != null);
        VerticalCT vct = gcs.getVerticalCT();
        assert (vct != null);
        assert (vct.getVerticalTransformType() == VerticalCT.Type.HybridSigmaPressure) : vct.getVerticalTransformType();
        VerticalTransform vt = gcs.getVerticalTransform();
        assert (vt != null);
        ArrayDouble.D3 ca = vt.getCoordinateArray(0);
        assert (ca != null);
        assert (ca.getRank() == 3) : ca.getRank();
        int[] shape = ca.getShape();
        for (int i = 0; i < 3; ++i) {
            System.out.println(" shape " + i + " = " + shape[i]);
        }
        gds.close();
    }

    public void testWrfEta() throws IOException, InvalidRangeException {
        GridDataset gds = GridDataset.open((String)(TestAll.testdataDir + "grid/netcdf/wrf/wrfout_v2_Lambert.nc"));
        GridDatatype grid = gds.findGridDatatype("T");
        assert (grid != null);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (gcs != null);
        VerticalCT vct = gcs.getVerticalCT();
        assert (vct != null);
        assert (vct.getVerticalTransformType() == VerticalCT.Type.WRFEta) : vct.getVerticalTransformType();
        VerticalTransform vt = gcs.getVerticalTransform();
        assert (vt != null);
        ArrayDouble.D3 ca = vt.getCoordinateArray(0);
        assert (ca != null);
        assert (ca.getRank() == 3) : ca.getRank();
        int[] shape = ca.getShape();
        for (int i = 0; i < 3; ++i) {
            System.out.println(" shape " + i + " = " + shape[i]);
        }
        gds.close();
    }

    public void utestStride() throws IOException, InvalidRangeException {
        String url = "dods://lead4.unidata.ucar.edu:8080/thredds/dodsC/model/UCAR/UNIDATA/WRF/STEERED/wrfout_d01_2006-04-20_00_00_00.nc";
        GridDataset gds = GridDataset.open((String)url);
        GridDatatype grid = gds.findGridDatatype("T");
        assert (grid != null);
        grid = grid.makeSubset(null, null, null, 1, 2, 4);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (gcs != null);
        VerticalTransform vt = gcs.getVerticalTransform();
        assert (vt != null);
        ArrayDouble.D3 ca = vt.getCoordinateArray(0);
        assert (ca != null);
        assert (ca.getRank() == 3) : ca.getRank();
        int[] shape = ca.getShape();
        for (int i = 0; i < 3; ++i) {
            System.out.println(" shape " + i + " = " + shape[i]);
        }
        assert (shape[0] == 30);
        assert (shape[1] == 72);
        assert (shape[2] == 36);
        gds.close();
    }
}

