/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import java.util.Random;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.UtmProjection;

public class TestUtm {
    static double maxx_all = 0.0;
    int REPEAT = 100;
    int NPTS = 10000;
    boolean checkit = false;
    boolean calcErrs = true;
    boolean show = false;
    double tolm = 10.0;
    long sumNormal = 0L;
    long sumArray = 0L;
    Random r = new Random(System.currentTimeMillis());

    void doOne(double x, double y, int zone, boolean isNorth) {
        UtmProjection proj = new UtmProjection(zone, isNorth);
        System.out.println("*** x=" + x + " y=" + y);
        LatLonPointImpl latlon = proj.projToLatLon(x, y);
        System.out.println("   lat=" + latlon.getLatitude() + " lon=" + latlon.getLongitude());
        ProjectionPoint endP = proj.latLonToProj((LatLonPoint)latlon);
        System.out.println("   x=" + endP.getX() + " y=" + endP.getY());
    }

    void run(int zone, boolean isNorth) {
        System.out.println("--------- zone= " + zone + " " + isNorth);
        double[][] from = new double[2][this.NPTS];
        for (int i = 0; i < this.NPTS; ++i) {
            from[0][i] = 800.0 * this.r.nextDouble();
            from[1][i] = isNorth ? 8000.0 * this.r.nextDouble() : 10000.0 - 8000.0 * this.r.nextDouble();
        }
        int n = this.REPEAT * this.NPTS;
        UtmProjection proj = new UtmProjection(zone, isNorth);
        double sumx = 0.0;
        double sumy = 0.0;
        double maxx = 0.0;
        long t1 = System.currentTimeMillis();
        for (int k = 0; k < this.REPEAT; ++k) {
            for (int i = 0; i < this.NPTS; ++i) {
                LatLonPointImpl latlon = proj.projToLatLon(from[0][i], from[1][i]);
                ProjectionPoint endP = proj.latLonToProj((LatLonPoint)latlon);
                if (this.calcErrs) {
                    double errx = this.error(from[0][i], endP.getX());
                    sumx += errx;
                    sumy += this.error(from[1][i], endP.getY());
                    maxx = Math.max(maxx, errx);
                    maxx_all = Math.max(maxx, maxx_all);
                }
                if (!this.checkit) continue;
                this.check_km("y", from[1][i], endP.getY());
                if (!this.check_km("x", from[0][i], endP.getX()) && !this.show) continue;
                System.out.println("   x=" + from[0][i] + " y=" + from[1][i] + " lat=" + latlon.getLatitude() + " lon=" + latlon.getLongitude());
            }
        }
        long took = System.currentTimeMillis() - t1;
        this.sumNormal += took;
        System.out.println(" " + n + " normal " + proj.getClassName() + " took " + took + " msecs." + " avg error x= " + 1000.0 * sumx / (double)n + " y=" + 1000.0 * sumy / (double)n + " maxx err = " + 1000.0 * maxx + " m");
        double[][] to = new double[2][this.NPTS];
        double[][] result2 = new double[2][this.NPTS];
        long start = System.currentTimeMillis();
        for (int k = 0; k < this.REPEAT; ++k) {
            proj.projToLatLon(from, to);
            proj.latLonToProj(to, result2);
            if (!this.checkit) continue;
            for (int i = 0; i < this.NPTS; ++i) {
                this.check_km("xa", from[0][i], result2[0][i]);
                this.check_km("ya", from[1][i], result2[1][i]);
                if (!this.show) continue;
                System.out.println("  x:" + result2[0][i] + " y=" + result2[1][i]);
            }
        }
        took = System.currentTimeMillis() - start;
        this.sumArray += took;
        System.out.println(" " + n + " array " + proj.getClass().getName() + " took " + took + " msecs ");
    }

    double error(double d1, double d2) {
        return Math.abs(d1 - d2);
    }

    boolean check_km(String what, double d1, double d2) {
        double err = 1000.0 * Math.abs(d1 - d2);
        if (err > this.tolm) {
            System.out.println(" *" + what + ": " + d1 + "!=" + d2 + " err=" + err + " m");
        }
        return err > this.tolm;
    }

    boolean check_m(String what, double d1, double d2) {
        double err;
        double d = err = d1 == 0.0 ? 0.0 : Math.abs(d1 - d2);
        if (err > this.tolm) {
            System.out.println(" *" + what + ": " + d1 + "!=" + d2 + " err=" + err + " m");
        }
        return err > this.tolm;
    }

    boolean check_deg(String what, double d1, double d2) {
        double err;
        double d = err = d1 == 0.0 ? 0.0 : Math.abs(d1 - d2);
        if (err > 1.0E-6) {
            System.out.println(" *" + what + ": " + d1 + "!=" + d2 + " err=" + err + " degrees");
        }
        return err > 1.0E-6;
    }

    public static void main(String[] args) {
        TestUtm r = new TestUtm();
        r.run(1, true);
        r.run(60, false);
        System.out.println("\nmaxx_all= " + 1000.0 * maxx_all + " m");
    }
}

