/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import junit.framework.TestCase;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LambertConformal;

public class TestBB
extends TestCase {
    void doTest(ProjectionImpl p, LatLonRect rect) {
        System.out.println("\n--Projection= " + p + " " + p.paramsToString());
        System.out.println("  llbb= " + rect.toString2());
        ProjectionRect prect = p.latLonToProjBB(rect);
        ProjectionRect prect2 = p.latLonToProjBB2(rect);
        System.out.println("  latLonToProjBB= " + prect);
        System.out.println("  latLonToProjBB2= " + prect2);
        assert (this.equals(prect, prect2));
    }

    void doTests(ProjectionImpl p) {
        LatLonPointImpl ptL = new LatLonPointImpl(-10.0, 0.0);
        double xinc = 22.5;
        double yinc = 20.0;
        for (double lon = 0.0; lon < 380.0; lon += xinc) {
            ptL.setLongitude(lon);
            LatLonRect llbb = new LatLonRect((LatLonPoint)ptL, yinc, xinc);
            this.doTest(p, llbb);
        }
    }

    public void testLC() {
        this.doTests((ProjectionImpl)new LambertConformal(40.0, 0.0, 20.0, 60.0));
    }

    boolean equals(ProjectionRect prect1, ProjectionRect prect2) {
        boolean b1 = this.equals(prect1.getLowerLeftPoint(), prect2.getLowerLeftPoint());
        boolean b2 = this.equals(prect1.getUpperRightPoint(), prect2.getUpperRightPoint());
        return b1 && b2;
    }

    boolean equals(ProjectionPoint pt1, ProjectionPoint pt2) {
        return Misc.closeEnough((double)pt1.getX(), (double)pt2.getX()) && Misc.closeEnough((double)pt1.getY(), (double)pt2.getY());
    }
}

