/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.io.File;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import timing.Stat;
import ucar.nc2.util.IO;

public class TestMetarEncoding
extends TimerTask {
    boolean show = false;
    String[] acceptStrings = new String[]{"raw", "csv", "xml", "netcdf", "netcdfStream"};
    int count = 0;
    String server = "http://motherlode.ucar.edu:9080/thredds/ncss/metars?";
    String vars = "variables=some&var=air_pressure_at_sea_level&var=air_temperature&var=dew_point_temperature&var=hectoPascal_ALTIM&var=precipitation_amount_hourly&var=visibility_in_air&var=weather&var=wind_from_direction&var=wind_peak_speed&var=wind_speed";
    String bbox = "&spatial=bb&north=90&west=-10&east=50&south=35";
    String timePoint = "&temporal=point&time=2007-12-05T01%3A00%3A00Z";
    String timeRange = "&time_start=2007-12-06T00%3A00%3A00Z&time_end=2007-12-06T23%3A59%3A59Z";
    String testA = "http://motherlode.ucar.edu:8080/thredds/ncss/metars?variables=all&spatial=all&time_start=2007-09-29T00%3A00%3A00Z&time_end=2007-09-29T23%3A59%3A59Z&accept=netcdf";

    private void doTestA(String stn, String accept, Stat stat_time, Stat stat_size) {
        String url = this.server + this.vars + "&stn=" + stn + "&accept=" + accept;
        String filenameOut = this.makeFilename(accept, "A");
        File f = new File(filenameOut);
        if (this.show) {
            System.out.println("Read = " + url + " to " + filenameOut);
        }
        long start = System.currentTimeMillis();
        String result = IO.readURLtoFile((String)url, (File)f);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        if (this.show) {
            System.out.println(result);
            System.out.println(" that took = " + took + "sec");
            System.out.println(" file size = " + f.length());
        }
        stat_time.sample(took);
        stat_size.sample(f.length() / 1000L);
    }

    private void doTestB(String accept, Stat stat_time, Stat stat_size) {
        String url = this.server + this.vars + this.bbox + this.timePoint + "&accept=" + accept;
        String filenameOut = this.makeFilename(accept, "B");
        File f = new File(filenameOut);
        if (this.show) {
            System.out.println("Read = " + url + " to " + filenameOut);
        }
        long start = System.currentTimeMillis();
        String result = IO.readURLtoFile((String)url, (File)f);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        if (this.show) {
            System.out.println(result);
            System.out.println(" that took = " + took + "sec");
            System.out.println(" file size = " + f.length());
        }
        stat_time.sample(took);
        stat_size.sample(f.length() / 1000L);
    }

    private void doTestC(String accept, Stat stat_time, Stat stat_size) {
        String url = this.server + this.vars + this.timeRange + "&accept=" + accept;
        String filenameOut = this.makeFilename(accept, "C");
        File f = new File(filenameOut);
        if (this.show) {
            System.out.println("Read = " + url + " to " + filenameOut);
        }
        long start = System.currentTimeMillis();
        String result = IO.readURLtoFile((String)url, (File)f);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        if (this.show) {
            System.out.println(result);
            System.out.println(" that took = " + took + "sec");
            System.out.println(" file size = " + f.length());
        }
        stat_time.sample(took);
        stat_size.sample(f.length() / 1000L);
    }

    private String makeFilename(String accept, String run) {
        String suffix = accept.startsWith("netcdf") ? "nc" : accept;
        return "C:/temp/metars/" + accept + run + "." + suffix;
    }

    private String makeTimeRange(String base) {
        return "&time_start=" + base + "T00%3A00%3A00Z&time_end=" + base + "T23%3A59%3A59Z";
    }

    public void runA() {
        for (String name : this.acceptStrings) {
            this.doTestA("LOWW", name, Stat.factory(name + "_A_time"), Stat.factory(name + "_A_size"));
        }
        System.out.println("\nResults after " + this.count + " runs:");
        for (String name : this.acceptStrings) {
            System.out.println(" " + Stat.factory(name + "_A_time") + "; " + Stat.factory(name + "_A_size"));
        }
    }

    public void runB() {
        for (String name : this.acceptStrings) {
            this.doTestB(name, Stat.factory(name + "_B_time"), Stat.factory(name + "_B_size"));
        }
        System.out.println("\nResults after " + this.count + " runs:");
        for (String name : this.acceptStrings) {
            System.out.println(" " + Stat.factory(name + "_B_time") + "; " + Stat.factory(name + "_B_size"));
        }
    }

    public void runC() {
        for (String name : this.acceptStrings) {
            this.doTestC(name, Stat.factory(name + "_C_time"), Stat.factory(name + "_C_size"));
        }
        System.out.println("\nResults after " + this.count + " runs:");
        for (String name : this.acceptStrings) {
            System.out.println(" " + Stat.factory(name + "_C_time") + "; " + Stat.factory(name + "_C_size"));
        }
    }

    @Override
    public void run() {
        ++this.count;
        this.runA();
        this.runB();
        this.runC();
    }

    public static void main(String[] args) {
        Calendar c = Calendar.getInstance();
        Timer timer = new Timer();
        timer.schedule((TimerTask)new TestMetarEncoding(), c.getTime(), 120000L);
    }
}

