/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.memory;

import java.io.IOException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.util.memory.MemoryCounterAgent;

public class MemoryCounterAgentTest {
    public static void measureSize(Object o) {
        long memShallow = MemoryCounterAgent.sizeOf(o);
        long memDeep = MemoryCounterAgent.deepSizeOf(o);
        System.out.printf("%s, shallow=%d, deep=%d%n", o.getClass().getSimpleName(), memShallow, memDeep);
    }

    public static void measureSize(String name, Object o, Class skipClass, boolean show) {
        if (o == null) {
            return;
        }
        long memShallow = MemoryCounterAgent.sizeOf(o);
        long memDeep = MemoryCounterAgent.deepSizeOf3(name, o, skipClass, show);
        System.out.printf("%n %4d %6d %s (%s)%n", memShallow, memDeep, name, o.getClass().getName());
    }

    public static void main(String[] args) throws IOException {
        System.out.println("======================");
        System.out.println("======================");
        MemoryCounterAgentTest.testGrib2();
    }

    static void testHDF4() throws IOException {
        String filename = "C:/data/hdf4/MI1B2T_B54_O003734_AN_05.hdf";
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        MemoryCounterAgentTest.measureSize(filename, ncfile, null, true);
        ncfile.close();
    }

    static void testHDF5() throws IOException {
        String filename = "C:/data/hdf5/HIRDLS2-Aura12h_b033_2000d275.he5";
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        Variable vv = ncfile.findVariable("HDFEOS/SWATHS/HIRDLS/Geolocation Fields/SpacecraftAltitude");
        MemoryCounterAgentTest.measureSize(vv.getName(), vv, Group.class, true);
        ncfile.close();
    }

    static void testBufr() throws IOException {
        String filename = "C:/data/bufr/edition3/idd/profiler/PROFILER_3.bufr";
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        MemoryCounterAgentTest.measureSize(filename, ncfile, null, true);
        ncfile.close();
    }

    static void testGrib1() throws IOException {
        String filename = "D:\\data\\grib\\nam\\conus80/NAM_CONUS_80km_20060811_0000.grib1";
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        MemoryCounterAgentTest.measureSize(filename, ncfile, null, false);
        Variable vv = ncfile.findVariable("Absolute_vorticity");
        MemoryCounterAgentTest.measureSize(vv.getName(), vv, Group.class, false);
        ncfile.close();
    }

    static void testGrib2() throws IOException {
        String filename = "D:/datasets/ncep/gfs/global0p5/GFS_Global_0p5deg_20060824_0000.grib2";
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        MemoryCounterAgentTest.measureSize(filename, ncfile, null, true);
        ncfile.close();
    }

    static void showAll(NetcdfFile ncfile) {
        for (Dimension dim : ncfile.getDimensions()) {
            MemoryCounterAgentTest.measureSize(dim.getName(), dim, Group.class, false);
        }
        for (Variable v : ncfile.getVariables()) {
            MemoryCounterAgentTest.measureSize(v.getName(), v, Group.class, false);
            for (Attribute att : v.getAttributes()) {
                MemoryCounterAgentTest.measureSize(att.getName(), att, null, false);
            }
        }
        for (Attribute att : ncfile.getGlobalAttributes()) {
            MemoryCounterAgentTest.measureSize(att.getName(), att, null, false);
        }
        Group root = ncfile.getRootGroup();
        MemoryCounterAgentTest.measureSize("rootGroup", root, null, false);
        for (Group g : root.getGroups()) {
            MemoryCounterAgentTest.measureSize(g.getName(), g, null, false);
        }
    }

    static void testNcd() throws IOException {
        String filename = "C:/data/test2.nc";
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)filename);
        MemoryCounterAgentTest.measureSize("C:/data/test2.nc", ncfile, null, true);
        NetcdfDatasetInfo info = new NetcdfDatasetInfo(filename);
        MemoryCounterAgentTest.measureSize("info", info, null, true);
        String pifo = info.getParseInfo();
        System.out.println("info= " + pifo);
        ncfile.close();
    }

    static void testN3() throws IOException {
        NetcdfFile ncfile = NetcdfDataset.openFile((String)"C:/data/test2.nc", null);
        MemoryCounterAgentTest.measureSize("beforeRead", ncfile, null, true);
        for (Variable v : ncfile.getVariables()) {
            v.read();
        }
        MemoryCounterAgentTest.measureSize("afterRead", ncfile, null, true);
        ncfile.close();
    }

    static void testNcml() throws IOException {
        String filename = "C:/dev/tds/thredds/cdm/src/test/data/ncml/aggUnionSimple.xml";
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)filename, (boolean)false, null);
        MemoryCounterAgentTest.measureSize("aggUnionSimple", ncfile, null, true);
        ncfile.close();
    }

    private static class Kid
    extends Parent {
        private boolean b;
        private float f;

        private Kid() {
        }
    }

    private static class Parent {
        private int i;
        private boolean b;
        private long l;

        private Parent() {
        }
    }
}

