/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil;

public class TestAggCleanup
extends TestCase {
    FileCache cache;
    FileFactory factory = new MyFileFactory();
    String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n    <aggregation dimName='time' type='joinExisting'>\n      <scan location='D:/data/fileCache/dir%' suffix='.nc' />\n    </aggregation>\n</netcdf>";

    public TestAggCleanup(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.cache = new FileCache(5, 100, 3600);
    }

    public void testCache() throws IOException, InvalidRangeException, InterruptedException {
        String filename = "file:" + TestNcML.topDir + "offsite/aggExistingSSTA.xml";
        RandomAccessFile.setDebugLeaks((boolean)true);
        List openfiles = RandomAccessFile.getOpenFiles();
        int count = openfiles.size();
        System.out.println("starting files=" + count);
        NetcdfDataset.initNetcdfFileCache((int)0, (int)2, (int)5, (int)600);
        for (int i = 0; i < 10; ++i) {
            String ncmli = StringUtil.replace((String)this.ncml, (char)'%', (String)Integer.toString(i));
            NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncmli), (String)filename, null);
            System.out.println(" TestNcmlAggExisting.open " + filename);
            Variable timev = ncfile.findVariable("time");
            Array timeD = timev.read();
            int count1 = RandomAccessFile.getOpenFiles().size();
            System.out.printf("count files at dir %d count= %d%n", i, count1);
            ncfile.close();
        }
        int count2 = RandomAccessFile.getOpenFiles().size();
        System.out.println("ending files=" + count2);
        Thread.currentThread();
        Thread.sleep(10000L);
        System.out.println("exiting files=" + count2);
    }

    class MyFileFactory
    implements FileFactory {
        MyFileFactory() {
        }

        public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDataset.openFile((String)location, (int)buffer_size, (CancelTask)cancelTask, (Object)iospMessage);
        }
    }
}

