/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.util.Date;
import junit.framework.TestCase;
import ucar.nc2.TestLocal;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.units.DerivedUnit;
import ucar.units.PrefixDBException;
import ucar.units.SpecificationException;
import ucar.units.TimeScaleUnit;
import ucar.units.Unit;
import ucar.units.UnitDBException;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;
import ucar.units.UnitParseException;
import ucar.units.UnitSystemException;

public class TestDateUnits
extends TestCase {
    private DateFormatter formatter = new DateFormatter();

    public TestDateUnits(String name) {
        super(name);
    }

    public void doit(DateUnit du) {
        Date d = du.makeDate(0.0);
        Date d2 = du.getDateOrigin();
        assert (d2.equals(d));
        Date d3 = DateUnit.getStandardDate((String)du.toString());
        System.out.println(du.toString() + " == " + this.formatter.toDateTimeStringISO(d3) + " unitsString= " + du.getUnitsString());
        Date d4 = du.getDate();
        System.out.println(du.toString() + " == " + this.formatter.toDateTimeStringISO(d4));
        assert (d4.equals(d3)) : d4 + "!=" + d3;
    }

    public void testDate() throws Exception {
        System.out.println();
        this.doit(new DateUnit("2 secs since 1972-01-01T00:00:00Z"));
        this.doit(new DateUnit("3600 secs since 1972-01-01T00:00:00Z"));
        this.doit(new DateUnit("24 hours since 1972-01-01T00:00:00Z"));
        this.doit(new DateUnit("22 years since 2000-01-01T00:00:00Z"));
        this.doit(new DateUnit("22 years since 2000-01-01T00:00:00 -06:00"));
        this.doit(new DateUnit("22 years since 2000-01-01T00:00:00 +06:00"));
        this.doit(new DateUnit("22 years since 2000-01-01T00:00:00 +06"));
        this.doit(new DateUnit("22 years since 2000-01-01T00:00:00 -06"));
        this.doit(new DateUnit("22 years since 2000-01-01T00:00:00 +0600"));
        this.doit(new DateUnit("22 years since 2000-01-01T00:00:00 -0600"));
    }

    public void testMakeDate() throws Exception {
        System.out.println("\ntestStandardDate");
        DateUnit du = new DateUnit("secs since 1972-01-01T00:00:00Z");
        Date d = du.makeDate(36000.0);
        System.out.println(" " + du.toString() + " == " + this.formatter.toDateTimeStringISO(d));
        du = new DateUnit("hours since 1972-01-01T00:00:00Z");
        Date d2 = du.makeDate(10.0);
        System.out.println(" " + du.toString() + " == " + this.formatter.toDateTimeStringISO(d));
        assert (d2.equals(d));
        du = new DateUnit("36 hours since 1972-01-01T00:00:00Z");
        d2 = du.makeDate(10.0);
        System.out.println(" " + du.toString() + " == " + this.formatter.toDateTimeStringISO(d));
        assert (d2.equals(d));
    }

    private void tryMakeValue(String unit, double value) throws Exception {
        DateUnit du = new DateUnit(unit);
        Date d = du.makeDate(value);
        double value2 = du.makeValue(d);
        System.out.println(" " + value + " == " + this.formatter.toDateTimeStringISO(d));
        assert (value == value2) : value + " " + value2;
    }

    public void testMakeValue() throws Exception {
        System.out.println("\ntestMakeValue");
        this.tryMakeValue("secs since 1970-01-02T00:00:00Z", 3600.0);
        this.tryMakeValue("hours since 1970-01-02T00:00:00Z", 3600.0);
        this.tryMakeValue("secs since 1900-01-01T00:00:00Z", 36000.0);
        this.tryMakeValue("hours since 1900-01-01T00:00:00Z", 12.0);
    }

    public void testDateValue() throws Exception {
        DateUnit du = new DateUnit("hours since 1970-01-01T00:00:00Z");
        Date d = new Date(86400000L);
        double value = du.makeValue(d);
        System.out.println("testDateValue " + value + " == " + this.formatter.toDateTimeStringISO(d));
        assert (value == 24.0) : value;
        du = new DateUnit("hours since 1971-01-01T00:00:00Z");
        d = new Date(32400000000L);
        value = du.makeValue(d);
        System.out.println("testDateValue " + value + " == " + this.formatter.toDateTimeStringISO(d));
        assert (value == 240.0) : value;
        du = new DateUnit("days since 1965-01-01T00:00:00Z");
        d = DateUnit.getStandardDate((String)"days since 1966-01-01T00:00:00Z");
        value = du.makeValue(d);
        System.out.println("testDateValue " + value + " == " + this.formatter.toDateTimeStringISO(d));
        assert (TestLocal.closeEnough(value, 365.0)) : value;
    }

    private void showUnitInfo(Unit uu) {
        System.out.println(" ucar.units.Unit.class=              " + uu.getClass().getName());
        System.out.println(" ucar.units.Unit.toString=           " + uu.toString());
        System.out.println(" ucar.units.Unit.getCanonicalString= " + uu.getCanonicalString());
        System.out.println(" ucar.units.Unit.getName=            " + uu.getName());
        System.out.println(" ucar.units.Unit.getSymbol=          " + uu.getSymbol());
        System.out.println(" ucar.units.Unit.getUnitName=        " + uu.getUnitName());
        System.out.println(" ucar.units.Unit.getDerivedUnit=     " + uu.getDerivedUnit());
        if (uu instanceof TimeScaleUnit) {
            TimeScaleUnit su = (TimeScaleUnit)uu;
            DerivedUnit du = su.getDerivedUnit();
            this.showUnitInfo((Unit)du);
        }
    }

    public void testStandardDate() {
        Date r = DateUnit.getStandardDate((String)"1 days since 2009-06-15T04:00:00Z");
        DateFormatter format = new DateFormatter();
        assert (format.toDateTimeStringISO(r).equals("2009-06-16T04:00:00Z"));
    }

    public void utestShowExtremes() throws Exception {
        System.out.println();
        long msec = 0L;
        Date d = new Date(msec);
        System.out.println(msec + " = " + this.formatter.toDateTimeStringISO(d));
        msec = 63072000000L;
        d = new Date(msec);
        System.out.println(msec + " = " + this.formatter.toDateTimeStringISO(d));
        msec = -62188992000000L;
        d = new Date(msec);
        System.out.println(msec + " = " + this.formatter.toDateTimeStringISO(d));
        msec = Long.MAX_VALUE;
        d = new Date(msec);
        System.out.println(msec + " = " + this.formatter.toDateTimeStringISO(d));
        msec = Long.MIN_VALUE;
        d = new Date(msec);
        System.out.println(msec + " = " + this.formatter.toDateTimeStringISO(d));
    }

    public void testUdunitBug() throws UnitDBException, UnitSystemException, SpecificationException, PrefixDBException, UnitParseException {
        UnitFormat format = UnitFormatManager.instance();
        String unit = "days since 2009-06-14 04:00:00 +00:00";
        Unit uu = format.parse(unit);
        System.out.printf("%s == %s %n", unit, uu);
        unit = "1 days since 2009-06-14 04:00:00 +00:00";
        uu = format.parse(unit);
        System.out.printf("%s == %s %n", unit, uu);
        unit = "3 days since 2009-06-14 04:00:00 +00:00";
        uu = format.parse(unit);
        System.out.printf("%s == %s %n", unit, uu);
    }

    public void testUdunitBug2() throws UnitDBException, UnitSystemException, SpecificationException, PrefixDBException, UnitParseException {
        UnitFormat format = UnitFormatManager.instance();
        String unit = "2.0 secs since 1985-02-02 12:00:00";
        Unit uu = format.parse(unit);
        System.out.printf("%s == %s %n", unit, uu);
    }
}

