/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.TestNcML;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

public class TestDateCoordinate
extends TestCase {
    NetcdfDataset ncfile = null;

    public TestDateCoordinate(String name) {
        super(name);
    }

    public void setUp() {
        String filename = "file:" + TestNcML.topDir + "testDateUnits.ncml";
        try {
            this.ncfile = NetcdfDataset.openDataset((String)filename);
        }
        catch (MalformedURLException e) {
            System.out.println("bad URL error = " + e);
        }
        catch (IOException e) {
            System.out.println("IO error = " + e);
            e.printStackTrace();
        }
    }

    protected void tearDown() throws IOException {
        this.ncfile.close();
    }

    public void utestCoordinateAxis1DTime() {
        Variable time = this.ncfile.findVariable("time");
        assert (time instanceof CoordinateAxis);
        assert (time instanceof CoordinateAxis1DTime);
        CoordinateAxis1DTime timeAxis = (CoordinateAxis1DTime)time;
        for (Date d : timeAxis.getTimeDates()) {
            System.out.printf(" %s%n", d);
        }
    }

    public void testDateCoordinates() throws Exception {
        Variable time = this.ncfile.findVariable("time");
        Date first = null;
        DateFormatter format = new DateFormatter();
        String units = time.getUnitsString();
        DateUnit du = new DateUnit(time.getUnitsString());
        System.out.printf("units= %s%n", units);
        System.out.printf("DateUnit= %s (%s)%n", du, du.getUnitsString());
        Array data = time.read();
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            double val = ii.getDoubleNext();
            Date date = du.makeDate(val);
            System.out.printf(" %f %s ==  %s%n", val, units, format.toDateTimeStringISO(date));
            if (first != null) continue;
            first = date;
        }
        assert (format.toDateTimeStringISO(first).equals("2009-06-15T04:00:00Z"));
    }
}

