/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.stream.NcStreamReader;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.util.CompareNetcdf;
import ucar.unidata.util.StringUtil;

public class TestNetcdfStream
extends TestCase {
    String serverRoot = "C:/data/";

    public TestNetcdfStream(String name) {
        super(name);
    }

    public void testCompare() throws IOException {
        this.doOne("C:/data/formats/netcdf3/standardVar.nc");
    }

    public void testScan() throws IOException {
        this.scanDir("C:\\data\\formats\\gempak\\surface", new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".gem");
            }
        });
    }

    void scanDir(String dirName, FileFilter ff) throws IOException {
        TestAll.actOnAll(dirName, ff, new TestAll.Act(){

            @Override
            public int doAct(String filename) throws IOException {
                TestNetcdfStream.this.doOne(filename);
                return 1;
            }
        });
    }

    void doOne(String filename) throws IOException {
        String name = StringUtil.substitute((String)filename.substring(this.serverRoot.length()), (String)"\\", (String)"/");
        String remote = "http://localhost:8080/thredds/cdmremote/testCdmRemote/" + name;
        this.compare(filename, remote);
    }

    void compare(String file, String remote) throws IOException {
        System.out.printf("---------------------------\n", new Object[0]);
        NetcdfFile ncfile = NetcdfDataset.openFile((String)file, null);
        CdmRemote ncfileRemote = new CdmRemote(remote);
        CompareNetcdf.compareFiles((NetcdfFile)ncfile, (NetcdfFile)ncfileRemote, (boolean)false, (boolean)false, (boolean)false);
        System.out.printf("compare %s ok %n", file);
        CompareNetcdf.compareFiles((NetcdfFile)ncfile, (NetcdfFile)ncfileRemote, (boolean)true, (boolean)true, (boolean)true);
        System.out.printf("compare data %s ok %n", file);
        ncfile.close();
        ncfileRemote.close();
    }

    public static void main2(String[] args) {
        try {
            String filename = "src/test/data/feb.nc";
            NetcdfFile ncfile = NetcdfFile.open((String)filename);
            NcStreamWriter writer = new NcStreamWriter(ncfile, null);
            File file = new File("C:/temp/out.ncs");
            FileOutputStream fos = new FileOutputStream(file);
            FileChannel wbc = fos.getChannel();
            writer.streamAll((WritableByteChannel)wbc);
            wbc.close();
            NcStreamReader reader = new NcStreamReader();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            NetcdfFile ncfileBack = reader.readStream((InputStream)is, null);
            CompareNetcdf.compareFiles((NetcdfFile)ncfile, (NetcdfFile)ncfileBack, (boolean)false, (boolean)true, (boolean)false);
            ncfile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

