/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.util.CompareNetcdf;
import ucar.unidata.util.StringUtil;

public class TestOffNcMLWriteReadwithCoords
extends TestCase {
    static boolean showFiles = true;
    static boolean showCompare = false;
    static boolean showEach = false;
    private ArrayList<String> files;
    private String griddir = TestAll.testdataDir + "grid/netcdf/";

    public TestOffNcMLWriteReadwithCoords(String name) {
        super(name);
    }

    public void setUp() {
        this.files = new ArrayList();
        this.files.add(this.griddir + "atd-radar/rgg.20020411.000000.lel.ll.nc");
        this.files.add(this.griddir + "cf/ccsm2.nc");
        this.files.add(this.griddir + "coards/cldc.mean.nc");
        this.files.add(this.griddir + "csm/o3monthly.nc");
        this.files.add(this.griddir + "gdv/OceanDJF.nc");
        this.files.add(this.griddir + "gief/coamps.wind_uv.nc");
        this.files.add(this.griddir + "mars/temp_air_01082000.nc");
        this.files.add(this.griddir + "nuwg/eta.nc");
        this.files.add(this.griddir + "nuwg/ocean.nc");
        this.files.add(this.griddir + "wrf/wrfout_v2_Lambert.nc");
        this.files.add(this.griddir + "atd-radar/SPOL_3Volumes.nc");
        this.files.add(TestAll.testdataDir + "grid/grib/grib2/data/eta2.wmo");
        this.files.add(TestAll.testdataDir + "grid/grib/grib2/data/ndfd.wmo");
        this.files.add(TestAll.testdataDir + "satellite/gini/n0r_20041013_1852-compress");
        this.files.add(TestAll.testdataDir + "satellite/gini/ntp_20041206_2154");
        this.files.add(TestAll.testdataDir + "satellite/dmsp/F14200307192230.n.OIS");
        this.files.add(TestAll.testdataDir + "radar/nexrad/level2/6500KHGX20000610_000110");
        this.files.add(TestAll.testdataDir + "radar/nexrad/level2/Level2_KYUX_20060527_2335.ar2v");
    }

    public void testReadAsNcdataset() throws Exception {
        for (String s : this.files) {
            this.convertAsNcdataset(s);
        }
    }

    public void testOne() throws Exception {
        this.convertAsNcdataset(TestAll.testdataDir + "radar/nexrad/level2/6500KHGX20000610_000110");
    }

    private void convertAsNcdataset(String location) throws IOException {
        String ncmlOut;
        NetcdfDataset org_ncd;
        block4: {
            location = StringUtil.replace((String)location, (char)'\\', (String)"/");
            org_ncd = NetcdfDataset.acquireDataset((String)location, null);
            NcMLWriter writer = new NcMLWriter();
            if (showFiles) {
                System.out.println("-----------");
                System.out.println("DS input filename= " + location);
            }
            int pos = location.lastIndexOf("/");
            String filename = location.substring(pos + 1);
            ncmlOut = TestAll.temporaryLocalDataDir + filename + ".ncml";
            if (showFiles) {
                System.out.println(" output filename= " + ncmlOut);
            }
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ncmlOut, false));
                writer.writeXMLexplicit((NetcdfFile)org_ncd, (OutputStream)out, null);
                ((OutputStream)out).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        NetcdfDataset new_ncd = NetcdfDataset.openDataset((String)ncmlOut, (boolean)true, null);
        CompareNetcdf.compareFiles((NetcdfFile)org_ncd, (NetcdfFile)new_ncd);
        org_ncd.close();
        new_ncd.close();
    }
}

