/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

public class TestOffAggFmrcNonuniform
extends TestCase {
    public TestOffAggFmrcNonuniform(String name) {
        super(name);
    }

    public void testGribNonuniform() throws Exception, InvalidRangeException {
        String xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='run' type='forecastModelRunCollection' timeUnitsChange='true'>\n    <scan location='" + TestAll.cdmUnitTestDir + "ncml/nc/ruc_conus40/' suffix='.grib1' enhance='true' dateFormatMark='RUC_CONUS_40km_#yyyyMMdd_HHmm'/>\n" + "  </aggregation>\n" + "</netcdf>";
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(xml), (String)"aggFmrcNonuniform", null);
        this.testDimensions((NetcdfFile)ncfile, 3, 113, 151);
        this.testCoordVar((NetcdfFile)ncfile, 113);
        this.testAggCoordVar((NetcdfFile)ncfile, 3);
        this.testTimeCoordVar((NetcdfFile)ncfile, "time5", 3, 11);
        ncfile.close();
    }

    private void testDimensions(NetcdfFile ncfile, int nagg, int y, int x) {
        Dimension latDim = ncfile.findDimension("x");
        assert (null != latDim);
        assert (latDim.getName().equals("x"));
        assert (latDim.getLength() == x);
        assert (!latDim.isUnlimited());
        Dimension lonDim = ncfile.findDimension("y");
        assert (null != lonDim);
        assert (lonDim.getName().equals("y"));
        assert (lonDim.getLength() == y);
        assert (!lonDim.isUnlimited());
        Dimension runDim = ncfile.findDimension("run");
        assert (null != runDim);
        assert (runDim.getName().equals("run"));
        assert (runDim.getLength() == nagg) : runDim.getLength();
    }

    private void testCoordVar(NetcdfFile ncfile, int n) {
        Variable lat = ncfile.findVariable("y");
        assert (null != lat);
        assert (lat.getName().equals("y"));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == (long)n);
        assert (lat.getShape()[0] == n);
        assert (lat.getDataType() == DataType.DOUBLE);
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0).equals((Object)ncfile.findDimension("y")));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("km"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        try {
            Array data = lat.read();
            assert (data.getRank() == 1);
            assert (data.getSize() == (long)n);
            assert (data.getShape()[0] == n);
            assert (data.getElementType() == Double.TYPE);
        }
        catch (IOException io) {
            // empty catch block
        }
    }

    private void testAggCoordVar(NetcdfFile ncfile, int nagg) {
        block14: {
            Variable time = ncfile.findVariable("run");
            assert (null != time);
            assert (time.getName().equals("run"));
            assert (time.getRank() == 1);
            assert (time.getSize() == (long)nagg);
            assert (time.getShape()[0] == nagg);
            assert (time.getDataType() == DataType.DOUBLE);
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == (long)nagg);
                assert (data.getShape()[0] == nagg);
                assert (data.getElementType() == Double.TYPE);
                NCdumpW.printArray((Array)data);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    double val = dataI.getDoubleNext();
                    assert (val == (double)count);
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block14;
                throw new AssertionError();
            }
        }
    }

    private void testTimeCoordVar(NetcdfFile ncfile, String varName, int nagg, int ntimes) throws Exception {
        block14: {
            Variable time = ncfile.findVariable(varName);
            assert (null != time);
            assert (time.getName().equals(varName));
            assert (time.getRank() == 2);
            assert (time.getSize() == (long)(nagg * ntimes));
            assert (time.getShape()[0] == nagg);
            assert (time.getShape()[1] == ntimes);
            assert (time.getDataType() == DataType.DOUBLE);
            String units = time.getUnitsString();
            DateUnit du = new DateUnit(units);
            DateFormatter formatter = new DateFormatter();
            try {
                Array data = time.read();
                assert (data.getSize() == (long)(nagg * ntimes));
                assert (data.getShape()[0] == nagg);
                assert (data.getShape()[1] == ntimes);
                assert (data.getElementType() == Double.TYPE);
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    double val = dataI.getDoubleNext();
                    Date date = du.makeDate(val);
                    if (date == null) continue;
                    System.out.println(" date= " + formatter.toDateTimeStringISO(date));
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block14;
                throw new AssertionError();
            }
        }
    }
}

