/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.TestUtils;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ncml.NcMLReader;

public class TestOffAggDirectory
extends TestCase {
    public TestOffAggDirectory(String name) {
        super(name);
    }

    public void testNcmlDirect() throws IOException {
        String filename = "file:" + TestAll.cdmUnitTestDir + "ncml/nc/seawifs/aggDirectory.xml";
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        System.out.println(" TestNcmlAggDirectory.open " + filename);
        this.testDimensions((NetcdfFile)ncfile);
        this.testCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVar((NetcdfFile)ncfile);
        this.testReadData((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void testNcmlDataset() throws IOException {
        String filename = "file:" + TestAll.cdmUnitTestDir + "ncml/nc/seawifs/aggDirectory.xml";
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)filename, (boolean)true, null);
        System.out.println(" TestNcmlAggExisting.openDataset " + filename);
        this.testDimensions((NetcdfFile)ncfile);
        this.testCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVar((NetcdfFile)ncfile);
        this.testReadData2((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void testNcmlGrid() throws IOException {
        String filename = "file:" + TestAll.cdmUnitTestDir + "ncml/nc/seawifs/aggDirectory.xml";
        GridDataset gds = GridDataset.open((String)filename);
        System.out.println(" TestNcmlAggExisting.openGrid " + filename);
        List grids = gds.getGrids();
        assert (grids.size() == 2);
        gds.close();
    }

    public void testDimensions(NetcdfFile ncfile) {
        Dimension latDim = ncfile.findDimension("latitude");
        assert (null != latDim);
        assert (latDim.getName().equals("latitude"));
        assert (latDim.getLength() == 630);
        assert (!latDim.isUnlimited());
        Dimension lonDim = ncfile.findDimension("longitude");
        assert (null != lonDim);
        assert (lonDim.getName().equals("longitude"));
        assert (lonDim.getLength() == 630);
        assert (!lonDim.isUnlimited());
        Dimension timeDim = ncfile.findDimension("time");
        assert (null != timeDim);
        assert (timeDim.getName().equals("time"));
        assert (timeDim.getLength() == 6);
    }

    public void testCoordVar(NetcdfFile ncfile) throws IOException {
        Variable lat = ncfile.findVariable("latitude");
        assert (lat.getDataType() == DataType.FLOAT);
        assert (lat.getDimension(0).equals((Object)ncfile.findDimension("latitude")));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("degree_N"));
        Array data = lat.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == 630L);
        assert (data.getShape()[0] == 630);
        assert (data.getElementType() == Float.TYPE);
        IndexIterator dataI = data.getIndexIterator();
        assert (TestUtils.close(dataI.getFloatNext(), 43.0f)) : dataI.getFloatCurrent();
        assert (TestUtils.close(dataI.getFloatNext(), 43.01045f)) : dataI.getFloatCurrent();
        assert (TestUtils.close(dataI.getFloatNext(), 43.020893f)) : dataI.getFloatCurrent();
    }

    public void testAggCoordVar(NetcdfFile ncfile) throws IOException {
        Variable time = ncfile.findVariable("time");
        assert (null != time);
        assert (time.getName().equals("time"));
        assert (time.getRank() == 1);
        assert (time.getSize() == 6L);
        assert (time.getShape()[0] == 6);
        assert (time.getDataType() == DataType.FLOAT);
        assert (time.getDimension(0) == ncfile.findDimension("time"));
        Array data = time.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == 6L);
        assert (data.getShape()[0] == 6);
        assert (data.getElementType() == Float.TYPE);
        float[] vals = new float[]{890184.0f, 890232.0f, 890256.0f, 890304.0f, 890352.0f, 890376.0f};
        int count = 0;
        IndexIterator dataI = data.getIndexIterator();
        while (dataI.hasNext()) {
            assert (TestUtils.close(dataI.getFloatNext(), vals[count++]));
        }
    }

    public void testReadData(NetcdfFile ncfile) throws IOException {
        Variable v = ncfile.findVariable("chlorophylle_a");
        assert (null != v);
        assert (v.getName().equals("chlorophylle_a"));
        assert (v.getRank() == 3);
        assert (v.getShape()[0] == 6);
        assert (v.getShape()[1] == 630);
        assert (v.getShape()[2] == 630);
        assert (v.getDataType() == DataType.SHORT);
        assert (!v.isCoordinateVariable());
        assert (v.getDimension(0) == ncfile.findDimension("time"));
        assert (v.getDimension(1) == ncfile.findDimension("latitude"));
        assert (v.getDimension(2) == ncfile.findDimension("longitude"));
        Array data = v.read();
        assert (data.getRank() == 3);
        assert (data.getShape()[0] == 6);
        assert (data.getShape()[1] == 630);
        assert (data.getShape()[2] == 630);
        assert (data.getElementType() == Short.TYPE);
        short[] vals = new short[]{Short.MAX_VALUE, Short.MAX_VALUE, 20, Short.MAX_VALUE, 20, 20};
        int[] shape = data.getShape();
        Index tIndex = data.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            double val = data.getDouble(tIndex.set(i, 133, 133));
            assert (TestUtils.close((double)vals[i], val)) : val;
        }
    }

    public void testReadData2(NetcdfFile ncfile) throws IOException {
        Variable v = ncfile.findVariable("chlorophylle_a");
        assert (null != v);
        assert (v.getName().equals("chlorophylle_a"));
        assert (v.getRank() == 3);
        assert (v.getShape()[0] == 6);
        assert (v.getShape()[1] == 630);
        assert (v.getShape()[2] == 630);
        assert (v.getDataType() == DataType.DOUBLE);
        assert (!v.isCoordinateVariable());
        assert (v.getDimension(0) == ncfile.findDimension("time"));
        assert (v.getDimension(1) == ncfile.findDimension("latitude"));
        assert (v.getDimension(2) == ncfile.findDimension("longitude"));
        Array data = v.read();
        assert (data.getRank() == 3);
        assert (data.getShape()[0] == 6);
        assert (data.getShape()[1] == 630);
        assert (data.getShape()[2] == 630);
        assert (data.getElementType() == Double.TYPE);
        double[] vals = new double[]{Double.NaN, Double.NaN, 0.2, Double.NaN, 0.2, 0.2};
        int[] shape = data.getShape();
        Index tIndex = data.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            double val = data.getDouble(tIndex.set(i, 133, 133));
            assert (TestUtils.close(vals[i], val)) : val;
        }
    }
}

