/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestUtils;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestAggTiled
extends TestCase {
    int nlon = 24;
    int nlat = 12;

    public TestAggTiled(String name) {
        super(name);
    }

    public void testTiled4() throws IOException, InvalidRangeException {
        String filename = "file:./" + TestNcML.topDir + "tiled/testAggTiled.ncml";
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        System.out.println(" TestNcmlAggExisting.open " + ncfile);
        this.testDimensions((NetcdfFile)ncfile);
        this.testCoordVar((NetcdfFile)ncfile, "lat", this.nlat, DataType.DOUBLE);
        this.testCoordVar((NetcdfFile)ncfile, "lon", this.nlon, DataType.FLOAT);
        Variable v = ncfile.findVariable("temperature");
        v.setCaching(false);
        this.testReadData((NetcdfFile)ncfile, v);
        this.testReadDataSection(v, v.getShapeAsSection());
        this.testReadDataSection(v, new Section("0:5,6:18"));
        this.testReadDataSection(v, new Section("3:9,6:18"));
        this.testReadDataSection(v, new Section("6:11,6:18"));
        this.testReadDataSection(v, new Section("2:4,3:9"));
        this.testReadDataSection(v, new Section("2:4,14:20"));
        this.testReadDataSection(v, new Section("8:10,3:9"));
        this.testReadDataSection(v, new Section("8:10,14:20"));
        this.testReadDataSection(v, new Section("8:10,22"));
        this.testReadDataSection(v, new Section("11,22"));
        this.testReadDataSection(v, new Section("9,14:20"));
        this.testReadDataSection(v, new Section("0:5:2,6:18:2"));
        this.testReadDataSection(v, new Section("2:4:2,3:9:2"));
        this.testReadDataSection(v, new Section("9,14:20:3"));
        this.testReadDataSection(v, new Section("1:11:2,22"));
        this.testReadDataSection(v, new Section("1:11:22,22"));
        this.testReadDataSection(v, new Section("1:9:4,3:19:3"));
        ncfile.close();
    }

    public void testStride() throws IOException, InvalidRangeException {
        String filename = "file:./" + TestNcML.topDir + "tiled/testAggTiled.ncml";
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        System.out.println(" TestNcmlAggExisting.open " + ncfile);
        Variable v = ncfile.findVariable("temperature");
        v.setCaching(false);
        this.testReadDataSection(v, new Section("1:9:4,3:19:3"));
        ncfile.close();
    }

    public void testDimensions(NetcdfFile ncfile) {
        Dimension latDim = ncfile.findDimension("lat");
        assert (null != latDim);
        assert (latDim.getName().equals("lat"));
        assert (latDim.getLength() == this.nlat);
        assert (!latDim.isUnlimited());
        Dimension lonDim = ncfile.findDimension("lon");
        assert (null != lonDim);
        assert (lonDim.getName().equals("lon"));
        assert (lonDim.getLength() == this.nlon);
        assert (!lonDim.isUnlimited());
    }

    public void testCoordVar(NetcdfFile ncfile, String name, int n, DataType type) throws IOException {
        Variable lat = ncfile.findVariable(name);
        assert (null != lat);
        assert (lat.getName().equals(name));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == (long)n);
        assert (lat.getShape()[0] == n);
        assert (lat.getDataType() == type);
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0).equals((Object)ncfile.findDimension(name)));
        Array data = lat.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == (long)n);
        assert (data.getShape()[0] == n);
        assert (data.getElementType() == type.getPrimitiveClassType());
        int count = 0;
        IndexIterator dataI = data.getIndexIterator();
        while (dataI.hasNext()) {
            assert (TestUtils.close(dataI.getDoubleNext(), (double)count++));
        }
    }

    public void testReadData(NetcdfFile ncfile, Variable v) {
        block19: {
            assert (v.getName().equals("temperature"));
            assert (v.getRank() == 2);
            assert (v.getSize() == (long)(this.nlon * this.nlat)) : v.getSize();
            assert (v.getShape()[0] == this.nlat);
            assert (v.getShape()[1] == this.nlon);
            assert (v.getDataType() == DataType.DOUBLE);
            assert (!v.isCoordinateVariable());
            assert (v.getDimension(0) == ncfile.findDimension("lat"));
            assert (v.getDimension(1) == ncfile.findDimension("lon"));
            try {
                Array data = v.read();
                assert (data.getRank() == 2);
                assert (data.getSize() == (long)(this.nlon * this.nlat));
                assert (data.getShape()[0] == this.nlat);
                assert (data.getShape()[1] == this.nlon);
                assert (data.getElementType() == Double.TYPE);
                int[] shape = data.getShape();
                Index tIndex = data.getIndex();
                for (int row = 0; row < shape[0]; ++row) {
                    for (int col = 0; col < shape[1]; ++col) {
                        double val = data.getDouble(tIndex.set(row, col));
                        double truth = this.getVal(row, col);
                        assert (TestUtils.close(val, truth)) : val + "!=" + truth + "(" + row + "," + col + ")";
                    }
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block19;
                throw new AssertionError();
            }
        }
    }

    private double getVal(int row, int col) {
        if (row < 6) {
            return col < 12 ? (double)(row * 12 + col) : (double)(72 + row * 12 + (col - 12));
        }
        return col < 12 ? (double)(144 + (row - 6) * 12 + col) : (double)(216 + (row - 6) * 12 + (col - 12));
    }

    public void testReadDataSection(Variable v, Section s) throws InvalidRangeException {
        block10: {
            System.out.println("Read Section " + s);
            try {
                Array data = v.read(s);
                assert (data.getRank() == 2);
                assert (data.getSize() == s.computeSize());
                assert (data.getShape()[0] == s.getShape(0));
                assert (data.getShape()[1] == s.getShape(1));
                assert (data.getElementType() == Double.TYPE);
                int startRow = s.getOrigin(0);
                int startCol = s.getOrigin(1);
                int strideRow = s.getStride(0);
                int strideCol = s.getStride(1);
                int[] shape = data.getShape();
                Index tIndex = data.getIndex();
                for (int row = 0; row < shape[0]; ++row) {
                    for (int col = 0; col < shape[1]; ++col) {
                        double val = data.getDouble(tIndex.set(row, col));
                        double truth = this.getVal(startRow + row * strideRow, startCol + col * strideCol);
                        assert (TestUtils.close(val, truth)) : val + "!=" + truth + "(" + row + "," + col + ")";
                    }
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
    }
}

