/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.misc;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class UspLightning2
extends AbstractIOServiceProvider {
    private static final String MAGIC = "USPLN-LIGHTNING";
    private long[] offsets;
    private double lat_min;
    private double lat_max;
    private double lon_min;
    private double lon_max;
    private int time_min;
    private int time_max;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        int n = MAGIC.length();
        byte[] b = new byte[n];
        raf.read(b);
        String got = new String(b);
        return got.equals(MAGIC);
    }

    public String getFileTypeId() {
        return "USPLN/example2";
    }

    public String getFileTypeDescription() {
        return "USPLN/example2";
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        int n;
        this.raf = raf;
        try {
            n = this.readAllData(raf);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IOException("bad data");
        }
        Dimension recordDim = new Dimension("record", n);
        ncfile.addDimension(null, recordDim);
        Variable date = new Variable(ncfile, null, null, "date");
        date.setDimensions("record");
        date.setDataType(DataType.INT);
        String timeUnit = "seconds since 1970-01-01 00:00:00";
        date.addAttribute(new Attribute("long_name", "date of strike"));
        date.addAttribute(new Attribute("units", timeUnit));
        date.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ncfile.addVariable(null, date);
        date.setSPobject((Object)new IospData(0));
        Variable lat = new Variable(ncfile, null, null, "lat");
        lat.setDimensions("record");
        lat.setDataType(DataType.DOUBLE);
        lat.addAttribute(new Attribute("long_name", "latitude"));
        lat.addAttribute(new Attribute("units", "degrees_north"));
        lat.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        ncfile.addVariable(null, lat);
        lat.setSPobject((Object)new IospData(1));
        Variable lon = new Variable(ncfile, null, null, "lon");
        lon.setDimensions("record");
        lon.setDataType(DataType.DOUBLE);
        lon.addAttribute(new Attribute("long_name", "longitude"));
        lon.addAttribute(new Attribute("units", "degrees_east"));
        lon.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        ncfile.addVariable(null, lon);
        lon.setSPobject((Object)new IospData(2));
        Variable amp = new Variable(ncfile, null, null, "strikeAmplitude");
        amp.setDimensions("record");
        amp.setDataType(DataType.DOUBLE);
        amp.addAttribute(new Attribute("long_name", "amplitude of strike"));
        amp.addAttribute(new Attribute("units", "kAmps"));
        amp.addAttribute(new Attribute("missing_value", (Number)new Double(999.0)));
        ncfile.addVariable(null, amp);
        amp.setSPobject((Object)new IospData(3));
        Variable nstrokes = new Variable(ncfile, null, null, "strokeCount");
        nstrokes.setDimensions("record");
        nstrokes.setDataType(DataType.INT);
        nstrokes.addAttribute(new Attribute("long_name", "number of strokes per flash"));
        nstrokes.addAttribute(new Attribute("units", ""));
        ncfile.addVariable(null, nstrokes);
        nstrokes.setSPobject((Object)new IospData(4));
        ncfile.addAttribute(null, new Attribute("title", "USPN Lightning Data"));
        ncfile.addAttribute(null, new Attribute("history", "Read directly by Netcdf Java IOSP"));
        ncfile.addAttribute(null, new Attribute("Conventions", "Unidata Observation Dataset v1.0"));
        ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.POINT.toString()));
        ncfile.addAttribute(null, new Attribute("observationDimension", "record"));
        ncfile.addAttribute(null, new Attribute("time_coverage_start", this.time_min + " " + timeUnit));
        ncfile.addAttribute(null, new Attribute("time_coverage_end", this.time_max + " " + timeUnit));
        ncfile.addAttribute(null, new Attribute("geospatial_lat_min", (Number)new Double(this.lat_min)));
        ncfile.addAttribute(null, new Attribute("geospatial_lat_max", (Number)new Double(this.lat_max)));
        ncfile.addAttribute(null, new Attribute("geospatial_lon_min", (Number)new Double(this.lon_min)));
        ncfile.addAttribute(null, new Attribute("geospatial_lon_max", (Number)new Double(this.lon_max)));
        ncfile.finish();
    }

    int readAllData(RandomAccessFile raf) throws IOException, NumberFormatException, ParseException {
        ArrayList<Long> offsetList = new ArrayList<Long>();
        SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.lat_min = 1000.0;
        this.lat_max = -1000.0;
        this.lon_min = 1000.0;
        this.lon_max = -1000.0;
        this.time_min = Integer.MAX_VALUE;
        this.time_max = 0;
        raf.seek(0L);
        int count = 0;
        while (true) {
            long offset = raf.getFilePointer();
            String line = raf.readLine();
            if (line == null) break;
            if (line.startsWith(MAGIC)) continue;
            StringTokenizer stoker = new StringTokenizer(line, ",\r\n");
            while (stoker.hasMoreTokens()) {
                Date d = isoDateTimeFormat.parse(stoker.nextToken());
                double lat = Double.parseDouble(stoker.nextToken());
                double lon = Double.parseDouble(stoker.nextToken());
                double amp = Double.parseDouble(stoker.nextToken());
                int nstrikes = Integer.parseInt(stoker.nextToken());
                Strike s = new Strike(d, lat, lon, amp, nstrikes);
                this.lat_min = Math.min(this.lat_min, s.lat);
                this.lat_max = Math.max(this.lat_max, s.lat);
                this.lon_min = Math.min(this.lon_min, s.lon);
                this.lon_max = Math.max(this.lon_max, s.lon);
                this.time_min = Math.min(this.time_min, s.d);
                this.time_max = Math.max(this.time_max, s.d);
            }
            offsetList.add(new Long(offset));
            ++count;
        }
        this.offsets = new long[count];
        for (int i = 0; i < offsetList.size(); ++i) {
            Long off = (Long)offsetList.get(i);
            this.offsets[i] = off;
        }
        System.out.println("processed " + count + " records");
        return count;
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        IospData iospd = (IospData)v2.getSPobject();
        SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        int[] sectionShape = section.getShape();
        Array data = Array.factory((DataType)v2.getDataType(), (int[])sectionShape);
        Index ima = data.getIndex();
        int count = 0;
        Range r = section.getRange(0);
        Range.Iterator riter = r.getIterator();
        while (riter.hasNext()) {
            Strike s;
            int index = riter.next();
            long offset = this.offsets[index];
            try {
                s = new Strike(offset, isoDateTimeFormat);
            }
            catch (ParseException e) {
                throw new IOException(e.getMessage());
            }
            ima.set(count);
            switch (iospd.varno) {
                case 0: {
                    data.setInt(ima, s.d);
                    break;
                }
                case 1: {
                    data.setDouble(ima, s.lat);
                    break;
                }
                case 2: {
                    data.setDouble(ima, s.lon);
                    break;
                }
                case 3: {
                    data.setDouble(ima, s.amp);
                    break;
                }
                case 4: {
                    data.setInt(ima, s.n);
                }
            }
            ++count;
        }
        return data;
    }

    public static void main(String[] args) throws IOException, IllegalAccessException, InstantiationException, InvalidRangeException {
        NetcdfFile.registerIOProvider(UspLightning2.class);
        NetcdfFile ncfile = NetcdfFile.open((String)(TestAll.testdataDir + "lightning/uspln/uspln_20061023.18"));
        System.out.println("ncfile = \n" + ncfile);
        Variable v = ncfile.findVariable("lat");
        Array data = v.read();
        assert (data.getSize() == v.getSize()) : data.getSize();
        data = v.read("0:99");
        assert (data.getSize() == 100L) : data.getSize();
        data = v.read("0:99:3");
        assert (data.getSize() == 34L) : data.getSize();
    }

    private class IospData {
        int varno;

        IospData(int varno) {
            this.varno = varno;
        }
    }

    private class Strike {
        int d;
        double lat;
        double lon;
        double amp;
        int n;

        Strike(long offset, SimpleDateFormat isoDateTimeFormat) throws IOException, ParseException {
            UspLightning2.this.raf.seek(offset);
            String line = UspLightning2.this.raf.readLine();
            if (line == null || line.startsWith(UspLightning2.MAGIC)) {
                throw new IllegalStateException();
            }
            StringTokenizer stoker = new StringTokenizer(line, ",\r\n");
            Date d = isoDateTimeFormat.parse(stoker.nextToken());
            this.makeDate(d);
            this.lat = Double.parseDouble(stoker.nextToken());
            this.lon = Double.parseDouble(stoker.nextToken());
            this.amp = Double.parseDouble(stoker.nextToken());
            this.n = Integer.parseInt(stoker.nextToken());
        }

        Strike(Date d, double lat, double lon, double amp, int n) {
            this.makeDate(d);
            this.lat = lat;
            this.lon = lon;
            this.amp = amp;
            this.n = n;
        }

        void makeDate(Date date) {
            this.d = (int)(date.getTime() / 1000L);
        }

        public String toString() {
            return this.lat + " " + this.lon + " " + this.amp + " " + this.n;
        }
    }
}

