/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.TestH5;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DebugFlagsImpl;

public class TestH5read
extends TestCase {
    String testDir = TestAll.testdataDir + "hdf5/";
    static int max_size = 10000000;

    public TestH5read(String name) {
        super(name);
    }

    public void testH5data() {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl(""));
        TestAll.readAllDir(this.testDir, new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getPath();
                return name.endsWith(".h5") || name.endsWith(".H5") || name.endsWith(".he5") || name.endsWith(".nc");
            }
        });
    }

    public void problemV() throws IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        String filename = TestAll.testdataDir + "hdf5/ssec-h5/MYD04_L2.A2006188.1830.005.2006194121515.hdf";
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        Variable v = ncfile.findVariable("/U-MARF/EPS/IASI_xxx_1C/DATA/SPECT_LAT_ARRAY");
        Array data = v.read();
        System.out.println("\n**** testReadNetcdf4 done\n\n" + ncfile);
        NCdump.printArray((Array)data, (String)"primary_cloud", (PrintStream)System.out, null);
        ncfile.close();
    }

    public void utestProblem() {
        TestH5read.readAllData(this.testDir + "compressCompoundBarrowdale.h5");
    }

    public static void readAllDir(String dirName) {
        int i;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        if (null == allFiles) {
            System.out.println("---------------INVALID " + dirName);
            return;
        }
        for (i = 0; i < allFiles.length; ++i) {
            String name = allFiles[i].getAbsolutePath();
            if (!name.endsWith(".h5") && !name.endsWith(".H5") && !name.endsWith(".he5") && !name.endsWith(".nc")) continue;
            TestH5read.readAllData(name);
        }
        for (i = 0; i < allFiles.length; ++i) {
            File f = allFiles[i];
            if (!f.isDirectory()) continue;
            TestH5read.readAllDir(allFiles[i].getAbsolutePath());
        }
    }

    public static void readAllData(String filename) {
        block4: {
            System.out.println("\n------Reading filename " + filename);
            try {
                NetcdfFile ncfile = TestH5.open(filename);
                for (Variable v : ncfile.getVariables()) {
                    if (v.getSize() > (long)max_size) {
                        Section s = TestH5read.makeSubset(v);
                        System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize() + " section= " + s);
                        v.read(s);
                        continue;
                    }
                    System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize());
                    v.read();
                }
                ncfile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    static Section makeSubset(Variable v) throws InvalidRangeException {
        int[] shape = v.getShape();
        shape[0] = 1;
        Section s = new Section(shape);
        long size = s.computeSize();
        shape[0] = (int)Math.max(1L, (long)max_size / size);
        return new Section(shape);
    }

    public static void main(String[] args) {
        TestH5read test = new TestH5read("fake");
        TestH5read.readAllDir("c:/data/hdf5/HIRDLS");
    }
}

