/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf5.TestH5;

public class TestH5aura
extends TestCase {
    public TestH5aura(String name) {
        super(name);
    }

    public void test1() throws IOException {
        NetcdfFile ncfile = TestH5.open(TestAll.testdataDir + "hdf5/eos/HIRDLS/HIRDLS1_v4.0.2a-aIrix-c2_2003d106.he5");
        Variable dset = ncfile.findVariable("HDFEOS/SWATHS/HIRDLS_L1_Swath/Data Fields/Scaled Ch01 Radiance");
        dset.read();
    }

    public void test2() throws IOException {
        NetcdfFile ncfile = TestH5.open(TestAll.testdataDir + "hdf5/eos/HIRDLS/HIRDLS2-AFGL_b027_na.he5");
        Variable dset = ncfile.findVariable("HDFEOS/SWATHS/HIRDLS/Data Fields/Altitude");
        Array data = dset.read();
        assert (data.getElementType() == Float.TYPE);
    }

    public void testEosMetadata() {
        Array A;
        NetcdfFile ncfile = TestH5.open(TestAll.testdataDir + "hdf5/eos/HIRDLS/HIRDLS2-Aura73p_b029_2000d275.he5");
        Group root = ncfile.getRootGroup();
        Group g = root.findGroup("HDFEOS INFORMATION");
        Variable dset = g.findVariable("StructMetadata.0");
        assert (null != dset);
        assert (dset.getDataType() == DataType.CHAR);
        try {
            A = dset.read();
        }
        catch (IOException e) {
            System.err.println("ERROR reading file");
            assert (false);
            return;
        }
        assert (A.getRank() == 1);
        assert (A instanceof ArrayChar);
        ArrayChar ca = (ArrayChar)A;
        String sval = ca.getString();
        System.out.println(dset.getName());
        System.out.println(" Length = " + sval.length());
        System.out.println(" Value = " + sval);
        dset = g.findVariable("coremetadata.0");
        assert (null != dset);
        assert (dset.getDataType() == DataType.CHAR);
        try {
            A = dset.read();
        }
        catch (IOException e) {
            System.err.println("ERROR reading file");
            assert (false);
            return;
        }
        assert (A.getRank() == 1);
        assert (A instanceof ArrayChar);
        ca = (ArrayChar)A;
        sval = ca.getString();
        System.out.println(dset.getName());
        System.out.println(" Length = " + sval.length());
        System.out.println(" Value = " + sval);
    }

    public static void main(String[] args) {
        TestH5aura test = new TestH5aura("fake");
        test.testEosMetadata();
    }
}

