/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestIosp;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf4.TestH4readAndCount;
import ucar.nc2.util.CompareNetcdf;

public class TestH4subset
extends TestCase {
    public TestH4subset(String name) {
        super(name);
    }

    public void testSpecificVariableSection() throws InvalidRangeException, IOException {
        Array A;
        NetcdfFile ncfile = NetcdfFile.open((String)(TestH4readAndCount.testDir + "96108_08.hdf"));
        Variable v = ncfile.findVariable("CalibratedData");
        assert (null != v);
        assert (v.getRank() == 3);
        int[] shape = v.getShape();
        assert (shape[0] == 810);
        assert (shape[1] == 50);
        assert (shape[2] == 716);
        Array data = v.read("0:809:10,0:49:5,0:715:2");
        assert (data.getRank() == 3);
        int[] dshape = data.getShape();
        assert (dshape[0] == 81);
        assert (dshape[1] == 10);
        assert (dshape[2] == 358);
        try {
            A = v.read();
        }
        catch (IOException e) {
            System.err.println("ERROR reading file");
            assert (false);
            return;
        }
        Array Asection = A.section(new Section("0:809:10,0:49:5,0:715:2").getRanges());
        assert (Asection.getRank() == 3);
        for (int i = 0; i < 3; ++i) {
            assert (Asection.getShape()[i] == dshape[i]);
        }
        CompareNetcdf.compareData((Array)data, (Array)Asection);
    }

    public void testSubsetting() throws IOException, InvalidRangeException {
        int ntrials = 100;
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "MI1B2T_B54_O003734_AN_05.hdf", "Infrared Radiance%2FRDQI", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "ncidc/AMSR_E_L2A_BrightnessTemperatures_V08_200801012345_A.hdf", "High_Res_B_Swath/Data Fields/Cold_Sky_Mirror_Count_89B", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "96108_08.hdf", "BlackBody1Temperature", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "ssec/CAL_LID_L1-Launch-V1-06.2006-07-07T21-20-40ZD.hdf", "Total_Attenuated_Backscatter_532", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "ncidc/MOD02HKM.A2007016.0245.005.2007312120020.hdf", "DC Restore Change for Reflective 1km Bands", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "ssec/MYD06_L2.A2006188.1655.005.2006194124315.hdf", "mod06/Data Fields/Cloud_Top_Pressure", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "ssec/MYD06_L2.A2006188.1655.005.2006194124315.hdf", "mod06/Data Fields/Quality_Assurance_1km", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "eos/mopitt/MOP03M-200501-L3V81.0.1.hdf", "MOP03/Data Fields/Surface Pressure Day", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "eos/mopitt/MOP03M-200501-L3V81.0.1.hdf", "MOP03/Data Fields/Averaging Kernel Night", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "ncidc/MOD10A1.A2008001.h23v15.005.2008003161138.hdf", "MOD_Grid_Snow_500m/Data Fields/Fractional_Snow_Cover", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "eos/misr/MISR_AM1_GP_GMP_P040_O003734_05", "GeometricParameters/Data Fields/CaZenith", ntrials);
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "ncidc/MOD02HKM.A2007016.0245.005.2007312120020.hdf", "MODIS_SWATH_Type_L1B/Data Fields/EV_500_RefSB_Uncert_Indexes", ntrials);
    }

    public void problemSubset() throws IOException, InvalidRangeException {
        TestIosp.testVariableSubset(TestH4readAndCount.testDir + "ssec/MYD04_L2.A2006188.1830.005.2006194121515.hdf", "mod04/Data Fields/Aerosol_Cldmask_Byproducts_Land", 10);
    }
}

