/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.grib.GribIndexName;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class TestIndexUpdating
extends TestCase {
    private String dataFileName = "GFS_CONUS_191km_20090331_1800.grib1";
    private String dataSuffix1_8 = ".times1-8";
    private String dataSuffix9_12 = ".times9-12";
    private String dataSuffix13_18 = ".times13-18";
    private String dataSuffix19_21 = ".times19-21";
    private String indexFileName = this.dataFileName + ".gbx";
    private String indexSuffix1_8 = ".times1-8";
    private String indexSuffix1_12 = ".times1-12";
    private String indexSuffix1_18 = ".times1-18";
    private String indexSuffix1_21 = ".times1-21";
    private String localDataDirPath = "ucar/nc2/iosp/grib/indexUpdating";
    private File dataDir;
    private File dataFile;
    private File indexFile;
    private NetcdfFile netcdfObj;
    private File indexFilePartial;
    private File indexFileFull;

    public TestIndexUpdating(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.dataDir = new File(TestAll.cdmLocalTestDataDir, this.localDataDirPath);
        if (!this.dataDir.exists()) {
            TestIndexUpdating.fail((String)("Non-existent data directory [" + this.dataDir.getPath() + "]."));
            return;
        }
        if (!this.dataDir.canWrite()) {
            TestIndexUpdating.fail((String)("Cannot write to data directory [" + this.dataDir.getPath() + "]."));
            return;
        }
        this.dataFile = new File(this.dataDir, this.dataFileName);
        this.dataFile.deleteOnExit();
        this.indexFile = new File(this.dataDir, this.indexFileName);
        this.indexFile.deleteOnExit();
        if (this.indexFile.exists() && !this.indexFile.canWrite()) {
            TestIndexUpdating.fail((String)("Cannot write index file [" + this.indexFile.getPath() + "]."));
        }
    }

    protected void tearDown() throws Exception {
        File indexFileGbx8;
        if (this.netcdfObj != null) {
            this.netcdfObj.close();
        }
        if (this.dataFile != null && this.dataFile.exists()) {
            this.dataFile.delete();
        }
        if (this.indexFile != null && this.indexFile.exists()) {
            this.indexFile.delete();
        }
        if ((indexFileGbx8 = new File(GribIndexName.get((String)this.indexFile.getPath()))) != null && indexFileGbx8.exists()) {
            indexFileGbx8.delete();
        }
        File cacheIndex = null;
        if (this.indexFile != null) {
            cacheIndex = DiskCache.getFile((String)this.indexFile.getPath(), (boolean)true);
        }
        if (cacheIndex != null && cacheIndex.exists()) {
            if (!cacheIndex.canWrite()) {
                TestIndexUpdating.fail((String)("Cannot write/remove cache index file [" + cacheIndex.getPath() + "]."));
            } else if (cacheIndex.exists()) {
                cacheIndex.delete();
            }
        }
        cacheIndex = null;
        if (this.indexFile != null) {
            cacheIndex = DiskCache.getFile((String)GribIndexName.get((String)this.indexFile.getPath()), (boolean)true);
        }
        if (cacheIndex != null && cacheIndex.exists()) {
            if (!cacheIndex.canWrite()) {
                TestIndexUpdating.fail((String)("Cannot write/remove cache index file [" + cacheIndex.getPath() + "]."));
            } else if (cacheIndex.exists()) {
                cacheIndex.delete();
            }
        }
    }

    public void testExistingUpdatingIndex_ServerWithExternalIndexer_NcFile_NewGribIosp() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)false);
        this.runTestExistingUpdatingIndex(NcObjectType.FILE, GribIospVersion.NEW);
    }

    public void testExistingUpdatingIndex_ServerWithExternalIndexer_NcDataset_NewGribIosp() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)false);
        this.runTestExistingUpdatingIndex(NcObjectType.DATASET, GribIospVersion.NEW);
    }

    private boolean runTestExistingUpdatingIndex(NcObjectType ncObjType, GribIospVersion gribIospVer) {
        if (!this.gribInit_1_8()) {
            return false;
        }
        if (!this.indexSetup1_8()) {
            return false;
        }
        this.netcdfObj = this.openNc(ncObjType, gribIospVer);
        int timeDimLengthExpected = 8;
        Dimension timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.gribAppend9_12()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.indexSetup1_12()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 12;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.gribAppend13_18()) {
            return false;
        }
        if (!this.indexSetup1_18()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 18;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.gribAppend19_21()) {
            return false;
        }
        if (!this.indexSetup1_21()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 21;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        return true;
    }

    public void testExistingOutOfDateIndex_ServerWithExternalIndexer_NcFile_NewGribIosp() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)false);
        this.runTestExistingOutOfDateIndex(NcObjectType.FILE, GribIospVersion.NEW);
    }

    public void testExistingOutOfDateIndex_ServerWithExternalIndexer_NcDataset_NewGribIosp() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)false);
        this.runTestExistingOutOfDateIndex(NcObjectType.DATASET, GribIospVersion.NEW);
    }

    private boolean runTestExistingOutOfDateIndex(NcObjectType ncObjType, GribIospVersion gribIospVer) {
        if (!this.gribInit_1_8()) {
            return false;
        }
        if (!this.indexSetup1_8()) {
            return false;
        }
        if (!this.gribAppend9_12()) {
            return false;
        }
        this.netcdfObj = this.openNc(ncObjType, gribIospVer);
        int timeDimLengthExpected = 8;
        Dimension timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.indexSetup1_12()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 12;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.gribAppend13_18()) {
            return false;
        }
        if (!this.indexSetup1_18()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 18;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        return true;
    }

    public void testInitiallyMissingUpdatingIndex_ServerWithExternalIndexer_NcFile_NewGribIosp() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)false);
        this.runTestInitiallyMissingUpdatingIndex(NcObjectType.FILE, GribIospVersion.NEW);
    }

    public void testInitiallyMissingUpdatingIndex_ServerWithExternalIndexer_NcDataset_NewGribIosp() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)false);
        this.runTestInitiallyMissingUpdatingIndex(NcObjectType.DATASET, GribIospVersion.NEW);
    }

    private boolean runTestInitiallyMissingUpdatingIndex(NcObjectType ncObjType, GribIospVersion gribIospVer) {
        DiskCache.simulateUnwritableDir = true;
        if (!this.gribInit_1_8()) {
            return false;
        }
        this.netcdfObj = this.openNc(ncObjType, gribIospVer);
        int timeDimLengthExpected = 8;
        Dimension timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.gribAppend9_12()) {
            return false;
        }
        if (!this.indexSetup1_12()) {
            return false;
        }
        if (!this.gribAppend13_18()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 12;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.indexSetup1_18()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 18;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.gribAppend19_21()) {
            return false;
        }
        if (!this.indexSetup1_21()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 21;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        DiskCache.simulateUnwritableDir = false;
        return true;
    }

    public void testMissingIndexUpdatedThenAlternate_ServerWithExternalIndexer_NcFile_NewGribIosp() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)false);
        this.runTestMissingIndexUpdatedThenAlternate(NcObjectType.FILE, GribIospVersion.NEW);
    }

    public void testMissingIndexUpdatedThenAlternate_ServerWithExternalIndexer_NcDataset_NewGribIosp() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)false);
        this.runTestMissingIndexUpdatedThenAlternate(NcObjectType.DATASET, GribIospVersion.NEW);
    }

    private boolean runTestMissingIndexUpdatedThenAlternate(NcObjectType ncObjType, GribIospVersion gribIospVer) {
        DiskCache.simulateUnwritableDir = true;
        if (!this.gribInit_1_8()) {
            return false;
        }
        this.netcdfObj = this.openNc(ncObjType, gribIospVer);
        int timeDimLengthExpected = 8;
        Dimension timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.indexSetup1_8()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.gribAppend9_12()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.indexSetup1_12()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 12;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.gribAppend13_18()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.indexSetup1_18()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 18;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        if (!this.gribAppend19_21()) {
            return false;
        }
        if (!this.indexSetup1_21()) {
            return false;
        }
        if (!this.syncNc(this.netcdfObj)) {
            return false;
        }
        timeDimLengthExpected = 21;
        timeDim = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertEquals((String)("Length of time dimension [" + timeDim.getLength() + "] not as expected [" + timeDimLengthExpected + "]."), (int)timeDim.getLength(), (int)timeDimLengthExpected);
        DiskCache.simulateUnwritableDir = false;
        return true;
    }

    public void testNoIndexTDS() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)false);
        if (!this.setupGrib()) {
            return;
        }
        DiskCache.simulateUnwritableDir = true;
        try {
            this.netcdfObj = NetcdfFile.open((String)this.dataFile.getPath());
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)"exception opening");
        }
        Dimension timePartial = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertTrue((String)("Time dimension [" + timePartial.getLength() + "] not as expected [4]."), (timePartial.getLength() == 4 ? 1 : 0) != 0);
        if (!this.switchToCompleteGrib()) {
            return;
        }
        if (!this.switchToCompleteGribIndex()) {
            return;
        }
        try {
            this.netcdfObj.sync();
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to sync() data file [" + this.dataFile.getPath() + "]: " + e.getMessage()));
            return;
        }
        Dimension timeNew = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertTrue((String)("Time dimension [" + timeNew.getLength() + "] not as expected [21]."), (timeNew.getLength() == 21 ? 1 : 0) != 0);
        DiskCache.simulateUnwritableDir = false;
    }

    public void testNoIndexNextToGrib() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)true);
        if (!this.setupGrib()) {
            return;
        }
        try {
            this.netcdfObj = NetcdfFile.open((String)this.dataFile.getPath());
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)"exception opening");
        }
        Dimension timePartial = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertTrue((String)("Time dimension [" + timePartial.getLength() + "] not as expected [4]."), (timePartial.getLength() == 4 ? 1 : 0) != 0);
        if (!this.switchToCompleteGrib()) {
            return;
        }
        try {
            this.netcdfObj.sync();
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to sync() data file [" + this.dataFile.getPath() + "]: " + e.getMessage()));
            return;
        }
        Dimension timeNew = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertTrue((String)("Time dimension [" + timeNew.getLength() + "] not as expected [21]."), (timeNew.getLength() == 21 ? 1 : 0) != 0);
    }

    public void testExtendModeTrue() {
        GridServiceProvider.setIndexAlwaysInCache((boolean)false);
        GridServiceProvider.setExtendIndex((boolean)true);
        if (!this.setupGribAndPartialIndex0()) {
            return;
        }
        if (!this.switchToCompleteGrib()) {
            return;
        }
        try {
            this.netcdfObj = NetcdfFile.open((String)this.dataFile.getPath());
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)"exception opening");
        }
        Dimension timeComplete = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertTrue((String)("Time dimension [" + timeComplete.getLength() + "] not as expected [21]."), (timeComplete.getLength() == 21 ? 1 : 0) != 0);
        try {
            this.netcdfObj.sync();
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to sync() data file [" + this.dataFile.getPath() + "]: " + e.getMessage()));
            return;
        }
        Dimension timeNew = this.netcdfObj.findDimension("time");
        TestIndexUpdating.assertTrue((String)("Time dimension [" + timeNew.getLength() + "] not as expected [21]."), (timeNew.getLength() == 21 ? 1 : 0) != 0);
    }

    private boolean setupGribAndPartialIndex0() {
        File sourceDataFile = new File(this.dataDir, this.dataFileName + ".part0");
        if (!sourceDataFile.exists()) {
            TestIndexUpdating.fail((String)("Non-existent source data file [" + sourceDataFile.getPath() + "]."));
            return false;
        }
        if (!sourceDataFile.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read source data file [" + sourceDataFile.getPath() + "]."));
            return false;
        }
        try {
            IO.copyFile((File)sourceDataFile, (File)this.dataFile);
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to copy partial grib file [" + sourceDataFile.getPath() + "] to grib file [" + this.dataFile.getPath() + "]: " + e.getMessage()));
            return false;
        }
        if (!this.dataFile.exists()) {
            TestIndexUpdating.fail((String)("Non-existent data file [" + this.dataFile.getPath() + "]."));
            return false;
        }
        if (!this.dataFile.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read data file [" + this.dataFile.getPath() + "]."));
            return false;
        }
        this.indexFilePartial = new File(this.dataDir, this.dataFileName + ".part0.gbx");
        if (!this.indexFilePartial.exists()) {
            TestIndexUpdating.fail((String)("Non-existent partial index file [" + this.indexFilePartial + "]."));
            return false;
        }
        if (!this.indexFilePartial.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read partial index file [" + this.indexFilePartial.getPath() + "]."));
            return false;
        }
        try {
            IO.copyFile((File)this.indexFilePartial, (File)this.indexFile);
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to copy partial index file [" + this.indexFilePartial.getPath() + "] to index file [" + this.indexFile.getPath() + "]: " + e.getMessage()));
            return false;
        }
        if (!this.indexFile.exists()) {
            TestIndexUpdating.fail((String)("Non-existent index file [" + this.indexFile.getPath() + "]."));
            return false;
        }
        if (!this.indexFile.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read index file [" + this.indexFile.getPath() + "]."));
            return false;
        }
        return true;
    }

    private boolean setupGrib() {
        File sourceDataFile = new File(this.dataDir, this.dataFileName + ".part0");
        if (!sourceDataFile.exists()) {
            TestIndexUpdating.fail((String)("Non-existent source data file [" + sourceDataFile.getPath() + "]."));
            return false;
        }
        if (!sourceDataFile.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read data file [" + sourceDataFile.getPath() + "]."));
            return false;
        }
        try {
            IO.copyFile((File)sourceDataFile, (File)this.dataFile);
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to copy partial grib file [" + sourceDataFile.getPath() + "] to grib file [" + this.dataFile.getPath() + "]: " + e.getMessage()));
            return false;
        }
        if (!this.dataFile.exists()) {
            TestIndexUpdating.fail((String)("Non-existent data file [" + this.dataFile.getPath() + "]."));
            return false;
        }
        if (!this.dataFile.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read data file [" + this.dataFile.getPath() + "]."));
            return false;
        }
        return true;
    }

    private boolean switchToCompleteGrib() {
        RandomAccessFile input = null;
        RandomAccessFile output = null;
        try {
            input = new RandomAccessFile(this.dataFile.getPath() + ".extra", "r");
            byte[] extra = new byte[(int)input.length()];
            input.read(extra);
            input.close();
            output = new RandomAccessFile(this.dataFile.getPath(), "rw");
            output.seek(output.length());
            output.write(extra);
            output.close();
        }
        catch (Exception e) {
            TestIndexUpdating.fail((String)("Failed to add file [" + input.getLocation() + "] to  file [" + this.dataFile.getPath() + "]: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private boolean switchToCompleteGribIndex() {
        return this.switchGribIndex(".full.gbx");
    }

    private boolean switchToPartialGribIndex0() {
        return this.switchGribIndex(".part0.gbx");
    }

    private boolean switchToPartialGribIndex1() {
        return this.switchGribIndex(".part1.gbx");
    }

    private boolean switchToPartialGribIndex2() {
        return this.switchGribIndex(".part3.gbx");
    }

    private boolean switchToPartialGribIndex3() {
        return this.switchGribIndex(".part3.gbx");
    }

    private boolean switchToBinaryCompleteGribIndex() {
        return this.switchGribIndex(".binFull.gbx");
    }

    private boolean switchToBinaryBadGribIndex() {
        return this.switchGribIndex(".binModFromPart1.gbx");
    }

    private boolean switchGribIndex(String indexSuffix) {
        this.indexFileFull = new File(this.dataDir, this.dataFileName + indexSuffix);
        if (!this.indexFileFull.exists()) {
            TestIndexUpdating.fail((String)("Non-existent full index file [" + this.indexFileFull + "]."));
            return false;
        }
        if (!this.indexFileFull.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read full index file [" + this.indexFileFull.getPath() + "]."));
            return false;
        }
        try {
            IO.copyFile((File)this.indexFileFull, (File)this.indexFile);
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to copy complete index file [" + this.indexFileFull.getPath() + "] to index file [" + this.indexFile.getPath() + "]: " + e.getMessage()));
            return false;
        }
        if (!this.indexFile.exists()) {
            TestIndexUpdating.fail((String)("Non-existent index file [" + this.indexFile.getPath() + "]."));
            return false;
        }
        if (!this.indexFile.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read index file [" + this.indexFile.getPath() + "]."));
            return false;
        }
        return true;
    }

    private NetcdfFile openNc(NcObjectType t, GribIospVersion gribIospVersion) {
        try {
            if (t.equals((Object)NcObjectType.FILE)) {
                return NetcdfFile.open((String)this.dataFile.getPath(), (String)gribIospVersion.getClassName(), (int)-1, null, null);
            }
            if (t.equals((Object)NcObjectType.DATASET)) {
                return NetcdfDataset.open((String)this.dataFile.getPath(), (String)gribIospVersion.getClassName(), (int)-1, null, null);
            }
            TestIndexUpdating.fail((String)("Unknown NcObjectType [" + t.name() + "]."));
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to open data file [" + this.dataFile.getPath() + "]: " + e.getMessage()));
        }
        catch (Exception e) {
            TestIndexUpdating.fail((String)("Trouble while opening dataset [" + this.dataFile.getPath() + "]: " + e.getMessage()));
        }
        return null;
    }

    private boolean syncNc(NetcdfFile ncf) {
        try {
            ncf.sync();
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to sync() data file [" + ncf.getLocation() + "]: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private boolean gribInit_1_8() {
        File sourceDataFile = new File(this.dataDir, this.dataFileName + this.dataSuffix1_8);
        if (!sourceDataFile.exists()) {
            TestIndexUpdating.fail((String)("Non-existent source GRIB file [" + sourceDataFile.getPath() + "]."));
            return false;
        }
        if (!sourceDataFile.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read the source GRIB file [" + sourceDataFile.getPath() + "]."));
            return false;
        }
        try {
            IO.copyFile((File)sourceDataFile, (File)this.dataFile);
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to copy partial grib file [" + sourceDataFile.getPath() + "] to grib file [" + this.dataFile.getPath() + "]: " + e.getMessage()));
            return false;
        }
        if (!this.dataFile.exists()) {
            TestIndexUpdating.fail((String)("Non-existent data file [" + this.dataFile.getPath() + "]."));
            return false;
        }
        if (!this.dataFile.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read data file [" + this.dataFile.getPath() + "]."));
            return false;
        }
        return true;
    }

    private boolean gribAppend9_12() {
        return this.gribAppend(this.dataSuffix9_12);
    }

    private boolean gribAppend13_18() {
        return this.gribAppend(this.dataSuffix13_18);
    }

    private boolean gribAppend19_21() {
        return this.gribAppend(this.dataSuffix19_21);
    }

    private boolean gribAppend(String suffix) {
        RandomAccessFile input = null;
        RandomAccessFile output = null;
        try {
            input = new RandomAccessFile(this.dataFile.getPath() + suffix, "r");
            byte[] extra = new byte[(int)input.length()];
            input.read(extra);
            input.close();
            output = new RandomAccessFile(this.dataFile.getPath(), "rw");
            output.seek(output.length());
            output.write(extra);
            output.close();
        }
        catch (Exception e) {
            TestIndexUpdating.fail((String)("Failed to add file [" + input.getLocation() + "] to  file [" + this.dataFile.getPath() + "]: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private boolean indexSetup1_8() {
        return this.indexSetup(this.indexSuffix1_8);
    }

    private boolean indexSetup1_12() {
        return this.indexSetup(this.indexSuffix1_12);
    }

    private boolean indexSetup1_18() {
        return this.indexSetup(this.indexSuffix1_18);
    }

    private boolean indexSetup1_21() {
        return this.indexSetup(this.indexSuffix1_21);
    }

    private boolean indexSetup(String suffix) {
        File indexFileSource = new File(this.dataDir, this.indexFileName + suffix);
        if (!indexFileSource.exists()) {
            TestIndexUpdating.fail((String)("Non-existent source index file [" + indexFileSource + "]."));
            return false;
        }
        if (!indexFileSource.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read source index file [" + indexFileSource.getPath() + "]."));
            return false;
        }
        try {
            IO.copyFile((File)indexFileSource, (File)this.indexFile);
        }
        catch (IOException e) {
            TestIndexUpdating.fail((String)("Failed to copy source index file [" + indexFileSource.getPath() + "] to index file [" + this.indexFile.getPath() + "]: " + e.getMessage()));
            return false;
        }
        if (!this.indexFile.exists()) {
            TestIndexUpdating.fail((String)("Non-existent index file [" + this.indexFile.getPath() + "]."));
            return false;
        }
        if (!this.indexFile.canRead()) {
            TestIndexUpdating.fail((String)("Cannot read index file [" + this.indexFile.getPath() + "]."));
            return false;
        }
        return true;
    }

    static enum GribIospVersion {
        NEW("ucar.nc2.iosp.grib.GribGridServiceProvider");

        private String className;

        private GribIospVersion(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }

    static enum NcObjectType {
        FILE("ucar.nc2.NetcdfFile"),
        DATASET("ucar.nc2.NetcdfDataset"),
        FMRC("???thredds.catalog.InvDatasetFmrc???");

        private String className;

        private NcObjectType(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

