/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;

public class TestHybridData
extends TestCase {
    public TestHybridData(String name) {
        super(name);
    }

    public void testCompare() throws IOException {
        File where = new File("C:/data/grib/hybrid");
        if (where.exists()) {
            String[] args = new String[]{"C:/data/grib"};
            this.doAll(args);
        } else {
            this.doAll(null);
        }
    }

    void doAll(String[] args) throws IOException {
        String dirB1 = args == null || args.length < 1 ? TestAll.testdataDir + "grid/grib/grib1/ecmwf" : args[0] + "/hybrid";
        File dir = new File(dirB1);
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + "/" + dir.getName());
            for (String child : children = dir.list()) {
                Variable Hybrid;
                File aChild = new File(dir, child);
                if (aChild.isDirectory() || child.length() == 0 || child.endsWith("ncml") || child.endsWith("gbx") || child.endsWith("gbx8") || child.endsWith("xml") || child.endsWith("nc") || child.startsWith("ls")) continue;
                System.out.println("\n\nReading File " + child);
                long start = System.currentTimeMillis();
                NetcdfFile ncfile = NetcdfFile.open((String)(dirB1 + "/" + child));
                System.out.println("Time to create Netcdf object  " + (System.currentTimeMillis() - start) + "  ms");
                if (child.equals("ECMWF.hybrid.grib1")) {
                    Hybrid = ncfile.findVariable("hybrid");
                    assert (Hybrid.getNameAndDimensions().equals("hybrid(hybrid=91)"));
                    Variable Hybrida = ncfile.findVariable("hybrida");
                    assert (Hybrida.getNameAndDimensions().equals("hybrida(hybrid=91)"));
                    Variable Hybridb = ncfile.findVariable("hybridb");
                    assert (Hybridb.getNameAndDimensions().equals("hybridb(hybrid=91)"));
                    int idx = Hybrid.findDimensionIndex("hybrid");
                    Dimension dim = Hybrid.getDimension(idx);
                } else if (child.equals("07010418_arw_d01.GrbF01500")) {
                    Hybrid = ncfile.findVariable("hybrid");
                    assert (Hybrid.getNameAndDimensions().equals("hybrid(hybrid=2)"));
                }
                ncfile.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        TestHybridData ggi = new TestHybridData("");
        ggi.testCompare();
    }
}

