/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;

public class TestReadingGempak
extends TestCase {
    public TestReadingGempak(String name) {
        super(name);
    }

    public void testCompare() throws IOException {
        File where = new File("C:/data/grib/idd");
        if (where.exists()) {
            String[] args = new String[]{"C:/data/grib/idd"};
            this.doAll(args);
        } else {
            this.doAll(null);
        }
    }

    void doAll(String[] args) throws IOException {
        String dirB1 = args == null || args.length < 1 ? TestAll.testdataDir + "grid/gempak" : args[0] + "/gempak";
        File dir = new File(dirB1);
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + "/" + dir.getName());
            for (String child : children = dir.list()) {
                if (!child.endsWith(".gem") || child.startsWith("air")) continue;
                System.out.println("\n\nReading File " + child);
                long start = System.currentTimeMillis();
                NetcdfFile ncfileBinary = NetcdfFile.open((String)(dirB1 + "/" + child));
                System.out.println("Time to create Netcdf object using Gempak Iosp " + (System.currentTimeMillis() - start) + "  ms");
                ncfileBinary.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        TestReadingGempak ggi = new TestReadingGempak("");
        ggi.testCompare();
    }
}

