/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.dmsp;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.iosp.dmsp.DMSPHeader;
import ucar.nc2.iosp.dmsp.DMSPiosp;
import ucar.unidata.io.RandomAccessFile;

public class TestDmspIosp
extends TestCase {
    private String testFilePath = TestAll.cdmLocalTestDataDir + "dmsp";
    private String testDataFileName = "F14200307192230.n.OIS";
    private String testDataFileFileIdAttValue = "/dmsp/moby-1-3/subscriptions/IBAMA/1353226646955.tmp";
    private String testDataFileDatasetIdAttValue = "DMSP F14 OLS LS & TS";
    private int testDataFileNumBytesPerRecordAttValue = 3040;
    private int testDataFileNumHeaderRecordsAttValue = 1;
    private int testDataFileNumDataRecordsAttValue = 691;
    private int testDataFileNumSamplesPerBandDimAttValue = 1465;
    private String testDataFileSuborbitHistoryAttValue = "F14200307192230.OIS (1,691)";
    private String testDataFileProcessingSystemAttValue = "v2.1b";
    private String testDataFileProcessingDateAttValue = "2003-07-19T19:33:23.000GMT";
    private String testDataFileSpacecraftIdAttValue = "F14";
    private String testDataFileNoradIdAttValue = "24753";
    private double testDataFileAscendingNodeAttValue = 320.55;
    private double testDataFileNodeHeadingAttValue = 8.64;
    private String numDataRecordsDimName = "numScans";
    private String numSamplesPerBandDimName = "numSamplesPerScan";
    private String fileIdAttName = "fileId";
    private String datasetIdAttName = "datasetId";
    private String suborbitHistoryAttName = "suborbitHistory";
    private String processingSystemAttName = "processingSystem";
    private String processingDateAttName = "processingDate";
    private String spacecraftIdAttName = "spacecraftId";
    private String noradIdAttName = "noradId";
    private String ascendingNodeAttName = "ascendingNode";
    private String nodeHeadingAttName = "nodeHeading";
    private DMSPHeader meHeader = null;
    private RandomAccessFile meRaf = null;
    private NetcdfFile meNcf = null;

    public TestDmspIosp(String name) {
        super(name);
    }

    public void testDateFormatHandler() {
        String isoDateFormatString = "yyyy-MM-dd";
        String isoTimeFormatString = "HH:mm:ss.SSSz";
        String isoDateTimeFormatString = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
        String altDateTimeFormatString = "EEE MMM dd HH:mm:ss yyyy";
        int targetDate1Year = 2003;
        int targetDate1Month = 6;
        int targetDate1Day = 19;
        int targetDate1Hour = 19;
        int targetDate1Minute = 33;
        int targetDate1Second = 23;
        int targetDate1Milisecond = 0;
        String targetDate1ISODateString = "2003-07-19";
        String targetDate1ISODateTimeString = "2003-07-19T19:33:23.000GMT";
        String targetDate1AltDateTimeString = "Sat Jul 19 19:33:23 2003";
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        calendar.set(targetDate1Year, targetDate1Month, targetDate1Day, targetDate1Hour, targetDate1Minute, targetDate1Second);
        calendar.set(14, targetDate1Milisecond);
        Date targetDate1 = calendar.getTime();
        Date testDate = null;
        String testDateTimeString = null;
        TestDmspIosp.assertTrue((String)("Alternate date/time format string <" + DMSPHeader.DateFormatHandler.ALT_DATE_TIME.getDateTimeFormatString() + "> not as expected <" + altDateTimeFormatString + ">."), (boolean)DMSPHeader.DateFormatHandler.ALT_DATE_TIME.getDateTimeFormatString().equals(altDateTimeFormatString));
        try {
            testDate = DMSPHeader.DateFormatHandler.ALT_DATE_TIME.getDateFromDateTimeString(targetDate1AltDateTimeString);
        }
        catch (ParseException e) {
            TestDmspIosp.assertTrue((String)("Unexpected ParseException while parsing date/time string <" + targetDate1AltDateTimeString + ">: " + e.getMessage()), (boolean)false);
        }
        TestDmspIosp.assertTrue((String)("Alternate date/time <" + testDate + "> not as expected <" + targetDate1.toString() + ">."), (boolean)testDate.equals(targetDate1));
        testDateTimeString = DMSPHeader.DateFormatHandler.ALT_DATE_TIME.getDateTimeStringFromDate(targetDate1);
        TestDmspIosp.assertTrue((String)("Date/time string <" + testDateTimeString + "> not as expected <" + targetDate1AltDateTimeString + ">."), (boolean)testDateTimeString.equals(targetDate1AltDateTimeString));
    }

    public void testDimAndAtt() throws IOException {
        this.setupReadDmspAsNetcdf(this.testFilePath, this.testDataFileName);
        TestDmspIosp.assertTrue((String)"Created NetcdfFile is null.", (this.meNcf != null ? 1 : 0) != 0);
        Dimension curDim = this.meNcf.getRootGroup().findDimension(this.numDataRecordsDimName);
        TestDmspIosp.assertTrue((String)("Number of data records <" + curDim.getLength() + "> not as expected <" + this.testDataFileNumDataRecordsAttValue + ">."), (curDim.getLength() == this.testDataFileNumDataRecordsAttValue ? 1 : 0) != 0);
        curDim = this.meNcf.getRootGroup().findDimension(this.numSamplesPerBandDimName);
        TestDmspIosp.assertTrue((String)("Number of bytes per records <" + curDim.getLength() + "> not as expected <" + this.testDataFileNumSamplesPerBandDimAttValue + ">."), (curDim.getLength() == this.testDataFileNumSamplesPerBandDimAttValue ? 1 : 0) != 0);
        Attribute curAtt = this.meNcf.getRootGroup().findAttribute(this.fileIdAttName);
        TestDmspIosp.assertTrue((String)("FileId attribute <" + curAtt.getStringValue() + "> not as expected <" + this.testDataFileFileIdAttValue + ">."), (boolean)curAtt.getStringValue().equals(this.testDataFileFileIdAttValue));
        curAtt = this.meNcf.getRootGroup().findAttribute(this.datasetIdAttName);
        TestDmspIosp.assertTrue((String)("DatasetId attribute <" + curAtt.getStringValue() + "> not as expected <" + this.testDataFileDatasetIdAttValue + ">."), (boolean)curAtt.getStringValue().equals(this.testDataFileDatasetIdAttValue));
        curAtt = this.meNcf.getRootGroup().findAttribute(this.suborbitHistoryAttName);
        TestDmspIosp.assertTrue((String)("SuborbitHistory attribute <" + curAtt.getStringValue() + "> not as expected <" + this.testDataFileSuborbitHistoryAttValue + ">."), (boolean)curAtt.getStringValue().equals(this.testDataFileSuborbitHistoryAttValue));
        curAtt = this.meNcf.getRootGroup().findAttribute(this.processingSystemAttName);
        TestDmspIosp.assertTrue((String)("ProcessingSystem attribute <" + curAtt.getStringValue() + "> not as expected <" + this.testDataFileProcessingSystemAttValue + ">."), (boolean)curAtt.getStringValue().equals(this.testDataFileProcessingSystemAttValue));
        curAtt = this.meNcf.getRootGroup().findAttribute(this.processingDateAttName);
        TestDmspIosp.assertTrue((String)("ProcessingDate attribute <" + curAtt.getStringValue() + "> not as expected <" + this.testDataFileProcessingDateAttValue + ">."), (boolean)curAtt.getStringValue().equals(this.testDataFileProcessingDateAttValue));
        curAtt = this.meNcf.getRootGroup().findAttribute(this.spacecraftIdAttName);
        TestDmspIosp.assertTrue((String)("SpacecraftId attribute <" + curAtt.getStringValue() + "> not as expected <" + this.testDataFileSpacecraftIdAttValue + ">."), (boolean)curAtt.getStringValue().equals(this.testDataFileSpacecraftIdAttValue));
        curAtt = this.meNcf.getRootGroup().findAttribute(this.noradIdAttName);
        TestDmspIosp.assertTrue((String)("ProcessingDate attribute <" + curAtt.getStringValue() + "> not as expected <" + this.testDataFileNoradIdAttValue + ">."), (boolean)curAtt.getStringValue().equals(this.testDataFileNoradIdAttValue));
        curAtt = this.meNcf.getRootGroup().findAttribute(this.ascendingNodeAttName);
        TestDmspIosp.assertTrue((String)("AscendingNode attribute <" + curAtt.getNumericValue().doubleValue() + "> not as expected <" + this.testDataFileAscendingNodeAttValue + ">."), (curAtt.getNumericValue().doubleValue() == this.testDataFileAscendingNodeAttValue ? 1 : 0) != 0);
        curAtt = this.meNcf.getRootGroup().findAttribute(this.nodeHeadingAttName);
        TestDmspIosp.assertTrue((String)("NodeHeading attribute <" + curAtt.getNumericValue().doubleValue() + "> not as expected <" + this.testDataFileNodeHeadingAttValue + ">."), (curAtt.getNumericValue().doubleValue() == this.testDataFileNodeHeadingAttValue ? 1 : 0) != 0);
        this.meNcf.close();
    }

    public void testReadEpoch() throws IOException {
        this.setupReadDmspAsNetcdf(this.testFilePath, this.testDataFileName);
        Array year = null;
        try {
            year = this.meNcf.findVariable("year").read();
        }
        catch (IOException e) {
            TestDmspIosp.assertTrue((String)("Unexpected IOException reading \"year\" variable: " + e.getMessage()), (boolean)false);
        }
        int val = 0;
        IndexIterator iter = year.getIndexIterator();
        while (iter.hasNext()) {
            val = iter.getIntNext();
            TestDmspIosp.assertTrue((String)("Value of variable \"year\" <" + val + "> not expected <2003>."), (val == 2003 ? 1 : 0) != 0);
        }
        Array dayOfYear = null;
        try {
            dayOfYear = this.meNcf.findVariable("dayOfYear").read();
        }
        catch (IOException e) {
            TestDmspIosp.assertTrue((String)("Unexpected IOException reading \"dayOfYear\" variable: " + e.getMessage()), (boolean)false);
        }
        val = 0;
        iter = dayOfYear.getIndexIterator();
        while (iter.hasNext()) {
            val = iter.getIntNext();
            TestDmspIosp.assertTrue((String)("Value of variable \"dayOfYear\" <" + val + "> not expected <200>."), (val == 200 ? 1 : 0) != 0);
        }
        Array secondsOfDay = null;
        try {
            secondsOfDay = this.meNcf.findVariable("secondsOfDay").read();
        }
        catch (IOException e) {
            TestDmspIosp.assertTrue((String)("Unexpected IOException reading \"secondsOfDay\" variable: " + e.getMessage()), (boolean)false);
        }
        double prevVal = 0.0;
        double curVal = 0.0;
        double timeInterval = 0.0;
        double timeIntervalGuess = 0.42;
        double delta = 0.01;
        iter = secondsOfDay.getIndexIterator();
        if (iter.hasNext()) {
            prevVal = iter.getDoubleNext();
            int timeStep = 1;
            while (iter.hasNext()) {
                curVal = iter.getDoubleNext();
                timeInterval = curVal - prevVal;
                StringBuffer tmpMsg = new StringBuffer("Variable \"secondsOfDay\": [").append(timeStep).append("]=<").append(curVal).append(">, [").append(timeStep - 1).append("]=<").append(prevVal).append("> difference <").append(timeInterval).append("> not within delta <").append(delta).append("> of expected <").append(timeIntervalGuess).append(">.");
                TestDmspIosp.assertTrue((String)tmpMsg.toString(), (timeInterval >= timeIntervalGuess - delta && timeInterval <= timeIntervalGuess + delta ? 1 : 0) != 0);
                prevVal = curVal;
                ++timeStep;
            }
        }
        this.meNcf.close();
    }

    public void testLatLonCalcAndCache() throws IOException {
        this.setupReadDmspAsNetcdf(this.testFilePath, this.testDataFileName);
        Variable latVar = this.meNcf.findVariable("latitude");
        Array latitude = null;
        try {
            latitude = latVar.read();
        }
        catch (IOException e) {
            TestDmspIosp.assertTrue((String)("Unexpected IOException reading \"latitude\" variable: " + e.getMessage()), (boolean)false);
        }
        IndexIterator iter = latitude.getIndexIterator();
        float curVal = 0.0f;
        float diff = 0.0f;
        float biggestDiff = 0.0f;
        float smallestDiff = 0.0f;
        float prevVal = iter.getFloatNext();
        for (int cnt = 1; iter.hasNext() && cnt < 1465; ++cnt) {
            curVal = iter.getFloatNext();
            diff = curVal - prevVal;
            if (cnt == 1) {
                biggestDiff = diff;
                smallestDiff = diff;
            } else {
                if (diff > biggestDiff) {
                    biggestDiff = diff;
                }
                if (diff < smallestDiff) {
                    smallestDiff = diff;
                }
            }
            prevVal = curVal;
        }
        TestDmspIosp.assertTrue((String)("Biggest difference in latitude between neighboring pixels of the first scan <" + biggestDiff + "> bigger than expected <0.004>."), ((double)biggestDiff < 0.004 ? 1 : 0) != 0);
        TestDmspIosp.assertTrue((String)("Smallest difference in latitude between neighboring pixels of the first scan <" + smallestDiff + "> smaller than expected <0.002>."), ((double)smallestDiff > 0.002 ? 1 : 0) != 0);
        float lat1 = latitude.getFloat(latitude.getIndex().set(0, 0));
        latitude.setFloat(latitude.getIndex().set(0, 0), lat1 + 100.0f);
        Array latPointAfterModify = null;
        try {
            latPointAfterModify = latVar.read("0:0:1,0:0:1");
        }
        catch (InvalidRangeException e) {
            TestDmspIosp.assertTrue((String)("Unexpected InvalidRangeException reading \"latitude\" variable: " + e.getMessage()), (boolean)false);
        }
        catch (IOException e) {
            TestDmspIosp.assertTrue((String)("Unexpected IOException reading \"latitude\" variable: " + e.getMessage()), (boolean)false);
        }
        float lat1After = latPointAfterModify.getFloat(latPointAfterModify.getIndex().set(0, 0));
        TestDmspIosp.assertTrue((String)("Value of lat[0,0] <" + lat1 + "> changed <" + lat1After + ">"), (lat1 == lat1After ? 1 : 0) != 0);
        this.meNcf.close();
    }

    public void testSectionVsSectionNoReduce() throws IOException {
        this.setupReadDmspAsNetcdf(this.testFilePath, this.testDataFileName);
        Variable yearVar = this.meNcf.findVariable("year");
        TestDmspIosp.assertTrue((String)"Year variable not of rank one.", (yearVar.getRank() == 1 ? 1 : 0) != 0);
        Variable visVar = this.meNcf.findVariable("visibleImagery");
        TestDmspIosp.assertTrue((String)"Visible imagery variable not of rank two.", (visVar.getRank() == 2 ? 1 : 0) != 0);
        Variable irVar = this.meNcf.findVariable("infraredImagery");
        TestDmspIosp.assertTrue((String)"Infrared imagery variable not of rank two.", (irVar.getRank() == 2 ? 1 : 0) != 0);
        long visSize = visVar.getSize();
        long irSize = irVar.getSize();
        TestDmspIosp.assertTrue((String)("Visible and infrared imagery variables are different sizes (" + visSize + " vs " + irSize + "."), (visSize == irSize ? 1 : 0) != 0);
        Array yearArray = null;
        try {
            yearArray = yearVar.read("0:1:1");
        }
        catch (InvalidRangeException e) {
            TestDmspIosp.assertTrue((String)("Unexpected InvalidRangeException reading \"year\" variable: " + e.getMessage()), (boolean)false);
        }
        catch (IOException e) {
            TestDmspIosp.assertTrue((String)("Unexpected IOException reading \"year\" variable: " + e.getMessage()), (boolean)false);
        }
        int yearRank = yearArray.getRank();
        TestDmspIosp.assertTrue((String)("Year array not rank 1 <" + yearRank + ">"), (yearRank == 1 ? 1 : 0) != 0);
        Array visArray = null;
        try {
            visArray = visVar.read("0:0:1,0:1:1");
        }
        catch (InvalidRangeException e) {
            TestDmspIosp.assertTrue((String)("Unexpected InvalidRangeException reading \"visibleImagery\" variable: " + e.getMessage()), (boolean)false);
        }
        catch (IOException e) {
            TestDmspIosp.assertTrue((String)("Unexpected IOException reading \"visibleImagery\" variable: " + e.getMessage()), (boolean)false);
        }
        int visRank = visArray.getRank();
        TestDmspIosp.assertTrue((String)("Latitude array rank not 2 <" + visRank + ">."), (visRank == 2 ? 1 : 0) != 0);
        this.meNcf.close();
    }

    private void setupReadDmspAsNetcdf(String testFilePath, String testDataFileName) {
        try {
            NetcdfFile.registerIOProvider(DMSPiosp.class);
        }
        catch (IllegalAccessException e) {
            TestDmspIosp.assertTrue((String)("Unexpected IllegalAccessException registering DMSPiosp: " + e.getMessage()), (boolean)false);
        }
        catch (InstantiationException e) {
            TestDmspIosp.assertTrue((String)("Unexpected InstantiationException registering DMSPiosp: " + e.getMessage()), (boolean)false);
        }
        File testFile = new File(testFilePath, testDataFileName);
        TestDmspIosp.assertTrue((String)("Test file <" + testFile.getAbsolutePath() + "> does not exist."), (boolean)testFile.exists());
        TestDmspIosp.assertTrue((String)("Test file <" + testFile.getAbsolutePath() + "> cannot be read."), (boolean)testFile.canRead());
        TestDmspIosp.assertTrue((String)("Test file <" + testFile.getAbsolutePath() + "> is a directory."), (!testFile.isDirectory() ? 1 : 0) != 0);
        try {
            this.meNcf = NetcdfFile.open((String)testFile.getAbsolutePath());
        }
        catch (IOException e) {
            TestDmspIosp.assertTrue((String)("Unexpected IOException opening DMSP file <" + testFile.getAbsolutePath() + ">: " + e.getMessage()), (boolean)false);
        }
    }
}

