/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.Scanner;
import ucar.unidata.io.RandomAccessFile;

public class ScannerPqact
extends Scanner {
    static int nomatch;
    static int badmatch;
    static int writemsg;
    static long writeBytes;
    static long readBytes;
    private static List<Pqact> pqactList;
    static WritableByteChannel wbc;
    static Formatter out;

    static void extract(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        out.format("Open %s size = %d Kb \n", raf.getLocation(), raf.length() / 1000L);
        MessageScanner scan = new MessageScanner(raf);
        while (scan.hasNext()) {
            Message m;
            block8: {
                m = scan.next();
                if (m == null) {
                    out.format(" bad message in file %s %n", filename);
                    ++bad_msgs;
                    continue;
                }
                readBytes += (long)m.is.getBufrLength();
                try {
                    if (!m.isTablesComplete()) {
                        ++bad_tables;
                    }
                    break block8;
                }
                catch (UnsupportedOperationException e) {
                    ++bad_operation;
                    out.format(" missing operation in file %s, %s %n", filename, e.getMessage());
                }
                catch (Exception e) {
                    out.format(" Exception in file %s, %n", filename);
                    m.dumpHeader(out);
                }
                continue;
            }
            String ttaaii = ScannerPqact.extractWMO(m.getHeader());
            if (ttaaii == null) {
                ++bad_wmo;
                out.format(" bad wmo header in file %s, %s %n", filename, m.getHeader());
                continue;
            }
            boolean hasMatch = false;
            for (Pqact pqact : pqactList) {
                if (!pqact.match(ttaaii, m)) continue;
                hasMatch = true;
                writeBytes += scan.writeCurrentMessage(pqact.getWBC());
                ++writemsg;
                break;
            }
            if (hasMatch || wbc == null) continue;
            ++writemsg;
            writeBytes += scan.writeCurrentMessage(wbc);
        }
        raf.close();
        total_msgs += scan.getTotalMessages();
    }

    static void scanMessageTypesPqact(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        file_size += raf.length();
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m;
            block9: {
                m = scan.next();
                if (m == null) {
                    out.format(" bad message in file %s %n", filename);
                    ++bad_msgs;
                    continue;
                }
                try {
                    if (!m.isTablesComplete()) {
                        ++bad_tables;
                    }
                    break block9;
                }
                catch (UnsupportedOperationException e) {
                    ++bad_operation;
                    out.format(" missing operation in file %s %n", filename);
                    if (wbc == null) continue;
                    scan.writeCurrentMessage(wbc);
                }
                continue;
            }
            String ttaaii = ScannerPqact.extractWMO(m.getHeader());
            if (ttaaii == null) {
                ++bad_wmo;
                continue;
            }
            Pqact matched = null;
            for (Pqact pqact : pqactList) {
                boolean match = pqact.match(ttaaii, m);
                if (matched != null && match) {
                    System.out.println("double match <" + ttaaii + "> with " + matched.pats + " and " + pqact.pats);
                }
                if (!match) continue;
                matched = pqact;
            }
            if (matched == null) {
                System.out.println("no match <" + ttaaii + ">");
                ++nomatch;
            }
            ++count;
        }
        raf.close();
        total_msgs += scan.getTotalMessages();
        good_msgs += count;
        total_obs += scan.getTotalObs();
    }

    static void showTypes() throws IOException {
        out.format("\n===============================================\n", new Object[0]);
        out.format("total_msgs=%d good_msgs=%d bad_msgs=%d incomplete_tables=%d bad_operation=%d %n", total_msgs, good_msgs, bad_msgs, bad_tables, bad_operation);
        out.format(" nomatch=%d badmatch=%d %n", nomatch, badmatch);
        int avg_msg = (int)(file_size / (long)total_msgs);
        int avg_obs = total_obs / total_msgs;
        out.format("total_bytes=%d total_obs=%d avg_msg_size=%d avg_obs/msg=%d \n", file_size, total_obs, avg_msg, avg_obs);
        out.format("\n", new Object[0]);
        Collections.sort(pqactList, new PqactSorter());
        for (Pqact pqact : pqactList) {
            out.format("Pqact %s count=%d fileout= %s\n", pqact.pats, pqact.count, pqact.fileout);
            if (pqact.first != null) {
                pqact.first.dumpHeader(out);
            }
            out.format("\n", new Object[0]);
        }
        out.format("\n", new Object[0]);
    }

    private static void readPqactTable(String filename) throws IOException {
        String line;
        pqactList = new ArrayList<Pqact>();
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        int count = 0;
        while ((line = dataIS.readLine()) != null && (line = line.trim()).length() != 0) {
            if (line.charAt(0) == '#') continue;
            int pos = line.indexOf(59);
            if (pos < 0) {
                pqactList.add(new Pqact(".*" + line + ".*"));
            } else {
                String pats = line.substring(0, pos).trim();
                String fileout = line.substring(pos + 1).trim();
                pqactList.add(new Pqact(".*" + pats + ".*", fileout));
            }
            ++count;
        }
    }

    public static void main(String[] args) throws IOException {
        ScannerPqact.readPqactTable("D:/bufr/pqact.txt");
        File file = new File("D:/bufr/mlodeSorted/unclaimed.bufr");
        FileOutputStream fos = new FileOutputStream(file);
        wbc = fos.getChannel();
        ScannerPqact.test("D:/bufr2/", true, new Scanner.MClosure(){

            @Override
            public void run(String filename) throws IOException {
                ScannerPqact.extract(filename);
            }
        });
        out.format(" scanned %d msgs %d Kb, bad_tables %d, write %d msgs %d Kb %n", total_msgs, readBytes / 1000L, bad_tables, writemsg, writeBytes / 1000L);
        for (Pqact pqact : pqactList) {
            pqact.close();
        }
        if (wbc != null) {
            wbc.close();
        }
    }

    static {
        out = new Formatter(System.out);
    }

    private static class PqactSorter
    implements Comparator<Pqact> {
        private PqactSorter() {
        }

        @Override
        public int compare(Pqact o1, Pqact o2) {
            return o2.count - o1.count;
        }
    }

    private static class Pqact {
        String pats;
        Pattern pattern;
        Message first;
        String fileout;
        int count;
        WritableByteChannel wbc;
        FileOutputStream fos;

        Pqact(String pats) {
            this.pats = pats;
            this.fileout = this.cleanup(pats);
            this.pattern = Pattern.compile(pats);
        }

        Pqact(String pats, String fileout) {
            this.pats = pats;
            this.fileout = fileout;
            this.pattern = Pattern.compile(pats);
        }

        String cleanup(String pats) {
            char[] cc = new char[pats.length()];
            int count = 0;
            for (char c : pats.toCharArray()) {
                if (!Character.isLetterOrDigit(c)) continue;
                cc[count++] = c;
            }
            return new String(cc, 0, count);
        }

        boolean match(String header, Message m) {
            Matcher matcher = this.pattern.matcher(header);
            if (!matcher.matches()) {
                return false;
            }
            if (this.first == null) {
                this.first = m;
            } else if (m.hashCode() != this.first.hashCode()) {
                System.out.println(" DDS doesnt match pqact= " + this.pats);
                this.first.dumpHeader(out);
                m.dumpHeader(out);
                System.out.println();
                ++badmatch;
                return false;
            }
            ++this.count;
            return true;
        }

        WritableByteChannel getWBC() throws FileNotFoundException {
            if (this.wbc == null) {
                File file = new File("D:/bufr3/", this.fileout + ".bufr");
                this.fos = new FileOutputStream(file);
                this.wbc = this.fos.getChannel();
            }
            return this.wbc;
        }

        void close() throws IOException {
            if (this.wbc != null) {
                this.wbc.close();
            }
        }
    }
}

