/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import junit.framework.TestCase;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.RegularSectionLayout;

public class TestRegularSectionLayout
extends TestCase {
    public TestRegularSectionLayout(String name) {
        super(name);
    }

    void doit(RegularSectionLayout rlayout, int[][] result) throws InvalidRangeException {
        int count = 0;
        while (rlayout.hasNext()) {
            Indexer.Chunk chunk = rlayout.next();
            if (count >= result.length) continue;
            assert (chunk.getFilePos() == (long)result[count][0]);
            assert (chunk.getNelems() == result[count][1]);
            assert (chunk.getStartElem() == (long)result[count][2]);
            ++count;
        }
    }

    void doit(RegularSectionLayout rlayout, int[] start, int[] incr) throws InvalidRangeException {
        int count = 0;
        while (rlayout.hasNext()) {
            Indexer.Chunk chunk = rlayout.next();
            assert (chunk.getFilePos() == (long)(start[0] + count * incr[0]));
            assert (chunk.getNelems() == start[1] + count * incr[1]);
            assert (chunk.getStartElem() == (long)(start[2] + count * incr[2]));
            ++count;
        }
    }

    public void test1D() throws InvalidRangeException {
        System.out.println("\n data ================");
        System.out.println("  want     =======");
        Section data = new Section().appendRange(10);
        Section want = new Section().appendRange(2, 5);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{2, 4, 0}});
        System.out.println("\n data ================");
        System.out.println("  want     = = = =");
        data = new Section().appendRange(10);
        want = new Section().appendRange(2, 7, 2);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{2, 1, 0}, {4, 1, 2}, {6, 1, 4}});
        want = new Section().appendRange(2, 10, 3);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{2, 1, 0}, {5, 1, 3}, {8, 1, 6}});
        System.out.println("\n data ================");
        System.out.println("  want        ================");
        data = new Section().appendRange(10);
        want = new Section().appendRange(5, 20);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{5, 5, 0}});
        System.out.println("\n data        ================");
        System.out.println(" want  ================");
        data = new Section().appendRange(10, 30);
        want = new Section().appendRange(5, 20);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{0, 11, 5}});
        System.out.println("\n data    ======");
        System.out.println(" want  ================");
        data = new Section().appendRange(5, 10);
        want = new Section().appendRange(3, 20);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{0, 6, 2}});
        System.out.println("\n data    ======");
        System.out.println(" want  = == = = = = = = = ");
        data = new Section().appendRange(5, 10);
        want = new Section().appendRange(3, 20, 2);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{0, 1, 2}, {2, 1, 4}, {4, 1, 6}});
    }

    public void test2D() throws InvalidRangeException {
        System.out.println("\n data ================");
        System.out.println("  want     =======");
        Section data = new Section().appendRange(10).appendRange(10);
        Section want = new Section().appendRange(2, 5).appendRange(2, 5);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[]{22, 4, 0}, new int[]{10, 0, 4});
        System.out.println("\n data ================");
        System.out.println("  want     = = = =");
        data = new Section().appendRange(10).appendRange(10);
        want = new Section().appendRange(2, 7, 2).appendRange(2, 7, 2);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{22, 1, 0}, {24, 1, 2}, {26, 1, 4}, {42, 1, 6}, {44, 1, 8}, {46, 1, 10}, {62, 1, 12}});
        want = new Section().appendRange(3, 10, 3).appendRange(2, 10, 5);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{32, 1, 0}, {37, 1, 5}, {62, 1, 6}, {67, 1, 11}, {92, 1, 12}, {97, 1, 17}});
        System.out.println("\n data |================|");
        System.out.println("  want        |================|");
        data = new Section().appendRange(10).appendRange(10);
        want = new Section().appendRange(5, 20).appendRange(5, 20);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[]{55, 5, 0}, new int[]{10, 0, 16});
        System.out.println("\n data     |================|");
        System.out.println("  want  |================|");
        data = new Section().appendRange(30).appendRange(10, 500);
        want = new Section().appendRange(15, 99).appendRange(20);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[]{7365, 10, 10}, new int[]{491, 0, 20});
        System.out.println("  want  |================|");
        System.out.println("\n data     |================|");
        data = new Section().appendRange(10, 20).appendRange(5, 50);
        want = new Section().appendRange(5, 12).appendRange(20);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[]{0, 15, 105}, new int[]{46, 0, 20});
        System.out.println("  want      |================|");
        System.out.println("\n data  |================|");
        data = new Section().appendRange(10, 20).appendRange(5, 50);
        want = new Section().appendRange(5, 12).appendRange(20, 30);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[]{15, 11, 55}, new int[]{46, 0, 11});
        System.out.println("\n data    ======");
        System.out.println(" want  ================");
        data = new Section().appendRange(5, 9).appendRange(5, 9);
        want = new Section().appendRange(20).appendRange(20);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[]{0, 5, 105}, new int[]{5, 0, 20});
        System.out.println("\n data    ======");
        System.out.println(" want  ================");
        data = new Section().appendRange(5, 9).appendRange(5, 9);
        want = new Section().appendRange(0, 20).appendRange(0, 20);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[]{0, 5, 110}, new int[]{5, 0, 21});
        System.out.println("\n data    ======");
        System.out.println(" want  = == = = = = = = = ");
        data = new Section().appendRange(5, 9).appendRange(5, 9);
        want = new Section().appendRange(0, 20, 2).appendRange(0, 20, 2);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[][]{{6, 1, 72}, {8, 1, 74}, {16, 1, 94}, {18, 1, 96}});
    }

    public void test2Da() throws InvalidRangeException {
        Section data = new Section().appendRange(20).appendRange(20);
        Section want = new Section().appendRange(1000).appendRange(20);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[0][]);
    }

    public void test3D() throws InvalidRangeException {
        System.out.println("\n data ================");
        System.out.println("  want     =======");
        Section data = new Section().appendRange(10).appendRange(10).appendRange(10);
        Section want = new Section().appendRange(2, 5).appendRange(10).appendRange(10);
        this.doit(new RegularSectionLayout(0L, 1, data, want), new int[]{200, 10, 0}, new int[]{10, 0, 10});
    }
}

