/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.TestAll;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.dt.trajectory.TestARMTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.TestFloat10TrajectoryObsDataset;
import ucar.nc2.dt.trajectory.TestSimpleTrajectoryObsDataset;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.LatLonRect;

public class TestTrajectoryObsDataset
extends TestCase {
    private static String testDataDir = TestAll.cdmLocalTestDataDir;
    private static String remoteTestDataDir = TestAll.testdataDir;

    public TestTrajectoryObsDataset(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public static String getTestDataDir() {
        return testDataDir;
    }

    public static String getRemoteTestDataDir() {
        return remoteTestDataDir;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestSimpleTrajectoryObsDataset.class);
        suite.addTestSuite(TestFloat10TrajectoryObsDataset.class);
        suite.addTestSuite(TestARMTrajectoryObsDataset.class);
        return suite;
    }

    static void testTrajInfo(TrajectoryObsDataset trajDs, TrajDatasetInfo trajDsInfo) throws IOException {
        DataIterator it;
        StructureData sdata;
        PointObsDatatype pointOb;
        TestTrajectoryObsDataset.assertTrue((String)("Title <" + trajDs.getTitle() + "> is not as expected <" + trajDsInfo.getTitle() + ">."), (boolean)(trajDsInfo.getTitle() == null ? trajDs.getTitle() == null : trajDsInfo.getTitle().equals(trajDs.getTitle())));
        TestTrajectoryObsDataset.assertTrue((String)("Description <" + trajDs.getDescription() + "> is not as expected <" + trajDsInfo.getDescription() + ">."), (boolean)(trajDsInfo.getDescription() == null ? trajDs.getDescription() == null : trajDsInfo.getDescription().equals(trajDs.getDescription())));
        TestTrajectoryObsDataset.assertTrue((String)("Dataset location URI <" + trajDs.getLocationURI() + "> not as expected <" + trajDsInfo.getLocationURI() + ">."), (boolean)trajDsInfo.getLocationURI().equals(trajDs.getLocationURI()));
        TestTrajectoryObsDataset.assertTrue((String)("Start date <" + trajDs.getStartDate() + " - " + trajDs.getStartDate().getTime() + "> not as expected <" + trajDsInfo.getStartDateLong() + ">."), (trajDs.getStartDate().getTime() == trajDsInfo.getStartDateLong() ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("End date <" + trajDs.getEndDate() + " - " + trajDs.getEndDate().getTime() + "> not as expected <" + trajDsInfo.getEndDateLong() + ">."), (trajDs.getEndDate().getTime() == trajDsInfo.getEndDateLong() ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Bounding box <" + trajDs.getBoundingBox() + "> not as expteced <" + trajDsInfo.getBb() + ">."), (boolean)(trajDsInfo.getBb() == null ? trajDs.getBoundingBox() == null : trajDsInfo.getBb().equals(trajDs.getBoundingBox())));
        List globalAtts = trajDs.getGlobalAttributes();
        TestTrajectoryObsDataset.assertTrue((String)"Global attributes list is null.", (globalAtts != null ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Number of global attributes <" + globalAtts.size() + "> not as expected <" + trajDsInfo.getNumGlobalAtts() + ">."), (globalAtts.size() == trajDsInfo.getNumGlobalAtts() ? 1 : 0) != 0);
        Attribute gatt = trajDs.findGlobalAttributeIgnoreCase(trajDsInfo.getExampGlobalAttName());
        TestTrajectoryObsDataset.assertTrue((String)("Global attribute \"" + trajDsInfo.getExampGlobalAttName() + "\" <" + gatt.getStringValue() + "> does not contain expected substring <" + trajDsInfo.getExampGlobalAttValSubstring() + ">."), (gatt.getStringValue().indexOf(trajDsInfo.getExampGlobalAttValSubstring()) != -1 ? 1 : 0) != 0);
        List dataVars = trajDs.getDataVariables();
        TestTrajectoryObsDataset.assertTrue((String)"Data vars list is null.", (dataVars != null ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Size of data vars list <" + dataVars.size() + "> not as expected <" + trajDsInfo.getNumVars() + ">."), (dataVars.size() == trajDsInfo.getNumVars() ? 1 : 0) != 0);
        VariableSimpleIF tdv = trajDs.getDataVariable(trajDsInfo.getExampleVarName());
        TestTrajectoryObsDataset.assertTrue((String)("Variable \"" + trajDsInfo.getExampleVarName() + "\" not found."), (tdv != null ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Variable name <" + tdv.getName() + "> not as expected <" + trajDsInfo.getExampleVarName() + ">."), (boolean)tdv.getName().equals(trajDsInfo.getExampleVarName()));
        TestTrajectoryObsDataset.assertTrue((String)("Variable description <" + tdv.getDescription() + "> not as expected <" + trajDsInfo.getExampleVarDescription() + ">."), (boolean)tdv.getDescription().equals(trajDsInfo.getExampleVarDescription()));
        TestTrajectoryObsDataset.assertTrue((String)("Variable units <" + tdv.getUnitsString() + "> not convertable to <" + trajDsInfo.getExampleVarUnitsString() + ">."), (tdv.getUnitsString().equals(trajDsInfo.getExampleVarUnitsString()) || SimpleUnit.isCompatible((String)tdv.getUnitsString(), (String)trajDsInfo.getExampleVarUnitsString()) ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Variable rank <" + tdv.getRank() + "> not as expected <" + trajDsInfo.getExampleVarRank() + ">."), (tdv.getRank() == trajDsInfo.getExampleVarRank() ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Variable shape <" + TestTrajectoryObsDataset.toStringIntArray(tdv.getShape()) + "> not as expected <" + TestTrajectoryObsDataset.toStringIntArray(trajDsInfo.getExampleVarShape()) + ">."), (boolean)TestTrajectoryObsDataset.compareIntArray(tdv.getShape(), trajDsInfo.getExampleVarShape()));
        TestTrajectoryObsDataset.assertTrue((String)("Variable data type <" + tdv.getDataType() + "> not as expected <" + trajDsInfo.getExampleVarDataType() + ">."), (boolean)tdv.getDataType().equals((Object)DataType.getType((String)trajDsInfo.getExampleVarDataType())));
        TestTrajectoryObsDataset.assertTrue((String)("Num variable attributes <" + tdv.getAttributes().size() + "> not as expected <" + trajDsInfo.getExampleVarNumAtts() + ">."), (tdv.getAttributes().size() == trajDsInfo.getExampleVarNumAtts() ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Underlying netCDF file <" + trajDs.getNetcdfFile().getLocation() + "> not as expected <" + trajDsInfo.getLocationURI() + ">."), (boolean)trajDs.getNetcdfFile().getLocation().equals(trajDsInfo.getLocationURI()));
        List trajNames = trajDs.getTrajectoryIds();
        TestTrajectoryObsDataset.assertTrue((String)("Number of trajectory names <" + trajNames.size() + "> more than expected <" + trajDsInfo.getNumTrajs() + ">."), (trajNames.size() == trajDsInfo.getNumTrajs() ? 1 : 0) != 0);
        TrajectoryObsDatatype traj1 = trajDs.getTrajectory(trajDsInfo.getExTrajId());
        TestTrajectoryObsDataset.assertTrue((String)("Trajectory name <" + traj1.getId() + "> not as expected <" + trajDsInfo.getExTrajId() + ">."), (boolean)(trajDsInfo.getExTrajId() == null ? traj1.getId() == null : trajDsInfo.getExTrajId().equals(traj1.getId())));
        TestTrajectoryObsDataset.assertTrue((String)("Trajectory description <" + traj1.getDescription() + "> not as expected <" + trajDsInfo.getExTrajDesc() + ">."), (boolean)(trajDsInfo.getExTrajDesc() == null ? traj1.getDescription() == null : trajDsInfo.getExTrajDesc().equals(traj1.getDescription())));
        TestTrajectoryObsDataset.assertTrue((String)("Number of points in trajectory <" + traj1.getNumberPoints() + "> not as expected <" + trajDsInfo.getExTrajNumPoints() + ">."), (traj1.getNumberPoints() == trajDsInfo.getExTrajNumPoints() ? 1 : 0) != 0);
        Date startDate = null;
        Date endDate = null;
        double startLat = 0.0;
        double startLon = 0.0;
        double startElev = 0.0;
        double endLat = 0.0;
        double endLon = 0.0;
        double endElev = 0.0;
        try {
            startDate = traj1.getTime(0);
            startLat = traj1.getLatitude(0);
            startLon = traj1.getLongitude(0);
            startElev = traj1.getElevation(0);
            endDate = traj1.getTime(traj1.getNumberPoints() - 1);
            endLat = traj1.getLatitude(traj1.getNumberPoints() - 1);
            endLon = traj1.getLongitude(traj1.getNumberPoints() - 1);
            endElev = traj1.getElevation(traj1.getNumberPoints() - 1);
        }
        catch (IOException e) {
            TestTrajectoryObsDataset.assertTrue((String)"Couldn't read first/last time, lat, lon, elev from trajectory.", (boolean)false);
        }
        TestTrajectoryObsDataset.assertTrue((String)("Traj start date <" + startDate + " - " + startDate.getTime() + "> not as expected <" + trajDsInfo.getStartDateLong() + ">."), (startDate.getTime() == trajDsInfo.getStartDateLong() ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Traj end date <" + endDate + " - " + endDate.getTime() + "> not as expected <" + trajDsInfo.getEndDateLong() + ">."), (endDate.getTime() == trajDsInfo.getEndDateLong() ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Start latitude <" + startLat + "> not as expected <" + trajDsInfo.getExampleTrajStartLat() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(startLat, trajDsInfo.getExampleTrajStartLat(), 1.0E-4));
        TestTrajectoryObsDataset.assertTrue((String)("End latitude <" + endLat + "> not as expected <" + trajDsInfo.getExampleTrajEndLat() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(endLat, trajDsInfo.getExampleTrajEndLat(), 1.0E-4));
        TestTrajectoryObsDataset.assertTrue((String)("Start longitude <" + startLon + "> not as expected <" + trajDsInfo.getExampleTrajStartLon() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(startLon, trajDsInfo.getExampleTrajStartLon(), 1.0E-4));
        TestTrajectoryObsDataset.assertTrue((String)("End longitude <" + endLon + "> not as expected <" + trajDsInfo.getExampleTrajEndLon() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(endLon, trajDsInfo.getExampleTrajEndLon(), 1.0E-4));
        TestTrajectoryObsDataset.assertTrue((String)("Start elevation <" + startElev + "> not as expected <" + trajDsInfo.getExampleTrajStartElev() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(startElev, trajDsInfo.getExampleTrajStartElev(), 1.0E-4));
        TestTrajectoryObsDataset.assertTrue((String)("End elevation <" + endElev + "> not as expected <" + trajDsInfo.getExampleTrajEndElev() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(endElev, trajDsInfo.getExampleTrajEndElev(), 1.0E-4));
        Object exampleVarStartVal = null;
        Object exampleVarEndVal = null;
        try {
            Array array = traj1.getData(0, trajDsInfo.getExampleVarName());
            exampleVarStartVal = array.getObject(array.getIndex());
            array = traj1.getData(traj1.getNumberPoints() - 1, trajDsInfo.getExampleVarName());
            exampleVarEndVal = array.getObject(array.getIndex());
        }
        catch (Exception e) {
            TestTrajectoryObsDataset.assertTrue((String)("Failed to read start and end values of " + trajDsInfo.getExampleVarName() + ": " + e.getMessage()), (boolean)false);
        }
        TestTrajectoryObsDataset.assertTrue((String)("Example variable \"" + trajDsInfo.getExampleVarName() + "\" start value <" + exampleVarStartVal + "> not as expected <" + trajDsInfo.getExampleVarStartVal() + "> or " + "end value <" + exampleVarEndVal + "> not as expected <" + trajDsInfo.getExampleVarEndVal() + ">."), (TestTrajectoryObsDataset.doubleWithinEpsilon(((Float)trajDsInfo.getExampleVarStartVal()).doubleValue(), ((Float)exampleVarStartVal).doubleValue(), 1.0E-4) && TestTrajectoryObsDataset.doubleWithinEpsilon(((Float)trajDsInfo.getExampleVarEndVal()).doubleValue(), ((Float)exampleVarEndVal).doubleValue(), 1.0E-4) ? 1 : 0) != 0);
        try {
            pointOb = traj1.getPointObsData(0);
        }
        catch (IOException e) {
            TestTrajectoryObsDataset.assertTrue((String)("IOException on call to getPointObsData(0): " + e.getMessage()), (boolean)false);
            return;
        }
        TestTrajectoryObsDataset.assertTrue((String)("Start time (getPointObsData) <" + pointOb.getNominalTimeAsDate().getTime() + "> not as expected <" + trajDsInfo.getStartDateLong() + ">."), (pointOb.getNominalTimeAsDate().getTime() == trajDsInfo.getStartDateLong() ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Start lat (getPointObsData) <" + pointOb.getLocation().getLatitude() + "> not as expected <" + trajDsInfo.getExampleTrajStartLat() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(pointOb.getLocation().getLatitude(), trajDsInfo.getExampleTrajStartLat(), 1.0E-4));
        TestTrajectoryObsDataset.assertTrue((String)("Start lon (getPointObsData) <" + pointOb.getLocation().getLongitude() + "> not as expected <" + trajDsInfo.getExampleTrajStartLon() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(pointOb.getLocation().getLongitude(), trajDsInfo.getExampleTrajStartLon(), 1.0E-4));
        TestTrajectoryObsDataset.assertTrue((String)("Start alt (getPointObsData) <" + pointOb.getLocation().getAltitude() + "> not as expected <" + trajDsInfo.getExampleTrajStartElev() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(pointOb.getLocation().getAltitude(), trajDsInfo.getExampleTrajStartElev(), 1.0E-4));
        try {
            sdata = traj1.getData(0);
        }
        catch (IOException e) {
            TestTrajectoryObsDataset.assertTrue((String)("IOException on getData(0): " + e.getMessage()), (boolean)false);
            return;
        }
        catch (InvalidRangeException e) {
            TestTrajectoryObsDataset.assertTrue((String)("InvalidRangeException on getData(0): " + e.getMessage()), (boolean)false);
            return;
        }
        TestTrajectoryObsDataset.assertTrue((String)"Null StructureData from getData(0).", (sdata != null ? 1 : 0) != 0);
        try {
            it = traj1.getDataIterator(0);
        }
        catch (IOException e) {
            TestTrajectoryObsDataset.assertTrue((String)("IOException on call to trajectory.getDataIterator(): " + e.getMessage()), (boolean)false);
            return;
        }
        if (it == null) {
            System.out.println("Null trajectory iterator, skipping iterator tests.");
            return;
        }
        if (!it.hasNext()) {
            TestTrajectoryObsDataset.assertTrue((String)"First call to Iterator.hasNext() returned false.", (boolean)false);
            return;
        }
        pointOb = (PointObsDatatype)it.nextData();
        TestTrajectoryObsDataset.assertTrue((String)("Start time (iterator) <" + pointOb.getNominalTimeAsDate().getTime() + "> not as expected <" + trajDsInfo.getStartDateLong() + ">."), (pointOb.getNominalTimeAsDate().getTime() == trajDsInfo.getStartDateLong() ? 1 : 0) != 0);
        TestTrajectoryObsDataset.assertTrue((String)("Start lat (iterator) <" + pointOb.getLocation().getLatitude() + "> not as expected <" + trajDsInfo.getExampleTrajStartLat() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(pointOb.getLocation().getLatitude(), trajDsInfo.getExampleTrajStartLat(), 1.0E-4));
        TestTrajectoryObsDataset.assertTrue((String)("Start lon (iterator) <" + pointOb.getLocation().getLongitude() + "> not as expected <" + trajDsInfo.getExampleTrajStartLon() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(pointOb.getLocation().getLongitude(), trajDsInfo.getExampleTrajStartLon(), 1.0E-4));
        TestTrajectoryObsDataset.assertTrue((String)("Start alt (iterator) <" + pointOb.getLocation().getAltitude() + "> not as expected <" + trajDsInfo.getExampleTrajStartElev() + ">."), (boolean)TestTrajectoryObsDataset.doubleWithinEpsilon(pointOb.getLocation().getAltitude(), trajDsInfo.getExampleTrajStartElev(), 1.0E-4));
    }

    private static boolean compareIntArray(int[] array1, int[] array2) {
        return TestTrajectoryObsDataset.toStringIntArray(array1).equals(TestTrajectoryObsDataset.toStringIntArray(array2));
    }

    private static String toStringIntArray(int[] array) {
        int size = array.length;
        StringBuffer rep = new StringBuffer("int[]=(").append(size).append("){");
        for (int i = 0; i < size; ++i) {
            rep.append(array[i]).append(",");
        }
        return rep.toString();
    }

    private static boolean doubleWithinEpsilon(double value, double target, double epsilon) {
        return target - epsilon <= value && value <= target + epsilon;
    }

    static class TrajDatasetInfo {
        private String title;
        private String description;
        private String locationURI;
        private long startDateLong;
        private long endDateLong;
        private LatLonRect bb;
        private int numGlobalAtts;
        private String exampGlobalAttName;
        private String exampGlobalAttValSubstring;
        private int numVars;
        private String exampleVarName;
        private String exampleVarDescription;
        private String exampleVarUnitsString;
        private int exampleVarRank;
        private int[] exampleVarShape;
        private String exampleVarDataType;
        private int exampleVarNumAtts;
        private Object exampleVarStartVal;
        private Object exampleVarEndVal;
        private int numTrajs;
        private String exTrajId;
        private String exTrajDesc;
        private int exTrajNumPoints;
        private float exampleTrajStartLat;
        private float exampleTrajEndLat;
        private float exampleTrajStartLon;
        private float exampleTrajEndLon;
        private float exampleTrajStartElev;
        private float exampleTrajEndElev;

        public TrajDatasetInfo(String title, String description, String locationURI, long startDateLong, long endDateLong, LatLonRect bb, int numGlobalAtts, String exampGlobalAttName, String exampGlobalAttVal, int numVars, String exampleVarName, String exampleVarDescription, String exampleVarUnitsString, int exampleVarRank, int[] exampleVarShape, String exampleVarDataType, int exampleVarNumAtts, Object exampleVarStartVal, Object exampleVarEndVal, int numTrajs, String exTrajId, String exTrajDesc, int exTrajNumPoints, float exampleTrajStartLat, float exampleTrajEndLat, float exampleTrajStartLon, float exampleTrajEndLon, float exampleTrajStartElev, float exampleTrajEndElev) {
            this.title = title;
            this.description = description;
            this.locationURI = locationURI;
            this.startDateLong = startDateLong;
            this.endDateLong = endDateLong;
            this.bb = bb;
            this.numGlobalAtts = numGlobalAtts;
            this.exampGlobalAttName = exampGlobalAttName;
            this.exampGlobalAttValSubstring = exampGlobalAttVal;
            this.numVars = numVars;
            this.exampleVarName = exampleVarName;
            this.exampleVarDescription = exampleVarDescription;
            this.exampleVarUnitsString = exampleVarUnitsString;
            this.exampleVarRank = exampleVarRank;
            this.exampleVarShape = exampleVarShape;
            this.exampleVarDataType = exampleVarDataType;
            this.exampleVarNumAtts = exampleVarNumAtts;
            this.exampleVarStartVal = exampleVarStartVal;
            this.exampleVarEndVal = exampleVarEndVal;
            this.numTrajs = numTrajs;
            this.exTrajId = exTrajId;
            this.exTrajDesc = exTrajDesc;
            this.exTrajNumPoints = exTrajNumPoints;
            this.exampleTrajStartLat = exampleTrajStartLat;
            this.exampleTrajEndLat = exampleTrajEndLat;
            this.exampleTrajStartLon = exampleTrajStartLon;
            this.exampleTrajEndLon = exampleTrajEndLon;
            this.exampleTrajStartElev = exampleTrajStartElev;
            this.exampleTrajEndElev = exampleTrajEndElev;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLocationURI() {
            return this.locationURI;
        }

        public void setLocationURI(String locationURI) {
            this.locationURI = locationURI;
        }

        public long getStartDateLong() {
            return this.startDateLong;
        }

        public long getEndDateLong() {
            return this.endDateLong;
        }

        public LatLonRect getBb() {
            return this.bb;
        }

        public int getNumGlobalAtts() {
            return this.numGlobalAtts;
        }

        public String getExampGlobalAttName() {
            return this.exampGlobalAttName;
        }

        public String getExampGlobalAttValSubstring() {
            return this.exampGlobalAttValSubstring;
        }

        public int getNumVars() {
            return this.numVars;
        }

        public String getExampleVarName() {
            return this.exampleVarName;
        }

        public String getExampleVarDescription() {
            return this.exampleVarDescription;
        }

        public String getExampleVarUnitsString() {
            return this.exampleVarUnitsString;
        }

        public int getExampleVarRank() {
            return this.exampleVarRank;
        }

        public int getExampleVarNumAtts() {
            return this.exampleVarNumAtts;
        }

        public String getExampleVarDataType() {
            return this.exampleVarDataType;
        }

        public int[] getExampleVarShape() {
            return this.exampleVarShape;
        }

        public int getNumTrajs() {
            return this.numTrajs;
        }

        public String getExTrajId() {
            return this.exTrajId;
        }

        public String getExTrajDesc() {
            return this.exTrajDesc;
        }

        public int getExTrajNumPoints() {
            return this.exTrajNumPoints;
        }

        public float getExampleTrajStartLat() {
            return this.exampleTrajStartLat;
        }

        public float getExampleTrajEndLat() {
            return this.exampleTrajEndLat;
        }

        public float getExampleTrajStartLon() {
            return this.exampleTrajStartLon;
        }

        public float getExampleTrajEndLon() {
            return this.exampleTrajEndLon;
        }

        public float getExampleTrajStartElev() {
            return this.exampleTrajStartElev;
        }

        public float getExampleTrajEndElev() {
            return this.exampleTrajEndElev;
        }

        public Object getExampleVarStartVal() {
            return this.exampleVarStartVal;
        }

        public Object getExampleVarEndVal() {
            return this.exampleVarEndVal;
        }
    }
}

