/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class TestOutstandingIssues
extends TestCase {
    public void testByteAttribute() throws IOException {
        String filename = "dods://localhost:8080/thredds/dodsC/CdataScan/profiler/PROFILER_wind_06min_20070514_2354.nc";
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename, (boolean)true, null);
        assert (ncd != null);
        VariableDS v = (VariableDS)ncd.findVariable("uvQualityCode");
        assert (v != null);
        assert (v.hasMissing());
        int count = 0;
        Array data = v.read();
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            byte val = ii.getByteNext();
            if (v.isMissing((double)val)) {
                ++count;
            }
            if (val == -1) assert (v.isMissing((double)val));
        }
        System.out.println("size = " + v.getSize() + " missing= " + count);
    }
}

