/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSStructure;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSSequence
extends TestCase {
    private boolean debug = false;
    boolean show = false;

    public TestDODSSequence(String name) {
        super(name);
    }

    public void testReadSequence() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.07");
        Variable v = dodsfile.findVariable("person");
        assert (null != v);
        assert (v instanceof Structure);
        assert (v instanceof DODSStructure);
        assert (v.getRank() == 1);
        Array a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 5L) : a.getSize();
        int count = 0;
        int fib = 1;
        int prev = 1;
        IndexIterator iter = a.getIndexIterator();
        while (iter.hasNext()) {
            StructureData data = (StructureData)iter.next();
            assert (data.findMember("name") != null);
            String name = data.getScalarString("name");
            assert (name != null);
            assert (name.equals("This is a data test string (pass " + count + ").")) : name;
            assert (data.findMember("age") != null);
            int agev = data.getScalarInt("age");
            assert (agev == fib) : fib + "!=" + agev;
            ++count;
            int hold = fib;
            fib += prev;
            prev = hold;
        }
    }
}

