/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import timing.Average;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLWriter;

public class TimeOpen
extends TestCase {
    public TimeOpen(String name) {
        super(name);
    }

    static void testAllInDir(File dir, MClosure closure) throws IOException, InvalidRangeException {
        File[] fa = dir.listFiles();
        if (fa == null || fa.length == 0) {
            return;
        }
        List<File> list = Arrays.asList(fa);
        Collections.sort(list);
        for (File f : list) {
            if (f.isDirectory()) {
                TimeOpen.testAllInDir(f, closure);
                continue;
            }
            closure.run(f.getPath());
        }
    }

    public void testWriteNcml() throws IOException, InvalidRangeException {
        Average fileAvg = new Average();
        final NcMLWriter writer = new NcMLWriter();
        TimeOpen.testAllInDir(new File("C:/data/grib/"), new MClosure(){

            @Override
            public void run(String filename) throws IOException, InvalidRangeException {
                if (!filename.endsWith("grib1")) {
                    return;
                }
                NetcdfFile ncfile = NetcdfDataset.openFile((String)filename, null);
                File fileout = new File(filename + ".ncml");
                if (fileout.exists()) {
                    fileout.delete();
                }
                writer.writeXMLexplicit(ncfile, (OutputStream)new FileOutputStream(fileout), null);
                System.out.println(" wrote ncml file  =" + fileout);
            }
        });
    }

    public void testOpenFile() throws IOException, InvalidRangeException {
        final Average fileAvg = new Average();
        TimeOpen.testAllInDir(new File("C:/data/grib/"), new MClosure(){

            @Override
            public void run(String filename) throws IOException, InvalidRangeException {
                if (!filename.endsWith("ncml")) {
                    return;
                }
                System.out.println(" open ncml file  =" + filename);
                TimeOpen.openFile(filename, fileAvg, true);
            }
        });
        System.out.println(" open ncml file  =" + fileAvg);
    }

    static void openFile(String filename, Average avg, boolean enhance) throws IOException, InvalidRangeException {
        try {
            long start = System.nanoTime();
            NetcdfDataset ncfile = enhance ? NetcdfDataset.openDataset((String)filename) : NetcdfDataset.openFile((String)filename, null);
            long end = System.nanoTime();
            double took = (double)(end - start) / 1000.0 / 1000.0 / 1000.0;
            ncfile.close();
            if (avg != null) {
                avg.add(took);
            }
        }
        catch (Exception e) {
            System.out.println("BAD " + filename);
            e.printStackTrace();
        }
    }

    static void testOpenFile(String dir, final String suffix) throws IOException, InvalidRangeException {
        final Average fileAvg = new Average();
        TimeOpen.testAllInDir(new File(dir), new MClosure(){

            @Override
            public void run(String filename) throws IOException, InvalidRangeException {
                if (!filename.endsWith(suffix)) {
                    return;
                }
                TimeOpen.openFile(filename, fileAvg, false);
            }
        });
        System.out.println("*** open " + suffix + " files  =" + fileAvg);
    }

    static void testOpenDataset(String dir, final String suffix) throws IOException, InvalidRangeException {
        final Average fileAvg = new Average();
        TimeOpen.testAllInDir(new File(dir), new MClosure(){

            @Override
            public void run(String filename) throws IOException, InvalidRangeException {
                if (!filename.endsWith(suffix)) {
                    return;
                }
                TimeOpen.openFile(filename, fileAvg, true);
            }
        });
        System.out.println("*** open " + suffix + " datasets  =" + fileAvg);
    }

    public static void main(String[] args) throws IOException, InvalidRangeException {
        String dir = args[0];
        String suffix = args[1];
        TimeOpen.testOpenFile(dir, suffix);
        TimeOpen.testOpenDataset(dir, suffix);
    }

    static interface MClosure {
        public void run(String var1) throws IOException, InvalidRangeException;
    }
}

