/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.File;
import java.io.OutputStream;
import junit.framework.TestCase;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;

public class TestJustRead
extends TestCase {
    private boolean show = false;

    public TestJustRead(String name) {
        super(name);
    }

    public void testReadConventionFiles() throws Exception {
        this.readAllDir(TestAll.testdataDir + "grid/netcdf");
    }

    void readAllDir(String dirName) throws Exception {
        int i;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        for (i = 0; i < allFiles.length; ++i) {
            String name = allFiles[i].getAbsolutePath();
            if (!name.endsWith(".nc")) continue;
            this.doOne(name);
        }
        for (i = 0; i < allFiles.length; ++i) {
            File f = allFiles[i];
            if (!f.isDirectory()) continue;
            this.readAllDir(allFiles[i].getAbsolutePath());
        }
    }

    public void utestProblem() throws Exception {
        this.show = true;
        this.doOne("http://dods.ndbc.noaa.gov/thredds/dodsC/data/stdmet/31201/31201h2005.nc");
    }

    private void doOne(String filename) throws Exception {
        System.out.println("  read dataset with convention parsing= " + filename);
        NetcdfDataset ncDataset = NetcdfDataset.openDataset((String)filename, (boolean)true, null);
        if (this.show) {
            ncDataset.writeNcML((OutputStream)System.out, null);
        }
        ncDataset.close();
    }
}

