/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class TestCompareNetcdf {
    public static String compareSubset(NetcdfFile ncfile, NetcdfFile subset) throws IOException {
        for (Dimension ds : subset.getDimensions()) {
            Dimension d = ncfile.findDimension(ds.getName());
            if (null == d) {
                return "missing dimension " + ds.getName();
            }
            if (d.getLength() != ds.getLength()) {
                return "wrong length, dimension " + ds.getName();
            }
            if (d.isUnlimited() == ds.isUnlimited()) continue;
            return "wrong unlimited, dimension " + ds.getName();
        }
        for (Attribute ds : subset.getGlobalAttributes()) {
            Attribute d = ncfile.findGlobalAttribute(ds.getName());
            if (null == d) {
                return "missing attribute " + ds.getName();
            }
            if (!d.getDataType().equals((Object)ds.getDataType())) {
                return "wrong getDataType, attribute " + ds.getName();
            }
            if (d.getStringValue().equals(ds.getStringValue())) continue;
            return "wrong Value, attribute " + ds.getName();
        }
        for (Variable ds : subset.getVariables()) {
            Variable d = ncfile.findVariable(ds.getName());
            if (null == d) {
                return "missing Variable " + ds.getName();
            }
            String ret = TestCompareNetcdf.compareVariable(d, ds);
            if (null == ret) continue;
            return ret;
        }
        return "ok";
    }

    public static String compareVariable(Variable v, Variable subset) throws IOException {
        Dimension d;
        List s = subset.getDimensions();
        for (int i = 0; i < s.size(); ++i) {
            Dimension ds = (Dimension)s.get(i);
            if (ds.equals((Object)(d = v.getDimension(i)))) continue;
            return "dimension not equals " + ds.getName() + " for variable " + subset.getName();
        }
        for (Dimension ds : subset.getAttributes()) {
            d = v.findAttribute(ds.getName());
            if (null == d) {
                return "missing attribute " + ds.getName() + " for variable " + subset.getName();
            }
            if (!d.getDataType().equals((Object)ds.getDataType())) {
                return "wrong getDataType, attribute " + ds.getName() + " for variable " + subset.getName();
            }
            if (d.getStringValue().equals(ds.getStringValue())) continue;
            return "wrong Value, attribute " + ds.getName() + " for variable " + subset.getName();
        }
        Array vArray = v.read();
        Array sArray = subset.read();
        IndexIterator vIter = vArray.getIndexIterator();
        IndexIterator sIter = sArray.getIndexIterator();
        while (sIter.hasNext()) {
            if (sIter.getDoubleNext() == vIter.getDoubleNext()) continue;
            return "wrong data Value for variable " + subset.getName();
        }
        return null;
    }
}

