/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.StructurePseudo;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;

public class TimeRecords {
    static void doOne(String filename, boolean isTrajectory) throws IOException {
        System.out.println("\nTime " + filename);
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        TimeRecords.readColumns(ncfile);
        TimeRecords.readRows(ncfile);
        if (isTrajectory) {
            TimeRecords.readTrajectoryIterator(filename);
        } else {
            TimeRecords.readStationIterator(filename);
        }
    }

    private static void readColumns(NetcdfFile ncfile) throws IOException {
        long start = System.currentTimeMillis();
        List varList = ncfile.getVariables();
        for (int i = 0; i < varList.size(); ++i) {
            Variable variable = (Variable)varList.get(i);
            Array data = variable.read();
        }
        double took = (double)(System.currentTimeMillis() - start) * 0.001;
        System.out.println("   nvars = " + varList.size());
        System.out.println(" readCols took=" + took + " secs");
    }

    private static void readRows(NetcdfFile ncfile) throws IOException {
        boolean first = true;
        long start = System.currentTimeMillis();
        Structure record = (Structure)ncfile.findVariable("record");
        if (record == null) {
            Dimension d = ncfile.findDimension("Time");
            record = new StructurePseudo(ncfile, null, "precord", d);
            System.out.println("   use psuedo record");
        }
        StructureDataIterator iter = record.getStructureIterator();
        while (iter.hasNext()) {
            StructureData sd = iter.next();
            if (first) {
                System.out.println("   record size = " + sd.getStructureMembers().getStructureSize() + " " + "   nvars = " + sd.getStructureMembers().getMembers().size());
            }
            first = false;
        }
        double took = (double)(System.currentTimeMillis() - start) * 0.001;
        System.out.println(" readRows took=" + took + " secs");
    }

    private static void readTrajectoryIterator(String netcdfFileURI) throws IOException {
        TrajectoryObsDataset tob = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)netcdfFileURI, null, (StringBuilder)new StringBuilder());
        List trajList = tob.getTrajectories();
        for (int i = 0; i < trajList.size(); ++i) {
            double count = 0.0;
            TrajectoryObsDatatype todt = (TrajectoryObsDatatype)trajList.get(i);
            long start = System.currentTimeMillis();
            DataIterator iter = todt.getDataIterator(0);
            while (iter.hasNext()) {
                PointObsDatatype pobs = (PointObsDatatype)iter.nextData();
                count += pobs.getObservationTime();
            }
            double took = (double)(System.currentTimeMillis() - start) * 0.001;
            System.out.println(" readIterator took=" + took + " secs " + count);
        }
    }

    private static void readStationIterator(String netcdfFileURI) throws IOException {
        PointObsDataset tob = (PointObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.POINT, (String)netcdfFileURI, null, (StringBuilder)new StringBuilder());
        double count = 0.0;
        long start = System.currentTimeMillis();
        DataIterator iter = tob.getDataIterator(0);
        while (iter.hasNext()) {
            PointObsDatatype pobs = (PointObsDatatype)iter.nextData();
            StructureData sdata = pobs.getData();
            count += pobs.getObservationTime();
        }
        double took = (double)(System.currentTimeMillis() - start) * 0.001;
        System.out.println(" readIterator took=" + took + " secs " + count);
    }

    public static void main(String[] args) throws IOException {
        TimeRecords.doOne("C:/data/trajectory/135_ordrd.nc", true);
        TimeRecords.doOne("C:/data/trajectory/135_raw.nc", true);
    }
}

