/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import javax.imageio.ImageIO;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

public class TestUnsigned
extends TestCase {
    public TestUnsigned(String name) {
        super(name);
    }

    public void testSigned() throws IOException {
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)(TestAll.cdmLocalTestDataDir + "testWrite.nc"));
        Variable v = null;
        assert (null != (v = ncfile.findVariable("bvar")));
        assert (!v.isUnsigned());
        assert (v.getDataType() == DataType.BYTE);
        boolean hasSigned = false;
        Array data = v.read();
        while (data.hasNext()) {
            byte b = data.nextByte();
            if (b >= 0) continue;
            hasSigned = true;
        }
        assert (hasSigned);
        ncfile.close();
    }

    public void testUnsigned() throws IOException {
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)(TestAll.cdmLocalTestDataDir + "testUnsignedByte.ncml"));
        Variable v = null;
        assert (null != (v = ncfile.findVariable("bvar")));
        assert (v.getDataType() == DataType.FLOAT);
        boolean hasSigned = false;
        Array data = v.read();
        while (data.hasNext()) {
            float b = data.nextFloat();
            if (!(b < 0.0f)) continue;
            hasSigned = true;
        }
        assert (!hasSigned);
        ncfile.close();
    }

    public void testUnsignedWrap() throws IOException {
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2' location='" + TestAll.cdmLocalTestDataDir + "testWrite.nc'>\n" + "  <variable name='bvar' shape='lat' type='byte'>\n" + "    <attribute name='_Unsigned' value='true' />\n" + "    <attribute name='scale_factor' type='float' value='2.0' />\n" + "   </variable>\n" + "</netcdf>";
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncml), null);
        NetcdfDataset ncd = NetcdfDataset.wrap((NetcdfFile)ncfile, (Set)NetcdfDataset.getEnhanceAll());
        Variable v = null;
        assert (null != (v = ncd.findVariable("bvar")));
        assert (v.getDataType() == DataType.FLOAT);
        boolean hasSigned = false;
        Array data = v.read();
        while (data.hasNext()) {
            float b = data.nextFloat();
            if (!(b < 0.0f)) continue;
            hasSigned = true;
        }
        assert (!hasSigned);
        ncd.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convert(String srcPath, double a, double b) throws IOException {
        NetcdfFile ncfile = NetcdfFile.open((String)srcPath);
        try {
            Variable v = ncfile.findVariable("image1/image_data");
            Array array = v.read();
            int[] cmap = new int[256];
            cmap[0] = 0xFFFFFF;
            for (int i = 1; i != 256; ++i) {
                cmap[i] = 0xFF000000 | (255 - i) * 65793;
            }
            IndexColorModel colorModel = new IndexColorModel(8, cmap.length, cmap, 0, true, 1, 0);
            int[] shape = array.getShape();
            BufferedImage bi = new BufferedImage(shape[1], shape[0], 13, colorModel);
            Index index = array.getIndex();
            for (int y = 0; y < shape[0]; ++y) {
                for (int x = 0; x < shape[1]; ++x) {
                    index.set(y, x);
                    byte bval = array.getByte(index);
                    double dval = v.isUnsigned() ? (double)DataType.unsignedByteToShort((byte)bval) : (double)bval;
                    int pval = (int)Math.round(a * dval + b);
                    pval = Math.min(Math.max(pval, 0), 255);
                    bi.getRaster().setSample(x, y, 0, pval);
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "png", os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            ncfile.close();
        }
    }

    public static void main(String[] args) throws IOException {
        TestUnsigned.convert("C:/data/test/RAD_NL25_PCP_NA_200808070810.h5", 1.0, 0.0);
    }
}

