/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;

public class TestSequence
extends TestCase {
    NetcdfFile ncfile;

    public TestSequence(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.ncfile = NetcdfFile.open((String)(TestAll.testdataDir + "lightning/nldn/200929100.ingest"));
    }

    protected void tearDown() throws Exception {
        this.ncfile.close();
    }

    public void testRead() throws IOException {
        List vars = this.ncfile.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            System.out.println(" " + v.getShortName() + " == " + v.getName());
        }
        Variable v = this.ncfile.findVariable("record");
        assert (v != null);
        assert (v instanceof Sequence);
        Sequence record = (Sequence)v;
        vars = record.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable vv = (Variable)vars.get(i);
            System.out.println(" " + vv.getShortName() + " == " + vv.getName());
        }
        Array data = v.read();
        assert (data != null);
        assert (data instanceof ArraySequence);
        ArraySequence as = (ArraySequence)data;
        as.getStructureDataCount();
        System.out.printf(" count = %d%n", as.getStructureDataCount());
        int count = 0;
        StructureDataIterator iter = as.getStructureDataIterator();
        while (iter.hasNext()) {
            StructureData sdata = iter.next();
            ++count;
        }
        System.out.printf(" count = %d%n", count);
        int count2 = 0;
        StructureDataIterator iter2 = record.getStructureIterator();
        while (iter2.hasNext()) {
            StructureData sdata = iter2.next();
            ++count2;
        }
        System.out.printf(" count2 = %d%n", count2);
        assert (count2 == count);
    }
}

