/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestLocal;
import ucar.nc2.TestLocalNC2;
import ucar.nc2.Variable;

public class TestReadSection
extends TestCase {
    public TestReadSection(String name) {
        super(name);
    }

    public void testReadVariableSection() throws InvalidRangeException, IOException {
        Array A;
        Array Asection;
        NetcdfFile ncfile = TestLocalNC2.openFile("testWrite.nc");
        Variable temp = null;
        assert (null != (temp = ncfile.findVariable("temperature")));
        int[] origin = new int[]{3, 6};
        int[] shape = new int[]{12, 17};
        Variable tempSection = temp.section(Range.factory((int[])origin, (int[])shape));
        try {
            Asection = tempSection.read();
        }
        catch (IOException e) {
            System.err.println("ERROR reading file");
            e.printStackTrace();
            assert (false);
            return;
        }
        assert (Asection.getRank() == 2);
        assert (shape[0] == Asection.getShape()[0]);
        assert (shape[1] == Asection.getShape()[1]);
        try {
            A = temp.read();
        }
        catch (IOException e) {
            System.err.println("ERROR reading file");
            assert (false);
            return;
        }
        assert (A.getRank() == 2);
        Array Asection2 = A.section(origin, shape, null);
        assert (Asection2.getRank() == 2);
        assert (shape[0] == Asection2.getShape()[0]);
        assert (shape[1] == Asection2.getShape()[1]);
        IndexIterator s1 = Asection.getIndexIterator();
        IndexIterator s2 = Asection2.getIndexIterator();
        int count = 0;
        while (s1.hasNext()) {
            double d1 = s1.getDoubleNext();
            double d2 = s2.getDoubleNext();
            assert (TestLocal.closeEnough(d1, d2)) : count + " " + d1 + " != " + d2;
            ++count;
        }
        ncfile.close();
        System.out.println("*** testReadVariableSection done");
    }

    public void testReadVariableSection2() throws InvalidRangeException, IOException {
        Array A;
        Array Asection;
        NetcdfFile ncfile = TestLocalNC2.openFile("testWrite.nc");
        Variable temp = null;
        assert (null != (temp = ncfile.findVariable("temperature")));
        ArrayList<Range> ranges = new ArrayList<Range>();
        Range r0 = new Range(3, 14);
        Range r1 = new Range(6, 22);
        ranges.add(r0);
        ranges.add(r1);
        Variable tempSection = temp.section(ranges);
        assert (tempSection.getRank() == 2);
        int[] vshape = tempSection.getShape();
        assert (r0.length() == vshape[0]);
        assert (r1.length() == vshape[1]);
        try {
            Asection = tempSection.read();
        }
        catch (IOException e) {
            System.err.println("ERROR reading file");
            e.printStackTrace();
            assert (false);
            return;
        }
        assert (Asection.getRank() == 2);
        assert (r0.length() == Asection.getShape()[0]);
        assert (r1.length() == Asection.getShape()[1]);
        try {
            A = temp.read();
        }
        catch (IOException e) {
            System.err.println("ERROR reading file");
            assert (false);
            return;
        }
        assert (A.getRank() == 2);
        Array Asection2 = A.section(ranges);
        assert (Asection2.getRank() == 2);
        assert (r0.length() == Asection2.getShape()[0]);
        assert (r1.length() == Asection2.getShape()[1]);
        IndexIterator s1 = Asection.getIndexIterator();
        IndexIterator s2 = Asection2.getIndexIterator();
        int count = 0;
        while (s1.hasNext()) {
            double d1 = s1.getDoubleNext();
            double d2 = s2.getDoubleNext();
            assert (TestLocal.closeEnough(d1, d2)) : count + " " + d1 + " != " + d2;
            ++count;
        }
        ncfile.close();
        System.out.println("*** testReadVariableSection2 done");
    }
}

