/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.io.RandomAccessFile;

public class TestMisc
extends TestCase {
    public void testCompareLongs() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Object[] dateList = new Date[]{sdf.parse("2002-01-01"), sdf.parse("2002-01-02"), sdf.parse("2002-01-03"), sdf.parse("2002-01-04"), sdf.parse("2002-02-05"), sdf.parse("2002-03-06")};
            Arrays.sort(dateList, new DateComparator1());
            System.out.println("sort error: " + Arrays.toString(dateList));
            Arrays.sort(dateList, new DateComparator2());
            System.out.println("sort fix:   " + Arrays.toString(dateList));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Long.toString(0L);
    }

    public void testErie() throws IOException, InvalidRangeException {
        String uri = "C:\\data\\work\\signell/erie_test.ncml";
        String var = "temp";
        GridDataset ds = GridDataset.open((String)uri);
        GeoGrid grid = ds.findGridByName(var);
        Section s = new Section(grid.getShape());
        System.out.printf("var = %s %n", s);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        VerticalTransform vt = gcs.getVerticalTransform();
        ArrayDouble.D3 z = vt.getCoordinateArray(0);
        Section sv = new Section(z.getShape());
        System.out.printf("3dcoord = %s %n", sv);
        s = s.removeRange(0);
        assert (s.equals((Object)sv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileClosing() throws IOException, InvalidRangeException {
        File inDir = new File("C:/data/work/ansari/");
        RandomAccessFile.setDebugLeaks((boolean)true);
        for (File file : inDir.listFiles()) {
            NetcdfFile ncIn = null;
            try {
                System.out.println("PROCESSING: " + file);
                ncIn = NetcdfFile.open((String)file.toURI().toURL().toString());
            }
            catch (Exception e) {
                System.err.println("CAUGHT EXCEPTION: " + e);
            }
            finally {
                try {
                    ncIn.close();
                }
                catch (Exception e) {}
            }
        }
        System.out.printf("open files:%n", new Object[0]);
        for (String raf : RandomAccessFile.getOpenFiles()) {
            System.out.printf(" %s %n", raf);
        }
    }

    public void utestModifyNCfile() throws IOException, InvalidRangeException {
        String inputFileName = "C:/tmp/input.nc";
        String outputFileName = "C:/tmp/output.nc";
        NetcdfFileWriteable writableFile = NetcdfFileWriteable.openExisting((String)"C:/tmp/input.nc");
        writableFile.setRedefineMode(true);
        Variable ffgVariable = writableFile.findVariable("FFG");
        Array ffgVarArray = ffgVariable.read();
        Index ffgIndex = ffgVarArray.getIndex();
        writableFile.setName("C:/tmp/output.nc");
        writableFile.create();
        ffgVarArray.setDouble(ffgIndex.set(0), 10.1);
        ffgVarArray.setDouble(ffgIndex.set(1), 10.2);
        ffgVarArray.setDouble(ffgIndex.set(2), 10.3);
        ffgVarArray.setDouble(ffgIndex.set(3), 10.4);
        writableFile.flush();
        writableFile.close();
    }

    public static void main(String[] args) {
        String s1 = "CoastWatch/MODSCW/closest_chlora/Mean/CB05/P2009190";
        String s2 = "CoastWatch/MODSCW/closest_chlora/Mean/SE05/P2009190";
        System.out.printf("s1 = %d s2 = %d%n", s1.hashCode(), s2.hashCode());
    }

    private class DateComparator2
    implements Comparator<Date> {
        private DateComparator2() {
        }

        @Override
        public int compare(Date f1, Date f2) {
            if (f2.getTime() == f1.getTime()) {
                return 0;
            }
            return f2.getTime() > f1.getTime() ? 1 : -1;
        }
    }

    private class DateComparator1
    implements Comparator<Date> {
        private DateComparator1() {
        }

        @Override
        public int compare(Date f1, Date f2) {
            System.out.print(f2 + "-" + f1 + " =" + f2.getTime() + "-" + f1.getTime() + " =  int: " + (int)(f2.getTime() - f1.getTime()));
            System.out.println("  long: " + (f2.getTime() - f1.getTime()));
            return (int)(f2.getTime() - f1.getTime());
        }
    }
}

