/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAttributes;
import ucar.nc2.TestDump;
import ucar.nc2.TestLocal;
import ucar.nc2.TestLongOffset;
import ucar.nc2.TestOpenInMemory;
import ucar.nc2.TestRead;
import ucar.nc2.TestReadRecord;
import ucar.nc2.TestReadSection;
import ucar.nc2.TestReadStrides;
import ucar.nc2.TestRedefine;
import ucar.nc2.TestSlice;
import ucar.nc2.TestStructure;
import ucar.nc2.TestStructureArray;
import ucar.nc2.TestUnsigned;
import ucar.nc2.TestWrite;
import ucar.nc2.TestWriteFill;
import ucar.nc2.TestWriteMiscProblems;
import ucar.nc2.TestWriteRecord;
import ucar.nc2.dataset.TestScaleOffsetMissingForStructure;
import ucar.nc2.iosp.TestIndexer;
import ucar.nc2.iosp.TestRegularLayout;
import ucar.nc2.util.cache.TestNetcdfFileCache;

public class TestLocalNC2 {
    public static boolean dumpFile = false;

    public static NetcdfFile open(String filename) {
        try {
            System.out.println("**** Open " + filename);
            NetcdfFile ncfile = NetcdfFile.open((String)filename, null);
            if (dumpFile) {
                System.out.println("open " + ncfile);
            }
            return ncfile;
        }
        catch (IOException e) {
            System.out.println(" fail = " + e);
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    public static NetcdfFile openFile(String filename) {
        return TestLocalNC2.open(TestLocal.cdmTestDataDir + filename);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestSuite(TestIndexer.class));
        suite.addTest((Test)new TestSuite(TestRegularLayout.class));
        suite.addTest((Test)new TestSuite(TestNetcdfFileCache.class));
        suite.addTest((Test)new TestSuite(TestWrite.class));
        suite.addTest((Test)new TestSuite(TestRead.class));
        suite.addTest((Test)new TestSuite(TestOpenInMemory.class));
        suite.addTest((Test)new TestSuite(TestAttributes.class));
        suite.addTest((Test)new TestSuite(TestWriteRecord.class));
        suite.addTest((Test)new TestSuite(TestWriteFill.class));
        suite.addTest((Test)new TestSuite(TestWriteMiscProblems.class));
        suite.addTest((Test)new TestSuite(TestReadRecord.class));
        suite.addTest((Test)new TestSuite(TestDump.class));
        suite.addTest((Test)new TestSuite(TestRedefine.class));
        suite.addTest((Test)new TestSuite(TestLongOffset.class));
        suite.addTest((Test)new TestSuite(TestReadSection.class));
        suite.addTest((Test)new TestSuite(TestStructure.class));
        suite.addTest((Test)new TestSuite(TestStructureArray.class));
        suite.addTest((Test)new TestSuite(TestReadStrides.class));
        suite.addTest((Test)new TestSuite(TestScaleOffsetMissingForStructure.class));
        suite.addTest((Test)new TestSuite(TestSlice.class));
        suite.addTest((Test)new TestSuite(TestUnsigned.class));
        return suite;
    }
}

