/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;

public class TestHTTP
extends TestCase {
    String testDir = "http://motherlode.ucar.edu/test/";

    public TestHTTP(String name) {
        super(name);
    }

    public void testNC2() throws IOException {
        NetcdfFile ncfile = NetcdfFile.open((String)(this.testDir + "mydata1.nc"));
        assert (ncfile != null);
        assert (null != ncfile.findDimension("lat"));
        assert (null != ncfile.findDimension("lon"));
        assert ("face".equals(ncfile.findAttValueIgnoreCase(null, "yo", "barf")));
        Variable temp = null;
        assert (null != (temp = ncfile.findVariable("temperature")));
        assert ("K".equals(ncfile.findAttValueIgnoreCase(temp, "units", "barf")));
        Attribute att = temp.findAttribute("scale");
        assert (null != att);
        assert (att.isArray());
        assert (3 == att.getLength());
        assert (3 == att.getNumericValue(2).intValue());
        att = temp.findAttribute("versionD");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (1.2 == att.getNumericValue().doubleValue());
        att = temp.findAttribute("versionF");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (1.2f == att.getNumericValue().floatValue());
        assert (this.close(1.2, att.getNumericValue().doubleValue()));
        att = temp.findAttribute("versionI");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (1 == att.getNumericValue().intValue());
        att = temp.findAttribute("versionS");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (2 == att.getNumericValue().shortValue());
        att = temp.findAttribute("versionB");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (3 == att.getNumericValue().byteValue());
        Array A = temp.read();
        Index ima = A.getIndex();
        int[] shape = A.getShape();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                assert (A.getDouble(ima.set(i, j)) == (double)(i * 1000000 + j * 1000));
            }
        }
        System.out.println("*****************  Test HTTP done");
    }

    boolean close(double d1, double d2) {
        return Math.abs((d1 - d2) / d1) < 1.0E-5;
    }

    public List makeList() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("http://motherlode.ucar.edu/dods/casestudies/2004Aug03/2004080301_metar.nc");
        list.add("http://motherlode.ucar.edu/dods/casestudies/2004Aug03/2004080302_metar.nc");
        list.add("http://motherlode.ucar.edu/dods/casestudies/2004Aug03/2004080303_metar.nc");
        list.add("http://motherlode.ucar.edu/dods/casestudies/2004Aug03/2004080304_metar.nc");
        list.add("http://motherlode.ucar.edu/dods/casestudies/2004Aug03/2004080305_metar.nc");
        list.add("http://motherlode.ucar.edu/dods/casestudies/2004Aug03/2004080306_metar.nc");
        return list;
    }

    public void testOpenDataset() throws IOException {
        long start = System.currentTimeMillis();
        long totalBytes = 0L;
        List locs = this.makeList();
        for (String loc : locs) {
            System.out.printf("open %s%n", loc);
            NetcdfDataset.open((String)loc);
        }
        totalBytes /= 1000L;
        System.out.println("**testOpenDataset took= " + (System.currentTimeMillis() - start) + " msec ");
    }

    public void testOpenGrid() throws IOException {
        long start = System.currentTimeMillis();
        long totalBytes = 0L;
        List locs = this.makeList();
        for (String loc : locs) {
            GridDataset.open((String)loc);
        }
        totalBytes /= 1000L;
        System.out.println("**testOpenGrid took= " + (System.currentTimeMillis() - start) + " msec ");
    }

    public void utestReadAll() throws IOException {
        long start = System.currentTimeMillis();
        long totalBytes = 0L;
        List locs = this.makeList();
        Iterator iter = locs.iterator();
        if (iter.hasNext()) {
            String loc = (String)iter.next();
            totalBytes += this.readAllData(loc);
        }
        System.out.println("**That took= " + (System.currentTimeMillis() - start) + " msec for " + (totalBytes /= 1000L) + " Kbytes");
    }

    private long readAllData(String location) throws IOException {
        System.out.println("------Open " + location);
        NetcdfFile ncfile = NetcdfFile.open((String)location);
        long total = 0L;
        for (Variable v : ncfile.getVariables()) {
            long nbytes = v.getSize() * (long)v.getElementSize();
            System.out.println("  Try to read variable " + v.getName() + " " + nbytes);
            v.read();
            total += v.getSize() * (long)v.getElementSize();
        }
        ncfile.close();
        return total;
    }
}

