/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class TestExamples {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void Nexam1() {
        int[] varShape;
        String filename = "C:/data/my/file.nc";
        NetcdfFile ncfile = null;
        try {
            ncfile = NetcdfFile.open((String)filename);
            this.process(ncfile);
        }
        catch (IOException ioe) {
            this.log("trying to open " + filename, ioe);
        }
        finally {
            if (null != ncfile) {
                try {
                    ncfile.close();
                }
                catch (IOException ioe) {
                    this.log("trying to open " + filename, ioe);
                }
            }
        }
        String varName = "first_angle";
        Variable v = ncfile.findVariable(varName);
        try {
            Array data = v.read("0:2:1, 0:19:1");
            NCdump.printArray((Array)data, (String)varName, (PrintStream)System.out, null);
        }
        catch (IOException ioe) {
            this.log("trying to read " + varName, ioe);
        }
        catch (InvalidRangeException e) {
            this.log("Invalid Range for " + varName, e);
        }
        try {
            int[] origin = new int[]{0, 0};
            int[] shape = new int[]{2, 19};
            Array data = v.read(origin, shape);
            Index ima = data.getIndex();
            ArrayList<Range> ranges = new ArrayList<Range>();
            ranges.add(new Range(2, 2));
            ranges.add(new Range(0, 499, 2));
            ranges.add(new Range(0, 719, 2));
            Array data2 = v.read(ranges);
        }
        catch (Throwable e) {
            this.log("Invalid Range for " + varName, e);
        }
        try {
            varShape = v.getShape();
            int[] origin = new int[3];
            int[] shape = new int[]{1, varShape[1], varShape[2]};
            int i = 0;
            while (i < 3) {
                origin[0] = i++;
                Array data2D = v.read(origin, shape);
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            ranges.add(null);
            ranges.add(new Range(0, varShape[1], 2));
            ranges.add(new Range(0, varShape[2], 2));
            for (int i2 = 0; i2 < 3; ++i2) {
                ranges.set(0, new Range(i2, i2));
                Array data2D = v.read(ranges);
            }
        }
        catch (Throwable e) {
            this.log("Invalid Range for " + varName, e);
        }
        try {
            varShape = v.getShape();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < varShape.length; ++i) {
                Range.appendShape(ranges, (int)varShape[i]);
            }
            Array data = v.read();
            double sum = 0.0;
            IndexIterator ii = data.getIndexIterator();
            while (ii.hasNext()) {
                sum += ii.getDoubleNext();
            }
            int[] dataShape = data.getShape();
            ranges = new ArrayList();
            for (int i = 0; i < dataShape.length; ++i) {
                ranges.add(new Range(0, dataShape[i], 5));
            }
            sum = 0.0;
            ii = data.getRangeIterator(ranges);
            while (ii.hasNext()) {
                sum += ii.getDoubleNext();
            }
        }
        catch (Throwable e) {
            this.log("Invalid Range for " + varName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void Ex3() {
        String filename = "C:/data/my/file.nc";
        NetcdfFile ncfile = null;
        try {
            ncfile = NetcdfDataset.openFile((String)filename, null);
            this.process(ncfile);
        }
        catch (IOException ioe) {
            this.log("trying to open " + filename, ioe);
        }
        finally {
            if (null != ncfile) {
                try {
                    ncfile.close();
                }
                catch (IOException ioe) {
                    this.log("trying to close " + filename, ioe);
                }
            }
        }
    }

    void log(String what, Throwable t) {
    }

    void process(NetcdfFile ncfile) {
    }
}

