/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.IteratorFast;

public class TimeIterator {
    public void write(float[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
    }

    public float read(float[] a) {
        float sum = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public void writeArray(Array A) {
        int count = 0;
        IndexIterator iter = A.getIndexIterator();
        while (iter.hasNext()) {
            iter.setFloatNext((float)count++);
        }
    }

    public void writeArray2(Array A) {
        int size = (int)A.getSize();
        for (int i = 0; i < size; ++i) {
            A.setFloat(i, (float)i);
        }
    }

    public float readArray(Array A) {
        float sum = 0.0f;
        IndexIterator iter = A.getIndexIterator();
        while (iter.hasNext()) {
            sum += iter.getFloatNext();
        }
        return sum;
    }

    public float readArray2(Array A) {
        float sum = 0.0f;
        IteratorFast iter = (IteratorFast)A.getIndexIterator();
        while (iter.hasNext()) {
            sum += iter.getFloatNext();
        }
        return sum;
    }

    public float readArray3(Array A) {
        int size = (int)A.getSize();
        float sum = 0.0f;
        for (int i = 0; i < size; ++i) {
            sum += A.getFloat(i);
        }
        return sum;
    }

    public float readArray4(Array A) {
        ArrayFloat Afloat = (ArrayFloat)A;
        int size = (int)A.getSize();
        float sum = 0.0f;
        for (int i = 0; i < size; ++i) {
            sum += Afloat.getFloat(i);
        }
        return sum;
    }

    public void test(int z) {
        int size = 1000000;
        System.out.println("\nTest size= " + z + " Mbytes");
        long start = System.currentTimeMillis();
        Array A = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{z * size});
        long took = System.currentTimeMillis() - start;
        System.out.println("createArray took = " + took + " msecs");
        start = System.currentTimeMillis();
        this.writeArray(A);
        took = System.currentTimeMillis() - start;
        System.out.println("writeArray took = " + took + " msecs");
        start = System.currentTimeMillis();
        this.writeArray2(A);
        took = System.currentTimeMillis() - start;
        System.out.println("writeArray(setFloat(elem)) took = " + took + " msecs");
        start = System.currentTimeMillis();
        this.readArray(A);
        took = System.currentTimeMillis() - start;
        System.out.println("readArray took = " + took + " msecs");
        start = System.currentTimeMillis();
        this.readArray2(A);
        took = System.currentTimeMillis() - start;
        System.out.println("readArray(FastIterator) took = " + took + " msecs");
        start = System.currentTimeMillis();
        this.readArray3(A);
        took = System.currentTimeMillis() - start;
        System.out.println("readArray(getFloat(elem)) took = " + took + " msecs");
        start = System.currentTimeMillis();
        this.readArray4(A);
        took = System.currentTimeMillis() - start;
        System.out.println("readArray(ArrayFloat) took = " + took + " msecs");
        start = System.currentTimeMillis();
        float[] data = new float[z * size];
        took = System.currentTimeMillis() - start;
        System.out.println("create took = " + took + " msecs");
        start = System.currentTimeMillis();
        this.write(data);
        took = System.currentTimeMillis() - start;
        System.out.println("write took = " + took + " msecs");
        start = System.currentTimeMillis();
        this.read(data);
        took = System.currentTimeMillis() - start;
        System.out.println("read took = " + took + " msecs");
    }

    public static void main(String[] args) throws IOException {
        TimeIterator ti = new TimeIterator();
        ti.test(50);
        ti.test(50);
        ti.test(50);
        System.in.read();
    }
}

