/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.util.IO;

public class TestWcsServer
extends TestCase {
    private String server = "http://localhost:8080/thredds/wcs/";
    private String server2 = "http://motherlode.ucar.edu:8080/thredds/wcs/";
    private String ncdcWcsServer = "http://eclipse.ncdc.noaa.gov:9090/thredds/wcs/";
    private String ncdcWcsDataset = "http://eclipse.ncdc.noaa.gov:9090/thredds/wcs/gfsmon/largedomain.nc";
    private String ncdcOpendapDataset = "http://eclipse.ncdc.noaa.gov:9090/thredds/dodsC/gfsmon/largedomain.nc";

    public TestWcsServer(String name) {
        super(name);
    }

    public void testPfeg() throws IOException {
        String dataset = "http://localhost:8080/thredds/wcs/satellite/AT/ssta/1day";
        this.showGetCapabilities(dataset);
        this.showDescribeCoverage(dataset, "ATssta");
        this.showGetCoverage(dataset, "ATssta", "2006-01-04T23:59:59Z", null, "220,20,250,50", "netCDF3", false);
    }

    public void testFmrc() throws IOException {
        String dataset = "http://motherlode.ucar.edu:9080/thredds/wcs/fmrc/NCEP/NAM/CONUS_80km/best.ncd";
        this.showGetCapabilities(dataset);
        this.showDescribeCoverage(dataset, "Precipitable_water");
        this.showGetCoverage(dataset, "Precipitable_water", "2006-08-11T18:00:00Z", null, "220,20,250,50", "netCDF3", false);
    }

    public void testBbox() throws IOException {
        String dataset = "http://motherlode.ucar.edu:9080/thredds/wcs/galeon/testdata/RUC.nc";
        this.showGetCapabilities(dataset);
        String fld = "Geopotential_height";
        this.showDescribeCoverage(dataset, fld);
        this.showGetCoverage(dataset, fld, null, null, "-125.9237889957627,67.498658,-50.43356200423729,132.87735", "GeoTIFF", false);
    }

    public void testNorwayProblem() throws IOException {
        String dataset = "http://localhost:8080/thredds/wcs/Cdata/problem/FORDAILY_start20061206_dump20061228.nc";
        this.showGetCapabilities(dataset);
        String fld = "temperature";
        this.showDescribeCoverage(dataset, fld);
        this.showGetCoverage(dataset, fld, null, null, "-10,50,10,80", "NetCDF3", false);
    }

    public void eTestForEthan() throws IOException {
        this.showGetCapabilities(this.ncdcWcsDataset);
        this.showGetCapabilities(this.server2 + "?dataset=" + this.ncdcOpendapDataset + "&");
    }

    public void utestGC() throws IOException {
        this.testGC("testdata/ocean.nc");
        this.testGC("testdata/eta.nc");
        this.testGC("testdata/RUC.nc");
        this.testGC("testdata/sst.nc");
        this.testGC("testdata/striped.nc");
    }

    private void testGC(String dataset) throws IOException {
        String url = this.server + dataset + "?request=GetCapabilities&version=1.0.0&service=WCS";
        String contents = IO.readURLcontentsWithException((String)url);
        System.out.println(url + " is OK, len= " + contents.length());
    }

    public void testShow1() throws IOException {
        this.showGetCapabilities(this.server + "galeon/ocean.nc?");
        this.showDescribeCoverage(this.server + "galeon/ocean.nc?", "u_sfc");
        this.showGetCoverage(this.server + "galeon/ocean.nc?", "u_sfc", "2005-03-17T12:00:00Z", null, "-100,20,-50,44.40", "netCDF3", false);
    }

    public void testDatasetParam() throws IOException {
        this.showGetCapabilities(this.server + "?dataset=http://localhost:8080/thredds/dodsC/testContent/testData.nc&");
        this.showDescribeCoverage(this.server + "?dataset=http://localhost:8080/thredds/dodsC/testContent/testData.nc&", "Z_sfc");
        this.showGetCoverage(this.server + "?dataset=http://localhost:8080/thredds/dodsC/testContent/testData.nc&", "Z_sfc", "2003-09-25T00:00:00Z", null, "-100,20,-50,44.40", "netCDF3", false);
    }

    public void testRoy() throws IOException {
        String dataset = "http://motherlode.ucar.edu:8080/thredds/wcs/fmrc/NCEP/NAM/CONUS_80km/files/NAM_CONUS_80km_20080424_1200.grib1";
        this.showGetCapabilities(dataset);
        String fld = "Total_precipitation";
        this.showDescribeCoverage(dataset, fld);
        this.showGetCoverage(dataset, fld, "2008-04-26T00:00:00Z", null, "-140,20,-100,40", "GeoTIFFfloat", false);
    }

    private void showGetCapabilities(String url) throws IOException {
        this.showRead(url + "?request=GetCapabilities&version=1.0.0&service=WCS");
    }

    private void showDescribeCoverage(String url, String grid) throws IOException {
        this.showRead(url + "?request=DescribeCoverage&version=1.0.0&service=WCS&coverage=" + grid);
    }

    private void showGetCoverage(String url, String grid, String time, String vert, String bb, String format, boolean showOnly) throws IOException {
        String getURL = url + "?request=GetCoverage&version=1.0.0&service=WCS&coverage=" + grid;
        boolean isNetcdf = format.equalsIgnoreCase("netCDF3");
        getURL = getURL + "&format=" + format;
        if (time != null) {
            getURL = getURL + "&time=" + time;
        }
        if (vert != null) {
            getURL = getURL + "&vertical=" + vert;
        }
        if (bb != null) {
            getURL = getURL + "&bbox=" + bb;
        }
        System.out.println("****************\n");
        System.out.println("req= " + getURL);
        String filename = "C:/TEMP/" + grid;
        filename = isNetcdf ? filename + ".nc" : filename + ".tiff";
        if (showOnly) {
            String contents = IO.readURLcontentsWithException((String)getURL);
            System.out.println(contents);
            return;
        }
        File file = new File(filename);
        String result = IO.readURLtoFile((String)getURL, (File)file);
        System.out.println("****************\n");
        System.out.println("result= " + result);
        System.out.println(" copied contents to " + file.getPath());
        if (isNetcdf) {
            NetcdfFile ncfile = NetcdfFile.open((String)file.getPath());
            assert (ncfile != null);
        }
    }

    public void testReq() {
        String server = "http://motherlode.ucar.edu:8080/";
        String req = server + "thredds/wcs/testdata/sst.nc?SERVICE=WCS&" + "VERSION=1.0.0&REQUEST=GetCoverage&COVERAGE=tos&CRS=EPSG%3a4326&BBOX=1,-79.5,359,89.5" + "&TIME=2002-12-07T00:00:00Z&FORMAT=GeoTIFF&EXCEPTIONS=application/vnd.ogc.se_xml";
        System.out.println("req= " + req);
        File file = new File("C:/TEMP/martin.tiff");
        System.out.println("****************\n");
        String result = IO.readURLtoFile((String)req, (File)file);
        System.out.println("result= " + result);
        System.out.println(" copied contents to " + file.getPath());
    }

    private void showRead(String url) throws IOException {
        System.out.println("****************\n");
        System.out.println(url + "\n");
        String contents = IO.readURLcontentsWithException((String)url);
        System.out.println(contents);
    }
}

