/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import thredds.cataloggen.SimpleCatalogBuilder;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class TestCrawlableDatasetImpl
extends TestCase {
    private static HashMap hash = new HashMap(20);

    public TestCrawlableDatasetImpl(String name) {
        super(name);
    }

    protected void setup() {
    }

    public void testSlashRoot() {
        this.doRootPathTesting("/");
    }

    public void testFooRoot() {
        this.doRootPathTesting("foo/");
    }

    public void testFooBarRoot() {
        this.doRootPathTesting("foo/bar/");
    }

    public void testSlashFooRoot() {
        this.doRootPathTesting("/foo/");
    }

    public void testSlashFooBarRoot() {
        this.doRootPathTesting("/foo/bar/");
    }

    public void doRootPathTesting(String rootPath) {
        String catAsString;
        System.out.println("Test with root = \"" + rootPath + "\"");
        TestCrawlableDatasetImpl.setupTestCollection(rootPath);
        CrawlableDataset top = TestCrawlableDatasetImpl.getInstance(rootPath);
        this.showCrDsAndDescendants(top);
        System.out.println("Generate top catalog");
        SimpleCatalogBuilder builder = new SimpleCatalogBuilder("", top, "myservice", "OPENDAP", "/thredds/dodsC/");
        try {
            catAsString = builder.generateCatalogAsString(top);
        }
        catch (IOException e) {
            System.out.println("ERROR generating catalog: " + e.getMessage());
            return;
        }
        System.out.println(catAsString);
        CrawlableDataset nc = TestCrawlableDatasetImpl.getInstance(rootPath + "nc");
        System.out.println("Generate nc catalog");
        builder = new SimpleCatalogBuilder("", top, "myservice", "OPENDAP", "/thredds/dodsC/");
        try {
            catAsString = builder.generateCatalogAsString(nc);
        }
        catch (IOException e) {
            System.out.println("ERROR generating catalog: " + e.getMessage());
            return;
        }
        System.out.println(catAsString);
        CrawlableDataset ncTest = TestCrawlableDatasetImpl.getInstance(rootPath + "nc/Test");
        System.out.println("Generate nc/Test catalog");
        builder = new SimpleCatalogBuilder("", top, "myservice", "OPENDAP", "/thredds/dodsC/");
        try {
            catAsString = builder.generateCatalogAsString(ncTest);
        }
        catch (IOException e) {
            System.out.println("ERROR generating catalog: " + e.getMessage());
            return;
        }
        System.out.println(catAsString);
    }

    private void showCrDsAndDescendants(CrawlableDataset crDs) {
        List childList;
        System.out.println("path <" + crDs.getPath() + ">  name <" + crDs.getName() + ">");
        try {
            childList = crDs.listDatasets();
        }
        catch (IOException e) {
            System.out.println("ERROR listing children: " + e.getMessage());
            return;
        }
        Iterator it = childList.iterator();
        while (it.hasNext()) {
            this.showCrDsAndDescendants((CrawlableDataset)it.next());
        }
    }

    public static CrawlableDataset getInstance(String path) {
        return (CrawlableDataset)hash.get(path);
    }

    public static void setupTestCollection(String root) {
        if (!hash.isEmpty()) {
            hash.clear();
        }
        MyCrDs crDs1 = new MyCrDs(root + "", true, null, null);
        crDs1.addChild(new MyCrDs(root + "jojo.dat", false, crDs1, null));
        MyCrDs crDs2 = new MyCrDs(root + "nc", true, crDs1, null);
        crDs1.addChild(crDs2);
        crDs2.addChild(new MyCrDs(root + "nc/123.nc", false, crDs2, null));
        crDs2.addChild(new MyCrDs(root + "nc/fnoc1.nc", false, crDs2, null));
        crDs2.addChild(new MyCrDs(root + "nc/test1.nc", false, crDs2, null));
        MyCrDs crDs6 = new MyCrDs(root + "nc/Test", true, crDs2, null);
        crDs2.addChild(crDs6);
        crDs6.addChild(new MyCrDs(root + "nc/Test/test.nc", false, crDs6, null));
        crDs6.addChild(new MyCrDs(root + "nc/Test/testfile.nc", false, crDs6, null));
        MyCrDs crDs9 = new MyCrDs(root + "ascii", true, crDs1, null);
        crDs1.addChild(crDs9);
        crDs9.addChild(new MyCrDs(root + "ascii/abc.txt", false, crDs9, null));
        crDs9.addChild(new MyCrDs(root + "ascii/123.txt", false, crDs9, null));
        MyCrDs crDs12 = new MyCrDs(root + "ascii/more", true, crDs9, null);
        crDs9.addChild(crDs12);
        crDs12.addChild(new MyCrDs(root + "ascii/more/junk.txt", false, crDs12, null));
        crDs12.addChild(new MyCrDs(root + "ascii/more/mojunk.txt", false, crDs12, null));
    }

    private static class MyCrDs
    implements CrawlableDataset {
        private String path;
        private String name;
        private boolean isCollection;
        private MyCrDs parent;
        private List childList;

        private MyCrDs(String path, boolean isCollection, MyCrDs parent, List childList) {
            this.path = !path.equals("/") && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            this.name = this.path.equals("/") ? "" : path.substring(path.lastIndexOf("/") + 1);
            this.isCollection = isCollection;
            this.parent = parent;
            this.childList = childList != null ? childList : new ArrayList();
            hash.put(path, this);
        }

        private void addChild(MyCrDs child) {
            this.childList.add(child);
        }

        public Object getConfigObject() {
            return null;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public CrawlableDataset getParentDataset() {
            return this.parent;
        }

        public boolean exists() {
            return true;
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public CrawlableDataset getDescendant(String relativePath) {
            return null;
        }

        public List listDatasets() throws IOException {
            return new ArrayList(this.childList);
        }

        public List listDatasets(CrawlableDatasetFilter filter) throws IOException {
            List list = this.listDatasets();
            if (filter == null) {
                return list;
            }
            ArrayList<CrawlableDataset> retList = new ArrayList<CrawlableDataset>();
            for (CrawlableDataset curDs : list) {
                if (!filter.accept(curDs)) continue;
                retList.add(curDs);
            }
            return retList;
        }

        public long length() {
            return -1L;
        }

        public Date lastModified() {
            return null;
        }
    }
}

