/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.IOException;
import junit.framework.TestCase;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.cataloggen.config.DatasetFilter;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.DatasetSourceStructure;
import thredds.cataloggen.config.DatasetSourceType;
import thredds.cataloggen.config.ResultService;

public class TestDatasetFilter
extends TestCase {
    private String parentDsName1 = null;
    private String parentDsName2 = null;
    private String parentDsName3 = null;
    private String parentDsUrl1 = null;
    private String parentDsUrl2 = null;
    private String parentDsUrl3 = null;
    private InvDatasetImpl parentDs1 = null;
    private InvDatasetImpl parentDs2 = null;
    private InvDatasetImpl parentDs3 = null;
    private String name1 = null;
    private String name2 = null;
    private DatasetFilter.Type type1 = null;
    private String matchPattern1 = null;
    private String matchPattern2 = null;
    private DatasetSource dsSource = null;
    private StringBuilder out = null;
    private DatasetFilter me = null;

    public TestDatasetFilter(String name) {
        super(name);
    }

    protected void setUp() {
        this.parentDsName1 = "parent dataset 1";
        this.parentDsName2 = "parent dataset 2";
        this.parentDsName3 = "Parent dataset 3";
        this.parentDsUrl1 = "http://server/parentDatasetUrl1";
        this.parentDsUrl2 = "http://server/parentDatasetUrl2";
        this.parentDsUrl3 = "http://server/ParentDatasetUrl3";
        this.parentDs1 = new InvDatasetImpl(null, this.parentDsName1);
        this.parentDs1.setUrlPath(this.parentDsUrl1);
        this.parentDs2 = new InvDatasetImpl(null, this.parentDsName2);
        this.parentDs2.setUrlPath(this.parentDsUrl2);
        this.parentDs3 = new InvDatasetImpl(null, this.parentDsName3);
        this.parentDs3.setUrlPath(this.parentDsUrl3);
        this.name1 = "name 1";
        this.name2 = "name 2";
        this.type1 = DatasetFilter.Type.REGULAR_EXPRESSION;
        this.matchPattern1 = "match pattern 1";
        this.matchPattern2 = "match pattern 2";
        this.dsSource = DatasetSource.newDatasetSource((String)"dsSource", (DatasetSourceType)DatasetSourceType.LOCAL, (DatasetSourceStructure)DatasetSourceStructure.DIRECTORY_TREE, (String)"access point 1", null);
        this.out = new StringBuilder();
        this.me = new DatasetFilter(this.dsSource, this.name1, this.type1, this.matchPattern1);
    }

    public void testGetters() {
        TestDatasetFilter.assertTrue((this.me.getParentDatasetSource() == this.dsSource ? 1 : 0) != 0);
        TestDatasetFilter.assertTrue((boolean)this.me.getName().equals(this.name1));
        TestDatasetFilter.assertTrue((boolean)this.me.getType().equals((Object)this.type1));
        TestDatasetFilter.assertTrue((boolean)this.me.getMatchPattern().equals(this.matchPattern1));
    }

    public void testValid() {
        StringBuilder stringBuilder = new StringBuilder();
        DatasetFilter dsFilter = new DatasetFilter(this.dsSource, this.name1, this.type1, this.matchPattern1);
        boolean isValid = dsFilter.validate(stringBuilder);
        TestDatasetFilter.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
        stringBuilder = new StringBuilder();
        dsFilter = new DatasetFilter(this.dsSource, null, this.type1, this.matchPattern1);
        isValid = dsFilter.validate(stringBuilder);
        TestDatasetFilter.assertFalse((String)stringBuilder.toString(), (boolean)isValid);
        stringBuilder = new StringBuilder();
        dsFilter = new DatasetFilter(this.dsSource, "", this.type1, this.matchPattern1);
        isValid = dsFilter.validate(stringBuilder);
        TestDatasetFilter.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
        stringBuilder = new StringBuilder();
        dsFilter = new DatasetFilter(this.dsSource, this.name1, null, this.matchPattern1);
        isValid = dsFilter.validate(stringBuilder);
        TestDatasetFilter.assertFalse((String)stringBuilder.toString(), (boolean)isValid);
        stringBuilder = new StringBuilder();
        dsFilter = new DatasetFilter(this.dsSource, this.name1, this.type1, null);
        isValid = dsFilter.validate(stringBuilder);
        TestDatasetFilter.assertFalse((String)stringBuilder.toString(), (boolean)isValid);
    }

    public void testAccept() {
        String dssName = "ds source";
        String dssAccessPoint = "./src/test/data/thredds/cataloggen/testData/modelNotFlat";
        String dssAccessPointHeader = "./src/test/data/thredds/cataloggen/testData";
        String dsLoc = "./src/test/data/thredds/cataloggen/testData/modelNotFlat/eta_211/2004050300_eta_211.nc";
        InvDataset ds = null;
        ResultService rs = new ResultService("srv", ServiceType.DODS, "", null, dssAccessPointHeader);
        DatasetSource dsSource = DatasetSource.newDatasetSource((String)dssName, (DatasetSourceType)DatasetSourceType.LOCAL, (DatasetSourceStructure)DatasetSourceStructure.FLAT, (String)dssAccessPoint, (ResultService)rs);
        DatasetFilter dsFilter = new DatasetFilter(dsSource, "dsF", DatasetFilter.Type.REGULAR_EXPRESSION, "nc$");
        try {
            ds = dsSource.createDataset(dsLoc, null);
        }
        catch (IOException e) {
            TestDatasetFilter.assertTrue((String)("IOException creating dataset <" + dsLoc + ">: " + e.getMessage()), (boolean)false);
        }
        dsFilter.accept(ds);
        rs = new ResultService("srv", ServiceType.DODS, "", null, dssAccessPointHeader);
        dsSource = DatasetSource.newDatasetSource((String)dssName, (DatasetSourceType)DatasetSourceType.LOCAL, (DatasetSourceStructure)DatasetSourceStructure.FLAT, (String)dssAccessPoint, (ResultService)rs);
        dsFilter = new DatasetFilter(dsSource, "dsF", DatasetFilter.Type.REGULAR_EXPRESSION, ".*\\.nc");
        try {
            ds = dsSource.createDataset(dsLoc, null);
        }
        catch (IOException e) {
            TestDatasetFilter.assertTrue((String)("IOException creating dataset <" + dsLoc + ">: " + e.getMessage()), (boolean)false);
        }
        dsFilter.accept(ds);
    }
}

