/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.util.List;
import junit.framework.TestCase;
import thredds.catalog2.Property;
import thredds.catalog2.simpleImpl.PropertyContainer;

public class TestPropertyContainer
extends TestCase {
    public TestPropertyContainer(String name) {
        super(name);
    }

    public void testNewContainer() {
        PropertyContainer pc = new PropertyContainer();
        TestPropertyContainer.assertFalse((boolean)pc.isBuilt());
        TestPropertyContainer.assertTrue((String)"New property container not empty.", (boolean)pc.isEmpty());
        int size = pc.size();
        TestPropertyContainer.assertTrue((String)("New property container not size()==0 [" + size + "]."), (size == 0 ? 1 : 0) != 0);
        TestPropertyContainer.assertFalse((String)"New property container has property [name].", (boolean)pc.containsPropertyName("name"));
        TestPropertyContainer.assertTrue((String)"New property container list of properties not empty.", (boolean)pc.getProperties().isEmpty());
        Property prop = pc.getPropertyByName("name");
        if (prop != null) {
            TestPropertyContainer.fail((String)("New property container holds unexpected property [name]/[" + prop.getValue() + "]."));
        }
        TestPropertyContainer.assertTrue((String)"New property container list of property names not empty.", (boolean)pc.getPropertyNames().isEmpty());
        String value = pc.getPropertyValue("name");
        if (value != null) {
            TestPropertyContainer.fail((String)("New property container holds unexpected property value [name]/[" + value + "]."));
        }
    }

    public void testAddGetReplaceRemoveIsEmpty() {
        PropertyContainer pc = new PropertyContainer();
        TestPropertyContainer.assertTrue((String)"New property container not isEmpty().", (boolean)pc.isEmpty());
        String name1 = "name1";
        String value1 = "value1";
        pc.addProperty(name1, value1);
        TestPropertyContainer.assertFalse((String)"Property container with one entry isEmpty().", (boolean)pc.isEmpty());
        String name2 = "name2";
        String value2 = "value2";
        pc.addProperty(name2, value2);
        TestPropertyContainer.assertFalse((String)"Property container with two entries isEmpty().", (boolean)pc.isEmpty());
        String name3 = "name3";
        String value3 = "value3";
        pc.addProperty(name3, value3);
        TestPropertyContainer.assertFalse((String)"Property container with three entries isEmpty().", (boolean)pc.isEmpty());
        int size = pc.size();
        TestPropertyContainer.assertTrue((String)("Property container with three entries has unexpected size() [" + size + "]"), (size == 3 ? 1 : 0) != 0);
        String testValue = pc.getPropertyValue(name1);
        TestPropertyContainer.assertTrue((String)("Name[" + name1 + "]/Value[" + testValue + "] not as expected [" + name1 + "]/[" + value1 + "]."), (boolean)testValue.equals(value1));
        testValue = pc.getPropertyValue(name2);
        TestPropertyContainer.assertTrue((String)("Name[" + name2 + "]/Value[" + testValue + "] not as expected [" + name2 + "]/[" + value2 + "]."), (boolean)testValue.equals(value2));
        testValue = pc.getPropertyValue(name3);
        TestPropertyContainer.assertTrue((String)("Name[" + name3 + "]/Value[" + testValue + "] not as expected [" + name3 + "]/[" + value3 + "]."), (boolean)testValue.equals(value3));
        String unknownName = "unknownName";
        testValue = pc.getPropertyValue(unknownName);
        TestPropertyContainer.assertTrue((String)("Contained value [" + testValue + "] for unknown name [" + unknownName + "]."), (null == testValue ? 1 : 0) != 0);
        String value1_new = "value1_new";
        pc.addProperty(name1, value1_new);
        testValue = pc.getPropertyValue(name1);
        TestPropertyContainer.assertTrue((String)("Value of replaced property [" + name1 + "]/[" + testValue + "] not as expected [" + name1 + "]/[" + value1_new + "]"), (boolean)testValue.equals(value1_new));
        if (!pc.removeProperty(name1)) {
            TestPropertyContainer.fail((String)("Failed to remove property [" + name1 + "]."));
        }
        testValue = pc.getPropertyValue(name1);
        TestPropertyContainer.assertNull((String)("Found property [" + name1 + "]/[" + testValue + "] after removal."), (Object)testValue);
        if (pc.removeProperty(unknownName)) {
            TestPropertyContainer.fail((String)("Succeeded in removing unkown property [" + unknownName + "]."));
        }
        if (!pc.removeProperty(name2)) {
            TestPropertyContainer.fail((String)("Failed to remove property [" + name2 + "]."));
        }
        if (!pc.removeProperty(name3)) {
            TestPropertyContainer.fail((String)("Failed to remove property [" + name3 + "]."));
        }
        if (pc.removeProperty(name3)) {
            TestPropertyContainer.fail((String)("Succeeded in removing no longer contained property [" + name3 + "]."));
        }
        TestPropertyContainer.assertTrue((String)"Property container empty due to removes not isEmpty().", (boolean)pc.isEmpty());
        size = pc.size();
        TestPropertyContainer.assertTrue((String)("Property container empty due to removes has size()!=0 [" + size + "]"), (size == 0 ? 1 : 0) != 0);
    }

    public void testAllGetters() {
        PropertyContainer pc = new PropertyContainer();
        String name1 = "name1";
        String value1 = "value1";
        pc.addProperty(name1, value1);
        String name2 = "name2";
        String value2 = "value2";
        pc.addProperty(name2, value2);
        String name3 = "name3";
        String value3 = "value3";
        pc.addProperty(name3, value3);
        List propList = pc.getProperties();
        TestPropertyContainer.assertTrue((propList.size() == 3 ? 1 : 0) != 0);
        TestPropertyContainer.assertTrue((boolean)((Property)propList.get(0)).getName().equals(name1));
        TestPropertyContainer.assertTrue((boolean)((Property)propList.get(0)).getValue().equals(value1));
        TestPropertyContainer.assertTrue((boolean)((Property)propList.get(1)).getName().equals(name2));
        TestPropertyContainer.assertTrue((boolean)((Property)propList.get(1)).getValue().equals(value2));
        TestPropertyContainer.assertTrue((boolean)((Property)propList.get(2)).getName().equals(name3));
        TestPropertyContainer.assertTrue((boolean)((Property)propList.get(2)).getValue().equals(value3));
        TestPropertyContainer.assertTrue((boolean)pc.getPropertyByName(name1).getName().equals(name1));
        TestPropertyContainer.assertTrue((boolean)pc.getPropertyByName(name1).getValue().equals(value1));
        TestPropertyContainer.assertTrue((boolean)pc.getPropertyByName(name2).getName().equals(name2));
        TestPropertyContainer.assertTrue((boolean)pc.getPropertyByName(name2).getValue().equals(value2));
        TestPropertyContainer.assertTrue((boolean)pc.getPropertyByName(name3).getName().equals(name3));
        TestPropertyContainer.assertTrue((boolean)pc.getPropertyByName(name3).getValue().equals(value3));
        List nameList = pc.getPropertyNames();
        TestPropertyContainer.assertTrue((nameList.size() == 3 ? 1 : 0) != 0);
        TestPropertyContainer.assertTrue((boolean)((String)nameList.get(0)).equals(name1));
        TestPropertyContainer.assertTrue((boolean)((String)nameList.get(1)).equals(name2));
        TestPropertyContainer.assertTrue((boolean)((String)nameList.get(2)).equals(name3));
        TestPropertyContainer.assertTrue((boolean)pc.getPropertyValue(name1).equals(value1));
        TestPropertyContainer.assertTrue((boolean)pc.getPropertyValue(name2).equals(value2));
        TestPropertyContainer.assertTrue((boolean)pc.getPropertyValue(name3).equals(value3));
    }

    public void testBuild() {
        PropertyContainer pc = new PropertyContainer();
        String name1 = "name1";
        String value1 = "value1";
        pc.addProperty(name1, value1);
        String name2 = "name2";
        String value2 = "value2";
        pc.addProperty(name2, value2);
        String name3 = "name3";
        String value3 = "value3";
        pc.addProperty(name3, value3);
        pc.build();
        TestPropertyContainer.assertTrue((boolean)pc.isBuilt());
        try {
            pc.addProperty("name", "value");
        }
        catch (IllegalStateException e) {
            try {
                pc.removeProperty("name");
            }
            catch (IllegalStateException e2) {
                return;
            }
            TestPropertyContainer.fail((String)"Built property container did not throw IllegalStateException on removeProperty().");
        }
        TestPropertyContainer.fail((String)"Built property container did not throw IllegalStateException on addProperty().");
    }
}

