/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import thredds.catalog.DataFormatType;
import thredds.catalog.ServiceType;
import thredds.catalog2.Access;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.AccessImpl;
import thredds.catalog2.simpleImpl.ServiceImpl;

public class TestAccessImpl
extends TestCase {
    private AccessImpl access;
    private ServiceBuilder serviceBuilder;
    private String serviceName;
    private URI serviceBaseUri;
    private ServiceType type;
    private String urlPath;
    private int dataSize;
    private DataFormatType formatType;

    public TestAccessImpl(String name) {
        super(name);
    }

    protected void setUp() {
        this.serviceName = "serviceName";
        try {
            this.serviceBaseUri = new URI("http://server/thredds/dodsC/");
        }
        catch (URISyntaxException e) {
            TestAccessImpl.fail((String)("Bad URI syntax: " + e.getMessage()));
        }
        this.type = ServiceType.OPENDAP;
        this.serviceBuilder = new ServiceImpl(this.serviceName, this.type, this.serviceBaseUri, null);
        this.urlPath = "someData.nc";
        this.dataSize = 5678;
        this.formatType = DataFormatType.NETCDF;
    }

    public void testCtorAndBuilderSetGet() {
        AccessImpl access = new AccessImpl(null);
        TestAccessImpl.assertFalse((boolean)access.isBuilt());
        access.setServiceBuilder(this.serviceBuilder);
        access.setUrlPath(this.urlPath);
        access.setDataSize((long)this.dataSize);
        access.setDataFormat(this.formatType);
        TestAccessImpl.assertTrue((String)"getServiceBuilder() not as expected.", (access.getServiceBuilder() == this.serviceBuilder ? 1 : 0) != 0);
        String respUrlPath = access.getUrlPath();
        TestAccessImpl.assertTrue((String)("geturlPath() [" + respUrlPath + "] not as expect [" + this.urlPath + "]"), (boolean)respUrlPath.equals(this.urlPath));
        long respDataSize = access.getDataSize();
        TestAccessImpl.assertTrue((String)("getDataSize() [" + respDataSize + "] not as expected [" + this.dataSize + "]."), (respDataSize == (long)this.dataSize ? 1 : 0) != 0);
        DataFormatType respDataFormat = access.getDataFormat();
        TestAccessImpl.assertTrue((String)("getDataFormat [" + respDataFormat + "] not as expected [" + this.formatType + "]."), (respDataFormat == this.formatType ? 1 : 0) != 0);
    }

    public void testBuilderIllegalStateException() {
        AccessImpl accessImpl = new AccessImpl(null);
        accessImpl.setServiceBuilder(this.serviceBuilder);
        accessImpl.setUrlPath(this.urlPath);
        accessImpl.setDataSize((long)this.dataSize);
        accessImpl.setDataFormat(this.formatType);
        try {
            accessImpl.getService();
        }
        catch (IllegalStateException ise) {
            return;
        }
        catch (Exception e) {
            TestAccessImpl.fail((String)("Unexpected exception thrown: " + e.getMessage()));
        }
        TestAccessImpl.fail((String)"Did not throw expected IllegalStateException.");
    }

    public void testBuild() {
        AccessImpl accessImpl = new AccessImpl(null);
        accessImpl.setServiceBuilder(this.serviceBuilder);
        accessImpl.setUrlPath(this.urlPath);
        accessImpl.setDataSize((long)this.dataSize);
        accessImpl.setDataFormat(this.formatType);
        BuilderIssues issues = accessImpl.getIssues();
        if (!issues.isValid()) {
            StringBuilder stringBuilder = new StringBuilder("Invalid access: ").append(issues.toString());
            TestAccessImpl.fail((String)stringBuilder.toString());
        }
        Access access = null;
        try {
            access = accessImpl.build();
        }
        catch (BuilderException e) {
            TestAccessImpl.fail((String)("Build failed: " + e.getMessage()));
        }
        TestAccessImpl.assertTrue((boolean)accessImpl.isBuilt());
    }

    public void testPostBuildGetters() {
        Access access;
        AccessImpl accessImpl = new AccessImpl(null);
        accessImpl.setServiceBuilder(this.serviceBuilder);
        accessImpl.setUrlPath(this.urlPath);
        accessImpl.setDataSize((long)this.dataSize);
        accessImpl.setDataFormat(this.formatType);
        try {
            access = accessImpl.build();
        }
        catch (BuilderException e) {
            TestAccessImpl.fail((String)("Build failed: " + e.getMessage()));
            return;
        }
        TestAccessImpl.assertTrue((boolean)access.getService().getName().equals(this.serviceName));
        TestAccessImpl.assertTrue((boolean)access.getUrlPath().equals(this.urlPath));
        TestAccessImpl.assertTrue((access.getDataSize() == (long)this.dataSize ? 1 : 0) != 0);
        TestAccessImpl.assertTrue((boolean)access.getDataFormat().equals((Object)this.formatType));
    }

    public void testPostBuildIllegalStateException() {
        AccessImpl accessImpl = new AccessImpl(null);
        accessImpl.setServiceBuilder(this.serviceBuilder);
        accessImpl.setUrlPath(this.urlPath);
        accessImpl.setDataSize((long)this.dataSize);
        accessImpl.setDataFormat(this.formatType);
        try {
            Access access = accessImpl.build();
        }
        catch (BuilderException e) {
            TestAccessImpl.fail((String)("Build failed: " + e.getMessage()));
            return;
        }
        try {
            accessImpl.getServiceBuilder();
        }
        catch (IllegalStateException ise) {
            return;
        }
        catch (Exception e) {
            TestAccessImpl.fail((String)("Unexpected exception thrown: " + e.getMessage()));
        }
        TestAccessImpl.fail((String)"Did not throw expected IllegalStateException.");
    }
}

