/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestParserValidate {
    private String dtdUrl = "http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd";
    private String dtdString;
    private DocumentBuilderFactory factory;
    boolean debugJaxp = true;
    boolean schemaValidation = true;
    private String name;
    private String version;
    private HashMap versionHash = new HashMap(10);
    private StringBuffer errMessages = new StringBuffer();
    private StringBuffer fatalMessages = new StringBuffer();
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String XHTML_SCHEMA = "http://www.w3.org/1999/xhtml";

    DocumentBuilder getDocumentBuilder(boolean validate) {
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(validate);
        if (this.schemaValidation) {
            try {
                this.factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            catch (IllegalArgumentException e) {
                System.out.println("***This can happen if the parser does not support JAXP 1.2\n" + e);
            }
        }
        if (this.debugJaxp) {
            TestParserValidate.showFactoryInfo(this.factory);
        }
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            builder.setEntityResolver(new MyEntityResolver());
            builder.setErrorHandler(new MyErrorHandler());
            if (this.debugJaxp) {
                TestParserValidate.showBuilderInfo(builder);
            }
            return builder;
        }
        catch (ParserConfigurationException e) {
            System.out.println("The underlying parser does not support the requested features.");
        }
        catch (FactoryConfigurationError e) {
            System.out.println("Error occurred obtaining Document Builder Factory.");
        }
        return null;
    }

    private static void showFactoryInfo(DocumentBuilderFactory factory) {
        System.out.println("-----------------------");
        System.out.println(" factory.isValidating()=" + factory.isValidating());
        System.out.println(" factory.isNamespaceAware()=" + factory.isNamespaceAware());
        System.out.println(" factory.isIgnoringElementContentWhitespace()=" + factory.isIgnoringElementContentWhitespace());
        System.out.println(" factory.isExpandEntityReferences()=" + factory.isExpandEntityReferences());
        System.out.println(" factory.isIgnoringComments()=" + factory.isIgnoringComments());
        System.out.println(" factory.isCoalescing()=" + factory.isCoalescing());
        System.out.println("-----------------------");
    }

    private static void showBuilderInfo(DocumentBuilder builder) {
        System.out.println("-----------------------");
        System.out.println(" builder.isValidating()=" + builder.isValidating());
        System.out.println(" builder.isNamespaceAware()=" + builder.isNamespaceAware());
        System.out.println("-----------------------");
    }

    public void read(String uriString, boolean validate) {
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            System.out.println("**Fatal:  InvCatalogFactory.readXML URISyntaxException on URL (" + uriString + ") " + e.getMessage() + "\n");
            return;
        }
        DocumentBuilder builder = this.getDocumentBuilder(validate);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        this.version = null;
        Document doc = null;
        try {
            doc = builder.parse(uriString);
            System.out.println("JAXP Parse OK");
        }
        catch (Exception e) {
            this.fatalMessages.append("**Fatal:  InvCatalogFactory.readXML failed\n Exception= " + e.getClass().getName() + " " + e.getMessage() + "\n fatalMessages= " + this.fatalMessages.toString() + "\n errMessages= " + this.errMessages.toString() + "\n");
        }
        if (this.fatalMessages.length() > 0) {
            System.out.println("**Fatal: XML error(s) =\n" + this.fatalMessages.toString() + "\n");
        }
        if (this.errMessages.length() > 0) {
            System.out.println("** Non-Fatal XML Error error(s) =\n" + this.errMessages.toString() + "\n");
        }
    }

    public static void main(String[] arg) {
        TestParserValidate test = new TestParserValidate();
        test.read("file:///C:/dev/thredds/xml/v7/ExampleJoin.xml", true);
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            TestParserValidate.this.errMessages.append("*** XML parser warning=" + e.getMessage() + "\n");
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            TestParserValidate.this.errMessages.append("*** XML parser error=" + e.getMessage() + "\n");
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            TestParserValidate.this.fatalMessages.append("*** XML parser fatalError=" + e.getMessage() + "\n");
        }
    }

    private class MyInputSource
    extends InputSource {
        MyInputSource() {
            this.setCharacterStream(new StringReader(TestParserValidate.this.dtdString));
        }
    }

    private class MyEntityResolver
    implements EntityResolver {
        private MyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (TestParserValidate.this.debugJaxp) {
                System.out.println("** publicId= " + publicId + " systemId=" + systemId);
            }
            return null;
        }
    }
}

