/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.util.List;
import junit.framework.TestCase;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvMetadata;
import thredds.catalog.MetadataType;
import thredds.catalog.TestCatalogAll;
import thredds.catalog.ThreddsMetadata;

public class TestMetadata
extends TestCase {
    private static boolean showValidation = false;
    String urlString = "catalogDev.xml";

    public TestMetadata(String name) {
        super(name);
    }

    public void testXLink() {
        InvCatalogImpl cat = TestCatalogAll.open(this.urlString, true);
        StringBuilder buff = new StringBuilder();
        boolean isValid = cat.check(buff, false);
        System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
        System.out.println(" validation output=\n" + buff);
        String url = this.getMetadataURL(cat, "Zonal", MetadataType.THREDDS);
        assert (url.equals("ZoneMetadata.xml")) : url;
        this.getProject(cat, "Metars", "DIF", "test1");
        this.getProject(cat, "Radars", "DIF", "test2");
        this.getProject(cat, "Zonal", "DIF", "NASA Earth Science Project Office, Ames Research Center");
        this.getKeyword(cat, "Zonal", null, "Ocean Biomass");
        this.getKeyword(cat, "Zonal", "DIF-Discipline", "Earth Science");
    }

    private String getMetadataURL(InvCatalogImpl cat, String name, MetadataType mtype) {
        InvDataset ds = cat.findDatasetByID(name);
        assert (ds != null);
        List list = ds.getMetadata(mtype);
        assert (list != null);
        assert (list.size() > 0);
        InvMetadata m = (InvMetadata)list.get(0);
        assert (m != null);
        System.out.println(name + " = " + m.getXlinkHref());
        assert (m.getXlinkHref() != null);
        return m.getXlinkHref().toString();
    }

    private void getProject(InvCatalogImpl cat, String datasetId, String vocab, String text) {
        InvDataset ds = cat.findDatasetByID(datasetId);
        assert (ds != null);
        List projects = ds.getProjects();
        assert (projects != null);
        assert (projects.size() > 0);
        ThreddsMetadata.Vocab p = (ThreddsMetadata.Vocab)projects.get(0);
        assert (p != null);
        assert (p.getVocabulary().equals(vocab));
        assert (p.getText().equals(text));
    }

    private void getKeyword(InvCatalogImpl cat, String datasetId, String vocab, String text) {
        InvDataset ds = cat.findDatasetByID(datasetId);
        assert (ds != null);
        List list = ds.getKeywords();
        assert (list != null);
        assert (list.size() > 0);
        for (int i = 0; i < list.size(); ++i) {
            ThreddsMetadata.Vocab elem = (ThreddsMetadata.Vocab)list.get(i);
            if (!(vocab == null ? elem.getVocabulary() == null && elem.getText().equals(text) : elem.getVocabulary() != null && elem.getVocabulary().equals(vocab) && elem.getText().equals(text))) continue;
            return;
        }
        assert (false) : "cant find keyword " + text + " vocab " + vocab;
    }

    public void testNamespaces() {
        InvCatalogImpl cat = TestCatalogAll.open("testMetadata.xml", true);
        StringBuilder buff = new StringBuilder();
        boolean isValid = cat.check(buff, false);
        System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
        System.out.println(" validation output=\n" + buff);
        InvMetadata m = this.getMetadataByNamespace(cat, "solve", "somethingdifferent");
        assert (!m.isInherited());
        assert (!m.isThreddsMetadata());
        assert (!m.hasXlink());
        assert (m.getContentObject() != null);
        m = this.getMetadataByType(cat, "solve", MetadataType.ADN);
        assert (!m.isInherited());
        assert (!m.isThreddsMetadata());
        assert (m.hasXlink());
        m = this.getMetadataByType(cat, "solve", MetadataType.DIF);
        assert (!m.isInherited());
        assert (!m.isThreddsMetadata());
        assert (m.hasXlink());
    }

    private InvMetadata getMetadataByType(InvCatalogImpl cat, String name, MetadataType mtype) {
        InvDataset ds = cat.findDatasetByID(name);
        assert (ds != null);
        List list = ds.getMetadata(mtype);
        assert (list != null);
        assert (list.size() > 0);
        InvMetadata m = (InvMetadata)list.get(0);
        assert (m != null);
        return m;
    }

    public InvMetadata getMetadataByNamespace(InvCatalogImpl cat, String name, String wantNs) {
        InvDataset ds = cat.findDatasetByID(name);
        assert (ds != null);
        List mlist = ds.getMetadata();
        assert (mlist != null);
        assert (mlist.size() > 0);
        for (int i = 0; i < mlist.size(); ++i) {
            InvMetadata m = (InvMetadata)mlist.get(i);
            String ns = m.getNamespaceURI();
            if (!ns.equals(wantNs)) continue;
            return m;
        }
        assert (false);
        return null;
    }
}

