/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import junit.framework.TestCase;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.TestCatalogAll;

public class TestCatalogReference
extends TestCase {
    private static boolean showValidation = false;
    String urlString = "testCatref.xml";

    public TestCatalogReference(String name) {
        super(name);
    }

    public void testResolve() {
        InvCatalogImpl cat;
        block4: {
            cat = TestCatalogAll.open(this.urlString, true);
            StringBuilder buff = new StringBuilder();
            boolean isValid = cat.check(buff, false);
            System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            System.out.println(" validation output=\n" + buff);
            try {
                cat.writeXML((OutputStream)System.out);
            }
            catch (IOException ioe) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        assert (this.getCatrefURI(cat.getDatasets(), "catref").equals(TestCatalogAll.makeFilepath("test2.xml"))) : this.getCatrefURI(cat.getDatasets(), "catref");
        assert (this.getCatrefNestedURI(cat, "top", "catref-nested").equals(TestCatalogAll.makeFilepath("test0.xml"))) : this.getCatrefNestedURI(cat, "top", "catref-nested");
    }

    private InvCatalogRef getCatrefNested(InvCatalogImpl cat, String id, String catName) {
        InvDataset ds = cat.findDatasetByID(id);
        assert (ds != null);
        return this.getCatref(ds.getDatasets(), catName);
    }

    private InvCatalogRef getCatref(List list, String name) {
        for (int i = 0; i < list.size(); ++i) {
            InvDataset elem = (InvDataset)list.get(i);
            if (!elem.getName().equals(name)) continue;
            assert (elem instanceof InvCatalogRef);
            InvCatalogRef catref = (InvCatalogRef)elem;
            System.out.println(name + " = " + catref.getXlinkHref() + " == " + catref.getURI());
            return catref;
        }
        return null;
    }

    private String getCatrefURI(List list, String name) {
        InvCatalogRef catref = this.getCatref(list, name);
        if (catref != null) {
            return catref.getURI().toString();
        }
        return null;
    }

    private String getCatrefNestedURI(InvCatalogImpl cat, String id, String catName) {
        return this.getCatrefNested(cat, id, catName).getURI().toString();
    }

    public void testDeferredRead() {
        InvCatalogImpl cat = TestCatalogAll.open(this.urlString, true);
        InvCatalogRef catref = this.getCatref(cat.getDatasets(), "catref");
        assert (!catref.isRead());
        catref = this.getCatrefNested(cat, "top", "catref-nested");
        assert (!catref.isRead());
    }
}

